<?php

return array(

    'name' => 'widget/slideset-gravity',

    'main' => 'YOOtheme\\Widgetkit\\Widget\\Widget',

    'config' => array(

        'name'  => 'slideset-gravity',
        'label' => 'Slideset Gravity',
        'core'  => false,
        'icon'  => 'plugins/widgets/slideset-gravity/widget.svg',
        'view'  => 'plugins/widgets/slideset-gravity/views/widget.php',
        'item'  => array('title', 'content', 'media'),
        'fields' => array(
            array(
                'type' => 'text',
                'name' => 'badge',
                'label' => 'Badge'
            ),
            array(
                'type' => 'tags',
                'name' => 'tag',
                'label' => 'Tags'
            )
        ),
        'settings' => array(
            'nav'                => true,
            'slidenav'           => 'none',
            'slidenav_align'     => 'center',
            'slidenav_contrast'  => false,
            'filter'             => 'text',
            'filter_tags'        => array(),
            'filter_position'    => 'top',
            'filter_align'       => 'left',
            'filter_all'         => true,
            'animation'          => 'slide-horizontal',
            'duration'           => '200',
            'autoplay'           => false,
            'interval'           => '3000',
            'autoplay_pause'     => true,
            'gutter'             => 'default',
            'columns'            => '1',
            'columns_small'      => '2',
            'columns_medium'     => '2',
            'columns_large'      => '4',
            'columns_xlarge'     => '4',
            'panel'              => 'hover',
            'panel_link'         => true,

            'media'              => true,
            'image_width'        => '450',
            'image_height'       => '300',
            'media_align'        => 'teaser',
            'media_border'       => 'none',
            'media_overlay'      => 'icon',
            'overlay_animation'  => 'fade',
            'media_animation'    => 'scale',

            'title'              => true,
            'content'            => true,
            'social_buttons'     => true,
            'title_size'         => 'h4',
            'text_align'         => 'left',
            'link'               => false,
            'link_style'         => 'button',
            'link_text'          => 'Read more',
            'badge'              => true,
            'badge_style'        => 'badge',
            'badge_position'     => 'panel',

            'link_target'        => false,
            'class'              => ''
        )

    ),

    'events' => array(

        'init.site' => function($event, $app) {
            // $app['scripts']->add('uikit-slideset', 'vendor/assets/uikit/js/components/slideset.min.js', array('uikit'));
        },

        'init.admin' => function($event, $app) {
            $app['angular']->addTemplate('slideset-gravity.edit', 'plugins/widgets/slideset-gravity/views/edit.php', true);
        }

    )

);
