<?php

// Animation
$animation = ($settings['animation'] != 'none') ? ',animation:\'' . $settings['animation'] . '\'' : '';

// Tab Position
$tab_position = 'uk-tab-' . $settings['tab_position'];

?>

<ul class="uk-tab <?php echo $tab_position; ?> tm-tab-fullheight" data-uk-tab="{connect:'#wk-<?php echo $settings['id']; ?>'<?php echo $animation; ?>}">
    <?php foreach ($items as $item) : ?>
        <?php

        global $warp;

        $tag_class  = '';
        $tag_name   = '';
        $tag_colors = $warp['config']->get('tag_colors', array());

        if (is_array($item['tags'])) {
            foreach ($item['tags'] as $name) {
                foreach ($tag_colors as $tag_color) {
                    if (in_array(strtolower($name), array_map('strtolower', $tag_color))) {
                        $tag_class = $tag_color['color'];
                        $tag_name = $name;
                    }
                }
            }
        }

        ?>

        <li class="<?php echo $tag_class ?>">
            <a class="tm-news-link" href="">
                <h3 class="tm-tab-title uk-margin-bottom"><?php echo $item['title']; ?></h3>
                
                <?php if ($item['badge']) : ?>
                <span class="uk-hidden-small uk-float-right tm-tag tm-news-tag"><?php echo $item['badge']; ?></span>
                <?php endif; ?>

                <?php if ($tag_name) : ?>
                <span class="uk-hidden-small uk-float-left"><?php echo $tag_name; ?></span>
                <?php endif; ?>

                <?php if ($item['date']) : ?>
                <span class="uk-hidden-small tm-tab-date"><?php echo date('d F', strtotime($item['date'])); ?></span>
                <?php endif; ?>

            </a>
        </li>

    <?php endforeach; ?>
</ul>
