<?php

// Title Size
switch ($settings['title_size']) {
    case 'panel':
        $title_size = 'tm-tabs-title';
        break;
    case 'large':
        $title_size = 'uk-heading-large uk-margin-top-remove';
        break;
    case 'article':
        $title_size = 'uk-article-title uk-margin-top-remove';
        break;
    default:
        $title_size = 'uk-' . $settings['title_size'] . ' uk-margin-top-remove tm-tabs-title';
}

// Content Width
switch ($settings['width']) {
    case '1-3':
        $media_width = '2-3';
        break;
    case '1-2':
        $media_width = '1-2';
        break;
    case '2-3':
        $media_width = '1-3';
        break;
}

$media_width = 'uk-width-large-' . $media_width;

// Panel
$panel = 'uk-panel';
switch ($settings['panel']) {
    case 'box' :
        $panel .= ' uk-panel-box';
        break;
    case 'primary' :
        $panel .= ' uk-panel-box uk-panel-box-primary';
        break;
    case 'secondary' :
        $panel .= ' uk-panel-box uk-panel-box-secondary';
        break;
    case 'hover' :
        $panel .= ' uk-panel-hover';
        break;
    case 'header' :
        $panel .= ' uk-panel-header';
        break;
    case 'space' :
        $panel .= ' uk-panel-space';
        break;
}

// Link Style
switch ($settings['link_style']) {
    case 'button':
        $link_style = 'uk-button';
        break;
    case 'primary':
        $link_style = 'uk-button uk-button-primary';
        break;
    case 'button-large':
        $link_style = 'uk-button uk-button-large';
        break;
    case 'primary-large':
        $link_style = 'uk-button uk-button-large uk-button-primary';
        break;
    case 'button-link':
        $link_style = 'uk-button uk-button-link';
        break;
    default:
        $link_style = '';
}

// Link Target
$link_target = ($settings['link_target']) ? ' target="_blank"' : '';

?>

<ul id="wk-<?php echo $settings['id']; ?>" class="uk-switcher" data-uk-check-display>
    <?php foreach ($items as $item) : ?>

        <?php

        // Content Width
        $content_width = 'uk-width-large-' . $settings['width'];

        if (!$item['media']) {
            $content_width = 'uk-width-medium-1-1';
        }

        // Media
        $attrs  = array('class' => '');
        $width  = $item['media.width'];
        $height = $item['media.height'];

        $attrs['width']  = ($width) ? $width : '';
        $attrs['height'] = ($height) ? $height : '';

        $tab_image = '';
        if ($settings['media'] && $item['media'] && $item->type('media') == 'image') {
        $tab_image = '<img class="uk-overlay-scale" alt="'.strip_tags($item['title']).'" src="'.$item['media'].'" width="'.$item['media.width'].'" height="'.$item['media.width'].'">';
        }

        ?>

        <li>

            <div class="uk-grid uk-grid-collapse">

                <?php if ($item['media'] && $settings['media']) : ?>
                <div class="<?php echo $media_width; ?><?php echo $settings['tab_position'] == 'left' ? ' uk-float-right uk-flex-order-last-medium' : ''; ?>">
                <figure class="uk-overlay uk-overlay-hover">
                    <?php echo $tab_image ?>
                    <figcaption class="uk-overlay-panel uk-overlay-background uk-overlay-top uk-ignore"><?php echo $item['caption']; ?></figcaption>
                    <a class="uk-position-cover" href="<?php echo $item->escape('link'); ?>"></a>
                </figure>
                </div>
                <?php endif; ?>

                <div class="<?php echo $content_width; ?> <?php echo $panel; ?> tm-news-panel uk-overflow-hidden">

                    <?php if ($item['content']) : ?>

                        <?php if ($settings['title']) : ?>
                        <h2 class="<?php echo $title_size; ?>"><?php echo $item['title']; ?></h2>
                        <?php endif; ?>

                        <div class="uk-margin">

                            <?php echo $item['content']; ?>

                            <div class="tm-event-tab-footer">
                                <?php if ($item['link'] && $settings['link']) : ?>
                                <a<?php if($link_style) echo ' class="' . $link_style . '"'; ?> href="<?php echo $item->escape('link'); ?>"<?php echo $link_target; ?>><?php echo $app['translator']->trans($settings['link_text']); ?></a>
                                <?php endif; ?>
                            </div>

                        </div>

                    <?php endif; ?>

                </div>

            </div>
        </li>
    <?php endforeach; ?>
</ul>
