<?php

// Panel
$panel = $settings['panel'] ? 'uk-panel uk-panel-space' : 'uk-panel';

// Media alignment
$media_align = 'tm-image-' . $settings['media_align'];

// Title Size
switch ($settings['title_size']) {
    case 'panel':
        $title_size = '';
        break;
    case 'large':
        $title_size = 'uk-heading-large uk-margin-top-remove';
        break;
    default:
        $title_size = 'uk-' . $settings['title_size'] . ' uk-margin-top-remove';
}

// Link Style
switch ($settings['link_style']) {
    case 'button':
        $link_style = 'uk-button';
        break;
    case 'primary':
        $link_style = 'uk-button uk-button-primary';
        break;
    case 'button-large':
        $link_style = 'uk-button uk-button-large';
        break;
    case 'primary-large':
        $link_style = 'uk-button uk-button-large uk-button-primary';
        break;
    case 'button-link':
        $link_style = 'uk-button uk-button-link';
        break;
    default:
        $link_style = '';
}

// Link Target
$link_target = ($settings['link_target']) ? ' target="_blank"' : '';

$min_height = $settings['min_height'] ? 'style="min-height: '.$settings['min_height'].'px;"' : '';

?>

<ul id="wk-<?php echo $settings['id']; ?>" class="uk-switcher tm-event-tab-content uk-text-<?php echo $settings['text_align']; ?>" data-uk-check-display <?php echo $min_height; ?>>
    <?php foreach ($items as $item) : ?>

        <?php

            $tab_image = '';
            if ($settings['media'] && $item['media'] && $item->type('media') == 'image') {
                $tab_image = '<img class="uk-width-1-1 uk-overlay-scale" alt="'.strip_tags($item['title']).'" src="'.$item['media'].'" width="'.$item['media.width'].'" height="'.$item['media.width'].'">';
            }

        ?>

        <li>
            <div class="uk-grid uk-grid-collapse uk-grid-match" data-uk-grid-match="{target:'> div > a > figure'}">

                <div class="uk-width-large-3-5">
                    <a href="<?php echo $item->escape('link'); ?>">
                        <figure class="uk-width-1-1 uk-overlay uk-overlay-hover">
                            <?php echo $tab_image; ?>
                            <figcaption class="uk-overlay-panel uk-overlay-background uk-overlay-bottom uk-ignore"><?php echo $item['caption']; ?></figcaption>
                        </figure>
                    </a>
                </div>

                <div class="uk-width-large-2-5 uk-panel uk-panel-space uk-overflow-hidden tm-slider-panel">
                    
                    <?php if ($item['title'] && $settings['title']) : ?>
                    <h2 class="tm-slider-title uk-margin-top-remove <?php echo $title_size; ?>"><a class="uk-link-reset" href="<?php echo $item->escape('link'); ?>"><?php echo $item['title']; ?></a></h2>
                    <?php endif; ?>

                    <?php if ($item['content'] && $settings['content']) : ?>
                    <div class="uk-margin"><?php echo $item['content']; ?></div>
                    <?php endif; ?>

                    <div class="tm-event-tab-footer">
                        <?php if ($item['link'] && $settings['link']) : ?>
                        <a<?php if($link_style) echo ' class="' . $link_style . '"'; ?> href="<?php echo $item->escape('link'); ?>"<?php echo $link_target; ?>><?php echo $app['translator']->trans($settings['link_text']); ?></a>
                        <?php endif; ?>
                    </div>
                </div>

            </div>
        </li>
    <?php endforeach ?>
</ul>
