<?php

/*
 * Theme params
 */
foreach (array('suffix', 'panel', 'class', 'title_size', 'center', 'badge', 'icon', 'display') as $var) {
    $$var = isset($params[$var]) ? $params[$var] : null;
}
// Set default panel
if ($panel == '' && in_array($widget->position, array('hero', 'menu-side', 'spotlight', 'top-a', 'top-b', 'top-c', 'top-d', 'top-e', 'bottom-a', 'bottom-b', 'bottom-c', 'bottom-d', 'bottom-e', 'block-footer', 'main-top', 'main-bottom', 'sidebar-a', 'sidebar-b'))) {
    $panel = $this['config']->get("panel_default.{$widget->position}.panel", '');
}
// Set panel for specific positions
else if (in_array($widget->position, array('toolbar-l', 'toolbar-r', 'footer-right', 'footer-left', 'offcanvas'))) {
    $panel = 'uk-panel';
}
// Set badge
$badge = ($badge && $badge['text']) ? '<div class="'.$badge['type'].'">'.$badge['text'].'</div>': '';
// Set icon
$icon  = ($icon && preg_match('/\.(gif|png|jpg|jpeg|svg)$/', $icon)) ? '<img src="'.$this['path']->url('site:').'/'.$icon.'" alt="'.$widget->title.'"> ' : ($icon ? '<i class="'.$icon.' uk-margin-small-right"></i> ':'');
/*
 * Widget params
 */
$content = $widget->content;
$title   = ($widget->showtitle) ? $widget->title : '';
// Set title
if (in_array($widget->position, array('toolbar-l', 'toolbar-r', 'headerbar', 'hero', 'footer-left', 'footer-right', 'breadcrumbs', 'minibar', 'call-action', 'fullscreen', 'side-navigation'))) {
    $title = '';
} elseif ($title && !($widget->position == 'menu')) {
    $title = '<'.$widget->parameter['header_tag'].' class="'.($title_size ? $title_size:'uk-panel-title').' '.$widget->parameter['header_class'].'">'.$icon.$title.'</'.$widget->parameter['header_tag'].'>';
}
// Render menu
if ($widget->menu) {
    // Set menu renderer
    if (isset($params['menu'])) {
        $renderer = $params['menu'];
    } else if (in_array($widget->position, array('menu', 'menu-side'))) {
        $renderer = 'navbar';
    } else if (in_array($widget->position, array('toolbar-l', 'toolbar-r', 'footer-left', 'footer-right'))) {
        $renderer = 'subnav';
        $widget->nav_settings["modifier"] = "uk-subnav-line";
    } else if (in_array($widget->position, array('offcanvas'))) {
        $renderer = 'nav';  
        $widget->nav_settings["modifier"] = "uk-nav-offcanvas";
        $widget->nav_settings["accordion"] = true;
    } else {
        $renderer = 'nav';
        $widget->nav_settings["accordion"] = true;
    }
    $content = $this['menu']->process($widget, array('pre', 'subnav', $renderer, 'post'));
}
// Render widget
if (in_array($widget->position, array('logo', 'logo-small', 'search', 'debug')) || (($widget->position == 'offcanvas') && $widget->menu)) {
    echo $content;
} elseif (in_array($widget->position, array('modal-a', 'modal-b', 'modal-c'))) { 
    $classes = array($panel);
    // Set display
    if ($display) {
        foreach ($display as $device => $visible) {
            if (!$visible) {
                $classes[] = 'uk-hidden-'.$device;
            }
        }
    }
    if ($center) $classes[] = "uk-text-center";
    if ($class)  $classes[] = $class;
    if ($suffix) $classes[] = $suffix;
    echo '
    <div class="uk-modal-dialog uk-modal-dialog-lightbox '.implode(' ', $classes).'">
        <a class="uk-modal-close uk-close uk-close-alt"></a>
        <div class="uk-panel-box">'.$badge.$title.$content.'</div>
    </div>';
} elseif ($widget->position == 'side-navigation') {
    echo $content;
} elseif ($widget->position == 'menu') {
    if ($widget->menu) {
        echo $content;
    } else {
        echo '
        <ul class="uk-navbar-nav uk-hidden-small">
            <li class="uk-parent" data-uk-dropdown>
                <a href="#">'.$title.'</a>
                <div class="uk-dropdown uk-dropdown-navbar">'.$content.'</div>
            </li>
        </ul>';
    }
} else {

    $classes = array($panel);
    $background = $this['config']->get("block.{$widget->position}.block-bg");

    // Set display
    if ($display) {
        foreach ($display as $device => $visible) {
            if (!$visible) {
                $classes[] = 'uk-hidden-'.$device;
            }
        }
    }

    if ($center) $classes[] = "uk-text-center";
    if ($class)  $classes[] = $class;
    if ($suffix) $classes[] = $suffix;

    echo '<div class="'.implode(' ', $classes).'">'.$badge.$title.$content.'</div>';
}