<?php

// get theme configuration
include($this['path']->path('layouts:theme.config.php'));

?>
<!DOCTYPE HTML>
<html lang="<?php echo $this['config']->get('language'); ?>" dir="<?php echo $this['config']->get('direction'); ?>"  data-config='<?php echo $this['config']->get('body_config','{}'); ?>'>

<head>
<?php echo $this['template']->render('head'); ?>
<?php if (trim($this['config']->get('custom_css'))!= '') : ?>
<style>
<?php echo $this['config']->get('custom_css'); ?>
</style>
<?php endif; ?>

<?php if (trim($this['config']->get('custom_files'))!= '') : ?>
<?php echo $this['config']->get('custom_files'); ?>
<?php endif; ?>

</head>

<body id="tm-container" class="<?php echo $this['config']->get('body_classes'); ?>">
  <div class="tm-header-bg"></div>

  <div class="tm-inner-container uk-container uk-container-center">

    <?php if ($this['config']->get('totop_scroller', true)) : ?>

    <div class="uk-sticky-placeholder <?php if ($this['config']->get('totop_scroller_mobile', true)) : ?>uk-hidden-small uk-hidden-touch<?php endif; ?>">
      <div data-uk-smooth-scroll data-uk-sticky="{top:-500}"><a class="tm-totop-scroller uk-animation-slide-bottom" href="#" ></a></div>
    </div>
    <?php endif; ?>

    <?php if ($this['widgets']->count('toolbar-l + toolbar-r + logo + logo-small + headerbar + search + menu + offcanvas + call-action + minibar')) : ?>
    <?php echo $this['template']->render('header.'.$this['config']->get('header_style', 'default').''); ?>
    <?php endif; ?>

    <?php if ($this['widgets']->count('fullscreen')) : ?>
    </div>
    <section id="tm-fullscreen" class="tm-fullscreen uk-width-1-1 <?php echo $grid_classes['fullscreen']; echo $display_classes['fullscreen']; ?>" data-uk-grid-match="{target:'> div > .uk-panel'}" data-uk-grid-margin>
        <?php echo $this['widgets']->render('fullscreen', array('layout'=>$this['config']->get('grid.fullscreen.layout'))); ?></section>
    <div class="tm-inner-container uk-container uk-container-center">
    <?php endif; ?>

    <div class="tm-container">
      <?php if ($this['widgets']->count('menu-side + hero + fullscreen')) :?>
      <div class="tm-banner uk-grid">
        <?php if ($this['widgets']->count('menu-side')) : ?>
        <section id="tm-menu-side" class="tm-menu-side uk-margin-remove uk-width-medium-1-4 <?php echo $grid_classes['menu-side']; echo $display_classes['menu-side']; ?>" data-uk-grid-match="{target:'> div > .uk-panel'}" data-uk-grid-margin><?php echo $this['widgets']->render('menu-side', array('layout'=>$this['config']->get('grid.menu-side.layout'))); ?></section>
        <?php endif; ?>

        <?php if ($this['widgets']->count('hero')) : ?>
        <section id="tm-hero" class="tm-hero uk-margin-remove uk-width-1-1 <?php if ($this['widgets']->count('menu-side')) : ?>uk-width-medium-3-4<?php endif; ?> <?php echo $grid_classes['hero']; echo $display_classes['hero']; ?>" data-uk-grid-match="{target:'> div > .uk-panel'}" data-uk-grid-margin>
            <?php echo $this['widgets']->render('hero', array('layout'=>$this['config']->get('grid.hero.layout'))); ?></section>
        <?php endif; ?>
      </div>
      <?php endif; ?>

      <?php if ($this['widgets']->count('spotlight')) : ?>
      <section id="tm-spotlight" class="<?php echo $grid_classes['spotlight']; echo $display_classes['spotlight']; ?>" data-uk-grid-match="{target:'> div > .uk-panel'}" data-uk-grid-margin><?php echo $this['widgets']->render('spotlight', array('layout'=>$this['config']->get('grid.spotlight.layout'))); ?></section>
      <?php endif; ?>

      <?php if ($this['widgets']->count('top-a')) : ?>
      <section id="tm-top-a" class="<?php echo $grid_classes['top-a']; echo $display_classes['top-a']; ?>" data-uk-grid-match="{target:'> div > .uk-panel'}" data-uk-grid-margin><?php echo $this['widgets']->render('top-a', array('layout'=>$this['config']->get('grid.top-a.layout'))); ?></section>
      <?php endif; ?>

      <?php if ($this['widgets']->count('top-b')) : ?>
      <section id="tm-top-b" class="<?php echo $grid_classes['top-b']; echo $display_classes['top-b']; ?>" data-uk-grid-match="{target:'> div > .uk-panel'}" data-uk-grid-margin><?php echo $this['widgets']->render('top-b', array('layout'=>$this['config']->get('grid.top-b.layout'))); ?></section>
      <?php endif; ?>

      <?php if ($this['widgets']->count('top-c')) : ?>
      <section id="tm-top-c" class="<?php echo $grid_classes['top-c']; echo $display_classes['top-c']; ?>" data-uk-grid-match="{target:'> div > .uk-panel'}" data-uk-grid-margin><?php echo $this['widgets']->render('top-c', array('layout'=>$this['config']->get('grid.top-c.layout'))); ?></section>
      <?php endif; ?>

      <?php if ($this['widgets']->count('top-d')) : ?>
      <section id="tm-top-d" class="<?php echo $grid_classes['top-d']; echo $display_classes['top-d']; ?>" data-uk-grid-match="{target:'> div > .uk-panel'}" data-uk-grid-margin><?php echo $this['widgets']->render('top-d', array('layout'=>$this['config']->get('grid.top-d.layout'))); ?></section>
      <?php endif; ?>

      <?php if ($this['widgets']->count('top-e')) : ?>
      <section id="tm-top-e" class="<?php echo $grid_classes['top-e']; echo $display_classes['top-e']; ?>" data-uk-grid-match="{target:'> div > .uk-panel'}" data-uk-grid-margin><?php echo $this['widgets']->render('top-e', array('layout'=>$this['config']->get('grid.top-e.layout'))); ?></section>
      <?php endif; ?>

      <?php if ($this['widgets']->count('main-top + main-bottom + sidebar-a + sidebar-b + grid') || $this['config']->get('system_output', true)) : ?>
      <div id="tm-middle" class="tm-middle uk-grid" data-uk-grid-match data-uk-grid-margin>

        <?php if ($this['widgets']->count('main-top + main-bottom + grid') || $this['config']->get('system_output', true)) : ?>
        <div class="<?php echo $columns['main']['class'] ?>">

          <?php if ($this['widgets']->count('main-top')) : ?>
          <section id="tm-main-top" class="<?php echo $grid_classes['main-top']; echo $display_classes['main-top']; ?>" data-uk-grid-match="{target:'> div > .uk-panel'}" data-uk-grid-margin><?php echo $this['widgets']->render('main-top', array('layout'=>$this['config']->get('grid.main-top.layout'))); ?></section>
          <?php endif; ?>

          <?php if ($this['widgets']->count('grid')) : ?>
          <div id="tm-content-grid" class="tm-content-grid">
              <div class="tm-grid">
                  <?php echo $this['widgets']->render('grid'); ?>
              </div>
          </div>
          <?php endif; ?>

          <?php if ($this['config']->get('system_output', true)) : ?>
          <main id="tm-content" class="tm-content">
            <?php if ($this['widgets']->count('breadcrumbs')) : ?>
            <?php echo $this['widgets']->render('breadcrumbs'); ?>
            <?php endif; ?>
            <?php echo $this['template']->render('content'); ?>
          </main>
          <?php else : ?>
          <main id="tm-content" class="tm-content tm-content-blank"><?php echo $this['template']->render('content-message'); ?></main>
          <?php endif; ?>

          <?php if ($this['widgets']->count('main-bottom')) : ?>
          <section id="tm-main-bottom" class="<?php echo $grid_classes['main-bottom']; echo $display_classes['main-bottom']; ?>" data-uk-grid-match="{target:'> div > .uk-panel'}" data-uk-grid-margin><?php echo $this['widgets']->render('main-bottom', array('layout'=>$this['config']->get('grid.main-bottom.layout'))); ?></section>
          <?php endif; ?>

        </div>
        <?php endif; ?>

        <?php foreach($columns as $name => &$column) : ?>
        <?php if ($name != 'main' && $this['widgets']->count($name)) : ?>
        <aside class="<?php echo $column['class'] ?>"><?php echo $this['widgets']->render($name) ?></aside>
        <?php endif ?>
        <?php endforeach ?>

      </div>
      <?php endif; ?>

      <?php if ($this['widgets']->count('bottom-a')) : ?>
      <section id="tm-bottom-a" class="<?php echo $grid_classes['bottom-a']; echo $display_classes['bottom-a']; ?>" data-uk-grid-match="{target:'> div > .uk-panel'}" data-uk-grid-margin><?php echo $this['widgets']->render('bottom-a', array('layout'=>$this['config']->get('grid.bottom-a.layout'))); ?></section>
      <?php endif; ?>

      <?php if ($this['widgets']->count('bottom-b')) : ?>
      <section id="tm-bottom-b" class="<?php echo $grid_classes['bottom-b']; echo $display_classes['bottom-b']; ?>" data-uk-grid-match="{target:'> div > .uk-panel'}" data-uk-grid-margin><?php echo $this['widgets']->render('bottom-b', array('layout'=>$this['config']->get('grid.bottom-b.layout'))); ?></section>
      <?php endif; ?>

      <?php if ($this['widgets']->count('bottom-c')) : ?>
      <section id="tm-bottom-c" class="<?php echo $grid_classes['bottom-c']; echo $display_classes['bottom-c']; ?>" data-uk-grid-match="{target:'> div > .uk-panel'}" data-uk-grid-margin><?php echo $this['widgets']->render('bottom-c', array('layout'=>$this['config']->get('grid.bottom-c.layout'))); ?></section>
      <?php endif; ?>

      <?php if ($this['widgets']->count('bottom-d')) : ?>
      <section id="tm-bottom-d" class="<?php echo $grid_classes['bottom-d']; echo $display_classes['bottom-d']; ?>" data-uk-grid-match="{target:'> div > .uk-panel'}" data-uk-grid-margin><?php echo $this['widgets']->render('bottom-d', array('layout'=>$this['config']->get('grid.bottom-d.layout'))); ?></section>
      <?php endif; ?>

      <?php if ($this['widgets']->count('bottom-e')) : ?>
      <section id="tm-bottom-e" class="<?php echo $grid_classes['bottom-e']; echo $display_classes['bottom-e']; ?>" data-uk-grid-match="{target:'> div > .uk-panel'}" data-uk-grid-margin><?php echo $this['widgets']->render('bottom-e', array('layout'=>$this['config']->get('grid.bottom-e.layout'))); ?></section>
      <?php endif; ?>

    </div>
  </div>

  <?php if ($this['widgets']->count('block-footer')) : ?>
  <div id="tm-block-footer">
    <div class="uk-container uk-container-center">
      <section class=" <?php echo $grid_classes['block-footer']; echo $display_classes['block-footer']; ?>" data-uk-grid-match="{target:'> div > .uk-panel'}" data-uk-grid-margin><?php echo $this['widgets']->render('block-footer', array('layout'=>$this['config']->get('grid.block-footer.layout'))); ?></section>
    </div>
  </div>
  <?php endif; ?>

  <?php if ($this['widgets']->count('footer-left + footer-right + debug')) : ?>
  <footer id="tm-footer" class="tm-footer uk-position-relative">
    <div class="uk-container uk-container-center">
      <div class="uk-flex uk-flex-middle uk-flex-space-between uk-text-center-small">

        <div class="tm-footer-left">
        <?php echo $this['widgets']->render('footer-left'); ?>
        </div>

        <div class="tm-footer-right">
        <?php echo $this['widgets']->render('footer-right'); ?>
        </div>

        <?php echo $this['widgets']->render('debug'); ?>
      </div>
    </div>

  </footer>
  <?php endif; ?>

  <?php echo $this->render('footer'); ?>

  <?php if ($this['widgets']->count('modal-a')) : ?>
  <div id="modal-a" class="uk-modal">
  <?php echo $this['widgets']->render('modal-a'); ?>
  </div>
  <?php endif; ?>

  <?php if ($this['widgets']->count('modal-b')) : ?>
  <div id="modal-b" class="uk-modal">
  <?php echo $this['widgets']->render('modal-b'); ?>
  </div>
  <?php endif; ?>

  <?php if ($this['widgets']->count('modal-c')) : ?>
  <div id="modal-c" class="uk-modal">
  <?php echo $this['widgets']->render('modal-c'); ?>
  </div>
  <?php endif; ?>

  <?php if ($this['widgets']->count('offcanvas')) : ?>
  <div id="offcanvas" class="uk-offcanvas">
    <div class="uk-offcanvas-bar uk-offcanvas-bar-flip"><?php echo $this['widgets']->render('offcanvas'); ?></div>
  </div>
  <?php else : ?>
  <div class="uk-badge-warning">please publish modules in <code>offcanvas</code> module position</div>
  <?php endif; ?>

  <?php if ($this['widgets']->count('side-navigation')) : ?>  
      <div class="tm-navigation-bar uk-hidden-small uk-hidden-medium">
          <?php echo $this['widgets']->render('side-navigation'); ?>
      </div>  
  <?php endif; ?>

<?php if (trim($this['config']->get('custom_js'))!= '')  : ?>
<script style="text/javascript" defer>(function($){$(document).on('ready', function() {<?php echo $this['config']->get('custom_js'); ?>});})(jQuery);</script>
<?php endif; ?>

</body>
</html>