<?php

// include config and layout
$base = dirname(dirname(__FILE__));
include($base.'/config.php');

// no direct access
defined('_JEXEC') or die;

JHtml::_('behavior.keepalive');

?>

<form class="uk-form" action="<?php echo JRoute::_('index.php', true, $params->get('usesecure')); ?>" method="post">

	<?php if ($params->get('pretext')) : ?>
	<div class="uk-form-row">
		<?php echo $params->get('pretext'); ?>
	</div>
	<?php endif; ?>

	<div class="uk-form-row">
		<div class="uk-form-icon uk-width-1-1">
			<i class="uk-icon-grav-user2"></i>
			<input class="uk-width-1-1" type="text" name="username" size="18" placeholder="<?php echo JText::_('MOD_LOGIN_VALUE_USERNAME') ?>">
		</div>
	</div>

	<div class="uk-form-row">
		<div class="uk-form-password uk-form-icon uk-width-1-1">
			<i class="uk-icon-grav-key2"></i>
			<input class="uk-width-1-1" type="password" name="password" size="18" placeholder="<?php echo JText::_('JGLOBAL_PASSWORD') ?>">
			<a href="" class="uk-form-password-toggle" data-uk-form-password="{lblShow:'&lt;i class=&quot;uk-icon-eye&quot;&gt;&lt;/i&gt;', lblHide:'&lt;i class=&quot;uk-icon-eye-slash&quot;&gt;&lt;/i&gt;'}"><i class="uk-icon-eye"></i></a>
		</div>
	</div>

	<?php if (count($twofactormethods) > 1): ?>
	<div class="uk-form-row">
		<input class="uk-width-1-1" type="text" name="secretkey" tabindex="0" size="18" placeholder="<?php echo JText::_('JGLOBAL_SECRETKEY') ?>" />
	</div>
	<?php endif; ?>
	
	<div class="uk-form-row">
		<button class="uk-button uk-button-primary uk-width-1-1" value="<?php echo JText::_('JLOGIN') ?>" name="Submit" type="submit"><?php echo JText::_('JLOGIN') ?></button>
	</div>

	<?php if (JPluginHelper::isEnabled('system', 'remember')) : ?>
	<div class="uk-form-row uk-hidden">
		<?php $number = rand(); ?>
		<label for="modlgn-remember-<?php echo $number; ?>"><?php echo JText::_('MOD_LOGIN_REMEMBER_ME') ?></label>
		<input id="modlgn-remember-<?php echo $number; ?>" type="checkbox" name="remember" value="yes" checked>
	</div>
	<?php endif; ?>

	<ul class="uk-list uk-margin-bottom-remove">
		<li><a href="<?php echo JRoute::_('index.php?option=com_users&view=reset'); ?>"><?php echo JText::_('MOD_LOGIN_FORGOT_YOUR_PASSWORD'); ?></a></li>
		<li><a href="<?php echo JRoute::_('index.php?option=com_users&view=remind'); ?>"><?php echo JText::_('MOD_LOGIN_FORGOT_YOUR_USERNAME'); ?></a></li>
		<?php $usersConfig = JComponentHelper::getParams('com_users'); ?>
		<?php if ($usersConfig->get('allowUserRegistration')) : ?>
		<li><a href="<?php echo JRoute::_('index.php?option=com_users&view=registration'); ?>"><?php echo JText::_('MOD_LOGIN_REGISTER'); ?></a></li>
		<?php endif; ?>
	</ul>
	
	<?php if($params->get('posttext')) : ?>
	<div class="uk-form-row">
		<?php echo $params->get('posttext'); ?>
	</div>
	<?php endif; ?>
	
	<input type="hidden" name="option" value="com_users">
	<input type="hidden" name="task" value="user.login">
	<input type="hidden" name="return" value="<?php echo $return; ?>">
	<?php echo JHtml::_('form.token'); ?>
</form>
