<?php

// include config and layout
$base = dirname(dirname(__FILE__));
include($base.'/config.php');

// no direct access  
defined('_JEXEC') or die;  

?>  
<ul class="uk-breadcrumb"><?php  

    //Adding JSON-LD:  
    $json_ld='{  
                    "@context": "https://schema.org",  
                    "@type": "BreadcrumbList",  
                    "itemListElement": [%DATA%]  
                }';  
    $json_elements='';  

    if (!$params->get('showLast', 1)) array_pop($list);  

    $count = count($list);  

    for ($i = 0; $i < $count; $i ++) {  

        // clean subtitle from breadcrumb  
        if ($pos = strpos($list[$i]->name, '||')) {  
            $name = trim(substr($list[$i]->name, 0, $pos));  
        } else {  
            $name = $list[$i]->name;  
        }  

        if (!empty($list[$i]->link))  
            $url=$list[$i]->link;  
        else  
            $url="";  

        // mark-up last item as strong  
        if ($i < $count-1) {  
            if (!empty($list[$i]->link)) {  
                echo '<li><a href="'.$list[$i]->link.'">'.$name.'</a></li>';  
            } else {  
                echo '<li><span>'.$name.'</span></li>';  
            }  
        } else {  
            echo '<li class="uk-active"><span>'.$name.'</span></li>';  
        }  

        //adding JSON-LD info:        
        if ($i!=0)  
            $json_elements.=",";  
        $json_elements.='{  
                            "@type": "ListItem",  
                            "position": '.($i+1).',  
                            "item": {  
                                "@id": "'.$url.'",  
                                "name": "'.$name.'"  
                            }  
                        }';  
    }  

    //Combining JSON-LD:  
    $json_ld=str_replace('%DATA%',$json_elements,$json_ld);  
    //Adding info to header:  
    $doc = JFactory::getDocument();  
    $doc->addScriptDeclaration($json_ld,"application/ld+json");  
?>  
</ul>