<?php  defined('_JEXEC') or die('Restricted access');
	$user = JFactory::getUser();
?>

<section id="k2Container" class="userView<?php if($this->params->get('pageclass_sfx')) echo ' '.$this->params->get('pageclass_sfx'); ?>">
	<?php if($this->params->get('show_page_title') && $this->params->get('page_title')!=$this->user->name): ?>
	<header>
		<h1 class="uk-article-title"><?php echo $this->escape($this->params->get('page_title')); ?></h1>
	</header>
	<?php endif; ?>

    <?php if ($this->params->get('userImage') || $this->params->get('userName') || $this->params->get('userDescription') || $this->params->get('userURL') || $this->params->get('userEmail')): ?>
	    <div class="uk-block uk-block-muted uk-border-rounded">
			<div class="uk-container">
				<div class="itemAuthorBlock">

		        <?php if ($this->params->get('userImage') && !empty($this->user->avatar)): ?>
		        <div class="tm-avatar uk-align-right uk-margin-large-top uk-margin-large-left">
					<img class="uk-thumbnail uk-border-rounded" src="<?php echo $this->user->avatar; ?>" alt="<?php echo $this->user->name; ?>" style="width:<?php echo $this->params->get('userImageWidth'); ?>px;height:auto;" />
		        </div>
		        <?php endif; ?>
        
		        <div class="itemAuthorDetails" itemprop="author" itemscope itemtype="https://schema.org/Person">
			        <?php if ($this->params->get('userName')): ?>
			        <h3 class="uk-module-title" itemprop="name"><a rel="author" href="<?php echo $this->user->link; ?>"><?php echo $this->user->name; ?></a></h3>
			        <?php endif; ?>
			        
			        <?php if ($this->params->get('userDescription') && isset($this->user->profile->description)): ?>
			        	<?php echo $this->user->profile->description; ?>
			        <?php endif; ?>
			        

					<?php if ($this->params->get('userURL') && isset($this->user->profile->url)): ?>
					<span class="itemAuthorURL">
						<?php echo JText::_('K2_WEBSITE_URL'); ?>: <a rel="me" href="<?php echo $this->user->profile->url; ?>" target="_blank"><?php echo $this->user->profile->url; ?></a>
					</span>
					<?php endif; ?>
					
					<?php if ($this->params->get('userEmail')): ?>
						<span class="itemAuthorEmail"> <?php echo JText::_('K2_EMAIL'); ?>: <?php echo JHTML::_('Email.cloak', $this->user->email); ?> </span>
					<?php endif; ?>
		        </div>
		        <?php echo $this->user->event->K2UserDisplay; ?>
    			</div>
    		</div>
    	</div>

	<?php endif; ?>

		<?php if(count($this->items)): ?>
		<section class="itemList">
		<?php foreach ($this->items as $item): ?>
			<article class="itemView<?php if(!$item->published || ($item->publish_up != $this->nullDate && $item->publish_up > $this->now) || ($item->publish_down != $this->nullDate && $item->publish_down < $this->now)) echo ' itemViewUnpublished'; ?><?php echo ($item->featured) ? ' itemIsFeatured' : ''; ?> uk-clearfix"> 

				<?php echo $item->event->BeforeDisplay; ?>
				<?php echo $item->event->K2BeforeDisplay; ?>

				<?php if($item->params->get('userItemImage') && !empty($item->imageGeneric)): ?>
				<div class="itemImageBlock tm-article-featured-image"> 
					<a class="itemImage uk-overlay uk-overlay-hover" href="<?php echo $item->link; ?>" title="<?php if(!empty($item->image_caption)) echo K2HelperUtilities::cleanHtml($item->image_caption); else echo K2HelperUtilities::cleanHtml($item->title); ?>"> 
						<img class="uk-overlay-scale" src="<?php echo $item->imageGeneric; ?>" alt="<?php if(!empty($item->image_caption)) echo K2HelperUtilities::cleanHtml($item->image_caption); else echo K2HelperUtilities::cleanHtml($item->title); ?>" width="<?php echo $item->params->get('itemImageGeneric'); ?>" height="auto" >
						<div class="uk-overlay-panel uk-overlay-background uk-overlay-icon uk-overlay-fade"></div>
					</a>
				</div>
				<?php endif; ?>

				<header>
				<?php if($item->params->get('userItemTitle')): ?>
					<h2 class="uk-article-title">
					<?php if ($item->params->get('userItemTitleLinked') && $item->published): ?>
					<a href="<?php echo $item->link; ?>"> <?php echo $item->title; ?> </a>
					<?php else: ?>
					<?php echo $item->title; ?>
					<?php endif; ?>
					<?php if(!$item->published || ($item->publish_up != $this->nullDate && $item->publish_up > $this->now) || ($item->publish_down != $this->nullDate && $item->publish_down < $this->now)): ?>
					<sup><?php echo JText::_('K2_UNPUBLISHED'); ?></sup>
					<?php endif; ?>
					</h2>
				<?php endif; ?>
				</header>

				<?php echo $item->event->AfterDisplayTitle; ?>
				<?php echo $item->event->K2AfterDisplayTitle; ?>

				<div class="uk-article-meta">

					<!-- item date created -->
					<?php if($item->params->get('userItemDateCreated')): ?>
					<span class="itemDateCreated"><?php echo JHTML::_('date', $item->created, JText::_('d F Y')); ?> |</span>
					<?php endif; ?>

					<!-- item category -->
					<?php if($item->params->get('userItemCategory')): ?>
					<span class="itemCategory"> <span><?php echo JText::_('K2_PUBLISHED_IN'); ?></span> <a href="<?php echo $item->category->link; ?>"><?php echo $item->category->name; ?></a> </span>
					<?php endif; ?>

					<!-- item comment counter -->
					<?php if($item->params->get('userItemCommentsAnchor') && ( ($item->params->get('comments') == '2' && !$this->user->guest) || ($item->params->get('comments') == '1')) ): ?>
					<span class="itemComments">
						<?php if(!empty($item->event->K2CommentsCounter)): ?>
						<!-- K2 Plugins: K2CommentsCounter --> 
						<?php echo $item->event->K2CommentsCounter; ?>
						<?php else: ?>
						<?php if($item->numOfComments > 0): ?>
						<a href="<?php echo $item->link; ?>#itemCommentsAnchor"><i class="uk-icon-comment"></i> <?php echo $item->numOfComments; ?> <?php echo ($item->numOfComments>1) ? JText::_('K2_COMMENTS') : JText::_('K2_COMMENT'); ?> </a>
						<?php else: ?>
						<a href="<?php echo $item->link; ?>#itemCommentsAnchor"><i class="uk-icon-comment-alt"></i> <?php echo JText::_('K2_BE_THE_FIRST_TO_COMMENT'); ?> </a>
						<?php endif; ?>
						<?php endif; ?>
					</span>
					<?php endif; ?>
				</div>

			<div class="itemBody"> <?php echo $item->event->BeforeDisplayContent; ?> <?php echo $item->event->K2BeforeDisplayContent; ?>
				<?php if($item->params->get('userItemIntroText')): ?>
				<div class="itemIntroText"><?php echo $item->introtext; ?></div>
				<?php endif; ?>

				<?php echo $item->event->AfterDisplayContent; ?> 
				<?php echo $item->event->K2AfterDisplayContent; ?>

				<!-- item tags -->
				<?php if($item->params->get('userItemTags') && count($item->tags)): ?>
				<div class="itemTagsBlock">
					<ul class="itemTags uk-padding-remove">
						<?php foreach ($item->tags as $tag): ?>
						<li><a class="tm-tag" href="<?php echo $tag->link; ?>"><span class="tag"><?php echo $tag->name; ?></span></a></li>
						<?php endforeach; ?>
					</ul>
				</div>
				<?php endif; ?>

			</div>

			<?php echo $item->event->AfterDisplay; ?>
			<?php echo $item->event->K2AfterDisplay; ?>

			</article>
		<?php endforeach; ?>
		</section>
		<?php if($this->params->get('userFeedIcon',1)): ?>
		<a class="k2FeedIcon uk-icon-rss" href="<?php echo $this->feed; ?>"> <?php echo JText::_('K2_SUBSCRIBE_TO_THIS_RSS_FEED'); ?></a>
		<?php endif; ?>
		<?php if($this->pagination->getPagesLinks()): ?>
		<?php echo $this->pagination->getPagesLinks(); ?>
		<?php endif; ?>
		<?php endif; ?>
</section>