<?php

	defined('_JEXEC') or die('Restricted access');
?>

<section id="k2Container" class="genericView<?php if($this->params->get('pageclass_sfx')) echo ' '.$this->params->get('pageclass_sfx'); ?>">
	<?php if($this->params->get('show_page_title')): ?>
	<header>
		<h1 class="uk-article-title" itemprop="name"><?php echo $this->escape($this->params->get('page_title')); ?></h1>
	</header>
	<?php endif; ?>

	<?php if(count($this->items)): ?>
	<section class="itemList">
		<?php foreach($this->items as $item): ?>
		<article class="itemView" itemscope itemtype="https://schema.org/Article">

			<?php if($item->params->get('genericItemImage') && !empty($item->imageGeneric)): ?>
				<div class="itemImageBlock tm-article-featured-image"> 
					<a class="itemImage uk-overlay uk-overlay-hover" href="<?php echo $item->link; ?>" title="<?php if(!empty($item->image_caption)) echo $item->image_caption; else echo $item->title; ?>"> 
						<img class="uk-overlay-scale" src="<?php echo $item->imageGeneric; ?>" alt="<?php if(!empty($item->image_caption)) echo $item->image_caption; else echo $item->title; ?>" width="<?php echo $item->params->get('itemImageGeneric'); ?>" height"auto">
						<div class="uk-overlay-panel uk-overlay-background uk-overlay-icon uk-overlay-fade"></div>
					</a>
				</div>
			<?php endif; ?>

			<?php if($item->params->get('genericItemTitle')): ?>
			<h1 class="uk-article-title" itemprop="name">
					<?php if ($item->params->get('genericItemTitleLinked')): ?>
					<a href="<?php echo $item->link; ?>"> <?php echo $item->title; ?> </a>
					<?php else: ?>
					<?php echo $item->title; ?>
					<?php endif; ?>
			</h1>
			<?php endif; ?>

			<?php if($item->params->get('genericItemCategory') || $item->params->get('tagItemDateCreated',1)): ?>
			<div class="uk-article-meta">
				<?php if($item->params->get('tagItemDateCreated',1)): ?>
				<span class="itemDateCreated"><?php echo JHTML::_('date', $item->created, JText::_('d F Y')); ?> |</span>
				<?php endif; ?>

				<?php if($item->params->get('genericItemCategory')) : ?>
				<span class="itemCategory"> <span><?php echo JText::_('K2_PUBLISHED_IN'); ?></span> <a href="<?php echo $item->category->link; ?>"><?php echo $item->category->name; ?></a> </span>
				<?php endif; ?>
			</div>
			<?php endif; ?>
			
			<div class="itemBody" itemprop="articleBody">

				<?php if($item->params->get('genericItemIntroText')): ?>
				<div class="itemIntroText tm-dropcap-block"> <?php echo $item->introtext; ?> </div>
				<?php endif; ?>

				<?php if($item->params->get('genericItemExtraFields') && count($item->extra_fields)): ?>
				<div class="itemExtraFields uk-panel uk-panel-box">
					<h4 class="uk-panel-title"><?php echo JText::_('K2_ADDITIONAL_INFO'); ?></h4>
					<ul>
						<?php foreach ($item->extra_fields as $key=>$extraField): ?>
						<li class="<?php echo ($key%2) ? "odd" : "even"; ?> type<?php echo ucfirst($extraField->type); ?> group<?php echo $extraField->group; ?>"> <span class="itemExtraFieldsLabel"><?php echo $extraField->name; ?></span> <span class="itemExtraFieldsValue"><?php echo ($extraField->type=='date')?JHTML::_('date', $extraField->value, JText::_('K2_DATE_FORMAT_LC')):$extraField->value; ?></span> </li>
						<?php endforeach; ?>
					</ul>
				</div>
				<?php endif; ?>
				<?php if ($item->params->get('genericItemReadMore')): ?>
				<a class="uk-button uk-button-primary" href="<?php echo $item->link; ?>"> 
					<?php echo JText::_('K2_READ_MORE'); ?>
				</a>
				<?php endif; ?>
			</div>
								
		</article>
		<?php endforeach; ?>
	</section>
	
	<?php if($this->params->get('tagFeedIcon',1)): ?>
	<a class="k2FeedIcon uk-icon-rss" href="<?php echo $this->feed; ?>"> <?php echo JText::_('K2_SUBSCRIBE_TO_THIS_RSS_FEED'); ?></a>
	<?php endif; ?>
	<?php if($this->pagination->getPagesLinks()): ?>
	<?php echo $this->pagination->getPagesLinks(); ?>
	<?php endif; ?>
	<?php endif; ?>
</section>
