<?php defined('_JEXEC') or die('Restricted access');

// Define default image size (do not change)
K2HelperUtilities::setDefaultImage($this->item, 'itemlist', $this->params);

?>

<article class="itemView group<?php echo ucfirst($this->item->itemGroup); ?><?php echo ($this->item->featured) ? ' itemIsFeatured' : ''; ?><?php if($this->item->params->get('pageclass_sfx')) echo ' '.$this->item->params->get('pageclass_sfx'); ?>"> <?php echo $this->item->event->BeforeDisplay; ?> <?php echo $this->item->event->K2BeforeDisplay; ?>

	<?php if($this->item->params->get('catItemImage') && !empty($this->item->image)): ?>
		<div class="itemImageBlock tm-article-featured-image">
			<a class="itemImage uk-overlay uk-overlay-hover" href="<?php echo $this->item->link; ?>" title="<?php if(!empty($this->item->image_caption)) echo K2HelperUtilities::cleanHtml($this->item->image_caption); else echo K2HelperUtilities::cleanHtml($this->item->title); ?>"> 
				<img class="uk-overlay-scale" src="<?php echo $this->item->image; ?>" alt="<?php if(!empty($this->item->image_caption)) echo K2HelperUtilities::cleanHtml($this->item->image_caption); else echo K2HelperUtilities::cleanHtml($this->item->title); ?>" width="<?php echo $this->item->imageWidth; ?>" height="auto">
				<div class="uk-overlay-panel uk-overlay-background uk-overlay-icon uk-overlay-fade"></div>
			</a>
		</div>
	<?php endif; ?>

	<?php if($this->item->params->get('catItemTitle')): ?>
		<h2 class="uk-article-title">
			<?php if ($this->item->params->get('catItemTitleLinked')): ?>
			<a href="<?php echo $this->item->link; ?>"><?php echo $this->item->title; ?></a>
			<?php else: ?>
			<?php echo $this->item->title; ?>
			<?php endif; ?>
			<?php if($this->item->params->get('catItemFeaturedNotice') && $this->item->featured): ?>
			<sup class="uk-badge uk-badge-warning"><?php echo JText::_('K2_FEATURED'); ?></sup>
			<?php endif; ?>
		</h2>
	<?php endif; ?>

	<?php echo $this->item->event->AfterDisplayTitle; ?> <?php echo $this->item->event->K2AfterDisplayTitle; ?>


	<div class="uk-article-meta">
			
		<!-- item create date -->
		<?php if($this->item->params->get('catItemDateCreated')): ?>
		<span class="itemDateCreated"><?php echo JHTML::_('date', $this->item->created, JText::_('d F Y')); ?> |</span>
		<?php endif; ?>

		<!-- item author -->
		<?php if($this->item->params->get('catItemAuthor')): ?>
		<span class="itemAuthor"> <?php echo K2HelperUtilities::writtenBy($this->item->author->profile->gender); ?> <a rel="author" href="<?php echo $this->item->author->link; ?>"><?php echo '<span>'.$this->item->author->name.'</span>'; ?> </a> | </span>
		<?php endif; ?>

		<!-- item category -->
		<?php if($this->item->params->get('catItemCategory')): ?>
		<span class="itemCategory"> <span><?php echo JText::_('K2_PUBLISHED_IN'); ?></span> <a href="<?php echo $this->item->category->link; ?>"><?php echo $this->item->category->name; ?></a> </span>
		<?php endif; ?>

		<!-- item hits -->
		<?php if($this->item->params->get('catItemHits')): ?>
		<span class="itemHits"><?php echo JText::_('K2_READ'); ?>: <?php echo $this->item->hits; ?> <?php echo JText::_('K2_TIMES'); ?></span>
		<?php endif; ?>

		<!-- item comments count -->
		<?php if($this->item->params->get('catItemCommentsAnchor')): ?>
		<span class="itemComments"> 
		<?php if(!empty($this->item->event->K2CommentsCounter)): ?>
			<?php echo $this->item->event->K2CommentsCounter; ?>
		<?php else: ?>
			<?php if($this->item->numOfComments > 0): ?>
			<a href="<?php echo $this->item->link; ?>#itemCommentsAnchor"><i class="uk-icon-comment"></i>
				<?php echo $this->item->numOfComments; ?> <?php echo ($this->item->numOfComments>1) ? JText::_('K2_COMMENTS') : JText::_('K2_COMMENT'); ?>
			</a>
			<?php else: ?>
			<a href="<?php echo $this->item->link; ?>#itemCommentsAnchor"><i class="uk-icon-comment-alt"></i>
				<?php echo JText::_('K2_BE_THE_FIRST_TO_COMMENT'); ?>
			</a>
			<?php endif; ?>
		<?php endif; ?>
		</span>
		<?php endif; ?>

		<!-- Item Edit -->
		<?php if(isset($this->item->editLink)): ?>
		<a class="catItemEditLink modal" href="<?php echo $this->item->editLink; ?>" data-uk-lightbox="{width: 1000, height: 800}" data-lightbox-type="iframe"><?php echo JText::_('K2_EDIT_ITEM'); ?></a>
		<?php endif; ?>

		<!-- Item rating -->
		<?php if($this->item->params->get('catItemRating')): ?>
		<div class="itemRatingBlock"> 
			
			<?php
				$itemRating = round(($this->item->votingPercentage / 2), 0); 
				$itemRating = round(($itemRating / 10), 1);

				$itemRatingCount = preg_replace('/\D/', '', $this->item->numOfvotes);
			?>

			<div class="itemRatingForm">
				<ul class="itemRatingList">
					<li class="itemCurrentRating" id="itemCurrentRating<?php echo $this->item->id; ?>" style="width:<?php echo $this->item->votingPercentage; ?>%;"></li>
					<li><a href="#" rel="<?php echo $this->item->id; ?>" title="<?php echo JText::_('K2_1_STAR_OUT_OF_5'); ?>" class="one-star uk-icon-star"></a></li>
					<li><a href="#" rel="<?php echo $this->item->id; ?>" title="<?php echo JText::_('K2_2_STARS_OUT_OF_5'); ?>" class="two-stars uk-icon-star"></a></li>
					<li><a href="#" rel="<?php echo $this->item->id; ?>" title="<?php echo JText::_('K2_3_STARS_OUT_OF_5'); ?>" class="three-stars uk-icon-star"></a></li>
					<li><a href="#" rel="<?php echo $this->item->id; ?>" title="<?php echo JText::_('K2_4_STARS_OUT_OF_5'); ?>" class="four-stars uk-icon-star"></a></li>
					<li><a href="#" rel="<?php echo $this->item->id; ?>" title="<?php echo JText::_('K2_5_STARS_OUT_OF_5'); ?>" class="five-stars uk-icon-star"></a></li>
				</ul>
				<div id="itemRatingLog<?php echo $this->item->id; ?>" class="itemRatingLog"><?php echo $this->item->numOfvotes; ?></div>
			</div>
		</div>
		<?php endif; ?>

	</div>

	<?php if($this->item->params->get('catItemDateModified') && $this->item->created != $this->item->modified): ?>
	<div class="itemDateModified"> <?php echo JText::_('K2_LAST_MODIFIED_ON'); ?> <?php echo JHTML::_('date', $this->item->modified, JText::_('K2_DATE_FORMAT_LC2')); ?> </div>
	<?php endif; ?>
	<?php echo $this->item->event->AfterDisplay; ?> <?php echo $this->item->event->K2AfterDisplay; ?>

	<div class="itemBlock">
			
		<div class="itemBody"> <?php echo $this->item->event->BeforeDisplayContent; ?> <?php echo $this->item->event->K2BeforeDisplayContent; ?>
			<?php if($this->item->params->get('catItemIntroText')): ?>
			<div class="itemIntroText tm-dropcap-block"> <?php echo $this->item->introtext; ?> </div>
			<?php endif; ?>
			<?php if($this->item->params->get('catItemExtraFields') && count($this->item->extra_fields)): ?>
			<div class="itemExtraFields">
				<h4><?php echo JText::_('K2_ADDITIONAL_INFO'); ?></h4>
				<ul>
						<?php foreach ($this->item->extra_fields as $key=>$extraField): ?>
						<?php if($extraField->value): ?>
						<li class="<?php echo ($key%2) ? "odd" : "even"; ?> type<?php echo ucfirst($extraField->type); ?> group<?php echo $extraField->group; ?>"> <span class="itemExtraFieldsLabel"><?php echo $extraField->name; ?></span> <span class="itemExtraFieldsValue"><?php echo $extraField->value; ?></span> </li>
						<?php endif; ?>
						<?php endforeach; ?>
				</ul>
			</div>
			<?php endif; ?>
			<?php if($this->item->params->get('catItemVideo') && !empty($this->item->video)): ?>
			<div class="itemVideoBlock">
					<h3><?php echo JText::_('K2_RELATED_VIDEO'); ?></h3>
					<?php if($this->item->videoType=='embedded'): ?>
					<div class="itemVideoEmbedded"> <?php echo $this->item->video; ?> </div>
					<?php else: ?>
					<span class="itemVideo"><?php echo $this->item->video; ?></span>
					<?php endif; ?>
			</div>
			<?php endif; ?>
			<?php if($this->item->params->get('catItemImageGallery') && !empty($this->item->gallery)): ?>
			<div class="itemImageGallery">
					<h4><?php echo JText::_('K2_IMAGE_GALLERY'); ?></h4>
					<?php echo $this->item->gallery; ?> </div>
			<?php endif; ?>
			<?php if($this->item->params->get('catItemAttachments') && count($this->item->attachments)): ?>
			<div class="itemAttachmentsBlock"> <span><?php echo JText::_('K2_DOWNLOAD_ATTACHMENTS'); ?></span>
					<ul class="itemAttachments">
							<?php foreach ($this->item->attachments as $attachment): ?>
							<li> <a title="<?php echo K2HelperUtilities::cleanHtml($attachment->titleAttribute); ?>" href="<?php echo $attachment->link; ?>"> <?php echo $attachment->title ; ?> </a>
									<?php if($this->item->params->get('catItemAttachmentsCounter')): ?>
									<span>(<?php echo $attachment->hits; ?> <?php echo ($attachment->hits==1) ? JText::_('K2_DOWNLOAD') : JText::_('K2_DOWNLOADS'); ?>)</span>
									<?php endif; ?>
							</li>
							<?php endforeach; ?>
					</ul>
			</div>
			<?php endif; ?>
			<?php if ($this->item->params->get('catItemReadMore')): ?>
			<a class="uk-button uk-button-primary" href="<?php echo $this->item->link; ?>"> <?php echo JText::_('K2_READ_MORE'); ?> </a>
			<?php endif; ?>
			<?php echo $this->item->event->AfterDisplayContent; ?> <?php echo $this->item->event->K2AfterDisplayContent; ?>
			
			<!-- tags -->
			<?php if($this->item->params->get('catItemTags') && count($this->item->tags)): ?>
			<div class="tm-tags-list">
				<?php foreach ($this->item->tags as $tag): ?>
				<a class="tm-tag" href="<?php echo $tag->link; ?>"><?php echo $tag->name; ?></a>
				<?php endforeach; ?>
			</div>
			<?php endif; ?>

		</div>
	</div>

</article>
