/**
 * @preserve Mockup 1.01 | Copyright 2016, Deepak Ghimire.  All rights reserved.
 */
"use strict";var __extends=window&&window.__extends||function(e,t){for(var a in t)if(t.hasOwnProperty(a))e[a]=t[a];function i(){this.constructor=e}i.prototype=t.prototype;e.prototype=new i;e.__super=t.prototype;return e};var MOCKUP={VERSION:"1",REVISION:"01"};(function(e){e.MODE={PLUGIN:0,BUILDER:1};e.GEOMETRY_TYPE={PLANE:0,BOX:1,MODEL:2};e.MATERIAL_FACE={FRONT:4,BACK:5};e.MOUSE={LEFT:0,MIDDLE:1,RIGHT:2};e.Vector3=THREE.Vector3;e.Vector2=THREE.Vector2;e.defaults={anisotropy:8,maxTextureSize:2048,groundTexture:"images/textures/ground-grid.png",textureLoadFallback:"blank"};e.overrideAsTemplate=false;e.enableLog=false;e.log=function(){console.log.apply(console,arguments)};e.error=function(){console.error.apply(console,arguments)};e.autoSave=function(){};e.libType="THREE";e.paperDefaults={geometryType:e.GEOMETRY_TYPE.PLANE,width:210,height:297,depth:.2,segments:150,widthScale:1,heightScale:1,folds:1,angles:[],backImage:void 0,frontImage:void 0,frontBump:void 0,backBump:void 0,mipmap:false,shininess:15,bumpScale:.4,stiffness:.02,color:16777215,skipMaterials:false,repeat:100,defaultImage:[,,,,"blank","blank"]};e.Paper=function(t){__extends(a,t);function a(t,a){t=jQuery.extend({},e.paperDefaults,t);this.geometryType=t.geometryType;this.width=t.width;this.widthScale=t.widthScale;this.height=t.height;this.depth=t.depth;this.segments=t.segments;this.folds=t.folds;this.angles=t.angles;this._shininess=t.shininess;this._bumpScale=t.bumpScale;this.stiffness=t.stiffness;this.color=t.color;this.heightScale=t.heightScale;this.defaultImage=t.defaultImage;this.baseType="Paper";this.type="Paper";this.subType=t.subType;if(t.cloneParent!==void 0)this.cloneParent=t.cloneParent;this.createGeometry();this.updateGeometry();if(!t.skipMaterials){if(!(t.skipLoad==true&&t.cloneParent!==void 0)){if(this.frontImage!==void 0&&t.defaultImage!==void 0)this.frontImage(t.frontImage!==void 0?t.frontImage:t.defaultImage[e.MATERIAL_FACE.FRONT]);if(this.backImage!==void 0&&t.defaultImage!==void 0)this.backImage(t.backImage!==void 0?t.backImage:t.defaultImage[e.MATERIAL_FACE.BACK]);if(this.frontBump!==void 0)this.frontBump(t.frontBump);if(this.backBump!==void 0)this.backBump(t.backBump)}}if(this.bumpScale!==void 0)this.bumpScale(t.bumpScale);if(a!==void 0)if(a.add!==void 0)a.add(this)}var i=function(t,a,i,r){if(t){var s=t.image;t.naturalWidth=s.naturalWidth;t.naturalHeight=s.naturalHeight;t.needsUpdate=true}if(t!==null&&i=="map"){t.anisotropy=0;if(e.defaults.anisotropy>0)t.anisotropy=e.defaults.anisotropy;if(THREE.skipPowerOfTwo==true){t.minFilter=THREE.LinearFilter;t.magFilter=THREE.LinearFilter}t.name=(new Date).toTimeString();if(a.textureRepeat!==void 0){t.wrapS=THREE.RepeatWrapping;t.wrapT=THREE.RepeatWrapping;if(e.defaults.anisotropy>0)t.anisotropy=e.defaults.anisotropy;t.repeat.set(a._textureRepeat,a._textureRepeat);if(a instanceof e.Ground){a.material.bumpMap=t;a.material.bumpScale=a.bumpScale();a.material.needsUpdate=true}}}if(a.geometryType==e.GEOMETRY_TYPE.PLANE){n(a.material[i]);a.material[i]=t;if(i=="bumpMap")a.material.bumpScale=a.bumpScale()}else{n(a.material.materials[r][i]);a.material.materials[r][i]=t;if(i=="bumpMap")a.material.materials[r].bumpScale=a.bumpScale();a.material.materials[r].needsUpdate=true}e.autoSave()};var r=function(e,t){return null};var n=function(e){if(e){if(e.image){if(e.image.nodeName=="CANVAS"){if(e.image.remove)e.image.remove();delete e.image}}if(e.dispose){e.dispose()}e=null}};var s=function(t,a,i){if(t.geometryType==e.GEOMETRY_TYPE.PLANE){n(t.material[a])}else{n(t.material.materials[i][a])}};var o=function(e){if(!(e instanceof THREE.Object3D)||!(e.parent instanceof THREE.Object3D))return void 0;if(e.parent instanceof THREE.Scene)return e.parent;return o(e.parent)};e.loadImage=function(t,a,n,s,l){if(a===void 0){var c=t.geometryType==e.GEOMETRY_TYPE.PLANE?t.material[s]!==null?t.material[s].sourceFile:void 0:t.material.materials[n]==void 0?void 0:t.material.materials[n][s]?t.material.materials[n][s].sourceFile:void 0;return c==void 0?void 0:c.indexOf("data:image")>-1?void 0:c}else{if(e.enableLog==true)console.log(a);var d=null;if(a.nodeName=="CANVAS"||a.nodeName=="IMG"){d=new THREE.Texture(a);d.needsUpdate=true;i(d,t,s,n);if(l!==void 0)l(t);var u=o(t);if(u!==void 0)u.renderRequestPending=true}else{if(a!="blank"){d=a==null?null:THREE.ImageUtils.loadTexture(a,THREE.UVMapping,function(e){e.sourceFile=a;i(e,t,s,n);if(l!==void 0)l(t);var r=o(t);if(r!==void 0)r.renderRequestPending=true},function(i){if(d.image==void 0){if(t.defaultImage!==void 0){var o=t.geometryType==e.GEOMETRY_TYPE.PLANE?t.defaultImage[e.MATERIAL_FACE.FRONT]:t.defaultImage[n];if(a!==o&&o!==void 0){e.loadImage(t,o,n,s)}else if(a!==e.defaults.textureLoadFallback||o==void 0){e.loadImage(t,e.defaults.textureLoadFallback,n,s)}}else if(a!==e.defaults.textureLoadFallback){e.loadImage(t,e.defaults.textureLoadFallback,n,s)}}r(i,a)})}else{i(null,t,s,n)}}return 0}};a.prototype.loadImage=function(t,a,i,r){return e.loadImage(this,t,a,i,r)};a.prototype.frontImage=function(t,a){return this.loadImage(t,e.MATERIAL_FACE.FRONT,"map",a)};a.prototype.backImage=function(t,a){return this.loadImage(t,e.MATERIAL_FACE.BACK,"map",a)};a.prototype.frontBump=function(t,a){return this.loadImage(t,e.MATERIAL_FACE.FRONT,"bumpMap",a)};a.prototype.backBump=function(t,a){return this.loadImage(t,e.MATERIAL_FACE.BACK,"bumpMap",a)};a.prototype.bumpScale=function(t){if(t===void 0){return this._bumpScale}else{this._bumpScale=t;if(this.geometryType==e.GEOMETRY_TYPE.PLANE){this.material.bumpScale=t}else if(this.geometryType==e.GEOMETRY_TYPE.BOX){this.material.materials[e.MATERIAL_FACE.FRONT].bumpScale=t;this.material.materials[e.MATERIAL_FACE.BACK].bumpScale=t}}};a.prototype.shininess=function(t){if(t===void 0){return this._shininess}else{this._shininess=t;if(this.geometryType==e.GEOMETRY_TYPE.PLANE){this.material.shininess=t}else if(this.geometryType==e.GEOMETRY_TYPE.BOX){this.material.materials[e.MATERIAL_FACE.FRONT].shininess=t;this.material.materials[e.MATERIAL_FACE.BACK].shininess=t}}};a.prototype.bumpImage=function(t){return this.loadImage(t,e.MATERIAL_FACE.FRONT,"bumpMap")};a.prototype.createCopy=function(t){if(t==void 0){t={};e.getParameter(this,t)}t.type=this.type;var a=e.createObject(t);a.cloneParent=void 0;a.copy(this,void 0);return a};a.prototype.createClone=function(t){if(t==void 0){t={};e.getParameter(this,t)}t.type=this.type;var a=e.createObject(t);a.material=this.material;a.cloneParent=a.cloneParent!==void 0?a.cloneParent:this.uuid;a.copy(this,void 0);return a};a.prototype.createGeometry=function(){var a={color:this.color,shading:THREE.SmoothShading,shininess:this._shininess};var i=new THREE.MeshPhongMaterial(a);if(this.geometryType==e.GEOMETRY_TYPE.BOX){var r=[i,i,i,i,new THREE.MeshPhongMaterial(a),new THREE.MeshPhongMaterial(a)];t.call(this,new THREE.BoxGeometry(this.width,this.height,this.depth,this.segments*this.folds,1,1),new THREE.MeshFaceMaterial(r))}else if(this.geometryType==e.GEOMETRY_TYPE.PLANE){t.call(this,new THREE.PlaneBufferGeometry(this.width,this.height),i)}};a.prototype.updateGeometry=function(){};return a}(THREE.Mesh)})(MOCKUP||(MOCKUP={}));(function(e){e.selected=void 0;e.Stage=function(t){__extends(a,t);function a(a){a=a||{};var i=this;i.postRender=void 0;t.call(i);if(a.skipLoad!==true){i.canvas=a.canvas||document.createElement("canvas");i.canvas=jQuery(this.canvas);i.camera=new THREE.PerspectiveCamera(30,i.width/i.height,4,5e4);i.renderer=new THREE.WebGLRenderer({canvas:i.canvas[0],antialias:true,alpha:true});i.renderer.setSize(i.width,i.height);i.renderer.setClearColor(16777215,0);var r=i.orbitControl=new THREE.OrbitControls(i.camera,i.renderer.domElement);r.maxPolarAngle=Math.PI;if(e.mode!==e.MODE.PLUGIN){i.renderer.shadowMap.enabled=true;i.ground=new e.Ground({color:15658734,height:i.camera.far,width:i.camera.far},i)}i.ambientLight=new THREE.AmbientLight(4473924);i.add(i.ambientLight);var n=i.spotLight=new THREE.DirectionalLight(16777215,.5);n.position.set(0,1,0);n.castShadow=true;n.shadow=new THREE.LightShadow(new THREE.PerspectiveCamera(70,1,200,2e3));n.shadow.bias=-222e-6;n.shadow.mapSize.width=1024;n.shadow.mapSize.height=1024;n.intensity=.6;n.castShadow=true;var s=i.spotLightHelper=new THREE.CameraHelper(n.shadow.camera);s.visible=false;i.add(n);i.add(s);if(a.stats==true){var o=i.stats=new Stats;o.domElement.style.position="absolute";o.domElement.style.top="60px";i.canvas.parent().append(jQuery(o.domElement))}i.enableSoftShadow(false);i.animateCount=0;i.renderCount=0;i.camera.position.set(-300,300,300);i.camera.lookAt(new THREE.Vector3(0,0,0));i.orbitControl.center.set(0,0,0);i.orbitControl.update();i.selectiveRendering=false;i.renderRequestPending=false;l()}this.type="Stage";i.cancelRAF=function(){cancelAnimationFrame(l);l=null};function l(){if(l)requestAnimationFrame(l);if(i.selectiveRendering!=true||i.selectiveRendering==true&&i.renderRequestPending==true){i.render()}}}a.prototype.enableSoftShadow=function(e){e=e!==void 0?e:false;var t=this.renderer.shadowMap.type;this.renderer.shadowMap.type=e?THREE.PCFSoftShadowMap:THREE.PCFShadowMap;var a=this.spotLight;if(a.shadow.map){if(t==this.renderer.shadowMap.type)return;a.shadow.map.dispose();a.shadow.map=null}var i=e?4096:1024;a.shadow.mapSize.width=i;a.shadow.mapSize.height=i;a.shadow.bias=e?-875e-8:-5e-5;this.clearMaterials();this.renderRequestPending=true};a.prototype.clearMaterials=function(){var e=this.children.length;for(var t=e-1;t>=0;t--){var a=this.children[t];if(a.baseType&&a.baseType=="Paper"){if(a.material){if(a.material.materials!==void 0){for(var i=0;i<a.material.materials.length;i++)a.material.materials[i].needsUpdate=true}else{a.material.needsUpdate=true}}}}};a.prototype.clearChild=function(){if(this.spotLight.shadow.map){this.spotLight.shadow.map.dispose();this.spotLight.shadow.map=null}this.spotLight.castShadow=false;this.clearMaterials();var t=this.children.length;for(var a=t-1;a>=0;a--){var i=this.children[a];if(i instanceof e.Bundle){for(var r=i.children.length-1;r>=0;r--){e.clearChild(i.children[r])}}e.clearChild(i);i=null}this.render()};a.prototype.resizeAuto=function(){this.resizeCanvas(this.canvas.parent().width(),this.canvas.parent().height())};a.prototype.resizeCanvas=function(e,t){this.renderer.setSize(e,t);this.camera.aspect=e/t;this.camera.updateProjectionMatrix();this.renderRequestPending=true;if(this.resizeCallback!==void 0)this.resizeCallback()};a.prototype.render=function(){this.animateCount++;this.renderer.render(this,this.camera);if(this.stats!=void 0)this.stats.update();this.renderRequestPending=false;if(this.renderCallback!==void 0)this.renderCallback()};a.prototype.toJSON=function(){var t={metadata:{version:4.3,type:"Object",generator:"ObjectExporter"}};var a={};var i=function(e){if(t.geometries===void 0){t.geometries=[]}if(a[e.uuid]===void 0){var i=e.toJSON();delete i.metadata;a[e.uuid]=i;t.geometries.push(i)}return e.uuid};var r={};var n=function(e){if(t.materials===void 0){t.materials=[]}if(r[e.uuid]===void 0){var a=e.toJSON();delete a.metadata;r[e.uuid]=a;t.materials.push(a)}return e.uuid};var s=function(t){var a={};a.uuid=t.uuid;a.type=t.type;if(t.name!=="")a.name=t.name;if(JSON.stringify(t.userData)!=="{}")a.userData=t.userData;if(t.visible!==true)a.visible=t.visible;e.getParameter(t,a);if(t instanceof THREE.PerspectiveCamera){a.fov=t.fov;a.aspect=t.aspect;a.near=t.near;a.far=t.far}else if(t instanceof THREE.OrthographicCamera){a.left=t.left;a.right=t.right;a.top=t.top;a.bottom=t.bottom;a.near=t.near;a.far=t.far}else if(t instanceof THREE.AmbientLight){a.color=t.color.getHex()}else if(t instanceof THREE.DirectionalLight){a.color=t.color.getHex();a.intensity=t.intensity}else if(t instanceof THREE.PointLight){a.color=t.color.getHex();a.intensity=t.intensity;a.distance=t.distance;a.decay=t.decay}else if(t instanceof THREE.SpotLight){a.radius=t.radius;a.color=t.color.getHex();a.intensity=t.intensity;a.distance=t.distance;a.angle=t.angle;a.exponent=t.exponent;a.decay=t.decay}else if(t instanceof THREE.Mesh||t instanceof THREE.Line||t instanceof THREE.PointCloud){if(t instanceof e.Iphone){}else{a.geometry=i(t.geometry);a.material=n(t.material);if(t instanceof THREE.Line)a.mode=t.mode}}else if(t instanceof THREE.Sprite){a.material=n(t.material)}a.matrix=t.matrix.toArray();if(t.children.length>0){a.children=[];for(var r=0;r<t.children.length;r++){var o=t.children[r];if(o instanceof THREE.TransformControls||o instanceof THREE.BoxHelper){}else{if(!(t instanceof e.Bundle))a.children.push(s(t.children[r]))}}}return a};t.object=s(this);return t};a.prototype.hasChild=function(){var e=this.children;var t=false;for(var a=0;a<this.children.length;a++){if(e[a].baseType=="Paper"&&e[a].type!=="Ground"){t=true;break}}return t};return a}(THREE.Scene);e.getParameter=function(t,a){if(t.subType!==void 0)a.subType=t.subType;if(t.height!==void 0)a.height=t.height;if(t.width!==void 0)a.width=t.width;if(t.depth!==void 0)a.depth=t.depth;if(t.radius!==void 0)a.radius=t.radius;if(t.segments!==void 0)a.segments=t.segments;if(t.folds!==void 0)a.folds=t.folds;if(t.angles!==void 0)a.angles=t.angles;if(t.shininess!==void 0)a.shininess=t.shininess();if(t.bumpScale!==void 0)a.bumpScale=t.bumpScale();if(t.stiffness!==void 0)a.stiffness=t.stiffness;if(t.heightScale!==void 0)a.heightScale=t.heightScale;if(t.widthScale!==void 0)a.widthScale=t.widthScale;if(t.frontImage!==void 0)a.frontImage=t.frontImage();if(t.backImage!==void 0)a.backImage=t.backImage();if(t.backBump!==void 0)a.backBump=t.backBump();if(t.frontBump!==void 0)a.frontBump=t.frontBump();if(t.cloneParent!==void 0)a.cloneParent=t.cloneParent;if(t.textureRepeat!==void 0)a.textureRepeat=t.textureRepeat();if(t.resolutionHeight!==void 0)a.resolutionHeight=t.resolutionHeight;if(t.resolutionWidth!==void 0)a.resolutionWidth=t.resolutionWidth;if(t.screenSize!==void 0)a.screenSize=t.screenSize;if(e.overrideAsTemplate==true){e.getDefaultImage(a);if(a.defaultImage!==void 0){if(t.frontImage!==void 0)a.frontImage=a.defaultImage[4];if(t.backImage!==void 0)a.backImage=a.defaultImage[5]}}};e.getDefaultImage=function(t){if(t.defaultImage==void 0&&e.presets[t.type]!==void 0&&e.presets[t.type].options!==void 0){t.defaultImage=e.presets[t.type].options.defaultImage;if(t.subType!==void 0&&e.presets[t.type].menu!==void 0&&e.presets[t.type].menu.subMenu!==void 0&&e.presets[t.type].menu.subMenu[t.subType]!==void 0&&e.presets[t.type].menu.subMenu[t.subType].options.defaultImage!==void 0){t.defaultImage=e.presets[t.type].menu.subMenu[t.subType].options.defaultImage}}};e.createObject=function(t){if(t.defaultImage==void 0&&e.presets!==void 0&&e.presets[t.type]!==void 0&&e.presets[t.type].options!==void 0){t.defaultImage=e.presets[t.type].options.defaultImage;if(t.subType!==void 0&&e.presets[t.type].menu!==void 0&&e.presets[t.type].menu.subMenu!==void 0&&e.presets[t.type].menu.subMenu[t.subType]!==void 0&&e.presets[t.type].menu.subMenu[t.subType].options.defaultImage!==void 0){t.defaultImage=e.presets[t.type].menu.subMenu[t.subType].options.defaultImage}}var a=new e[t.type](t);if(t.cloneParent!==void 0)a.cloneParent=t.cloneParent;return a}})(MOCKUP||(MOCKUP={}));(function(e){var t=function(t){__extends(a,t);function a(a,i){a=a||{};a.geometryType=e.GEOMETRY_TYPE.PLANE;t.call(this,a,i);this.type="PlanePaper"}a.prototype.backImage=void 0;a.prototype.backBump=void 0;return a}(e.Paper);e.PlanePaper=t;var a=function(t){__extends(a,t);function a(a,i){a=a||{};a.geometryType=e.GEOMETRY_TYPE.BOX;t.call(this,a,i);this.type="BoxPaper";this.castShadow=true;this.receiveShadow=true}a.prototype.updateGeometry=function(){};return a}(e.Paper);e.BoxPaper=a;var i=function(t){__extends(a,t);function a(e,a){e=e||{};t.call(this,e,a);var i=6;for(var r=0;r<i;r++){this.angles[r]=this.angles[r]!=void 0?this.angles[r]:0}this.updateAngle();this.type="FoldBoxPaper"}a.prototype.updateGeometry=function(){};a.prototype.updateAngle=function(t){var a=this;var i=performance.now();var r=a.width*(1-Math.sin(a.stiffness/2*(a.stiffness/2))/2)-a.width*a.stiffness/20;var n=a.height;var s=a.segments;var o=a.folds;var l=a.stiffness;var c=r/2;var d=n/2;var u=r/o;var h=u*l;var p=u;var f=[];var m=[];var v=[];var E=[];var g=[];var T=[];var y=0;var b=a.depth;var R=Math.PI/2;var M=a.angles[4]||0;var x=o==3?p/200:0;var P=0;var H=0,S=[];S.push(H);var w=false;function I(){if(a.folds>=1){g[0]=[];T[o-1]=[];y=a.angles[1]*Math.PI/180;M=a.angles[4]*Math.PI/180;var e=Math.sin(M)*p;g[0][0]=g[0][1]=a.folds==1?new THREE.Vector3(-p*Math.cos(y),0,Math.sin(y)*p):new THREE.Vector3(p-c-p*Math.cos(y),0,Math.sin(y)*p);P=(a.angles[1]-90)*Math.PI/180;y=P;T[o-1][2]=T[o-1][3]=new THREE.Vector3(g[0][0].x-Math.cos(y)*b,0,g[0][0].z+Math.sin(y)*b);if(a.folds==1){g[0][1]=new THREE.Vector3(-p/2*Math.cos(M),0,p/2*Math.sin(M));T[o-1][2]=new THREE.Vector3(g[0][1].x-Math.cos(P)*b,0,g[0][1].z+Math.sin(P)*b)}y=(45+a.angles[1]/2)*Math.PI/180;if(a.folds>1){if(a.folds==2){y=(45+a.angles[1]/4-a.angles[4]/2)*Math.PI/180}else y=(45+a.angles[1]/4)*Math.PI/180}g[0][2]=a.folds==1?new THREE.Vector3(-Math.cos(y)*h/2,0,Math.sin(y)*h):new THREE.Vector3(p-c-x-Math.cos(y)*h/2,0,Math.sin(y)*h);T[o-1][1]=a.folds==1?new THREE.Vector3(g[0][2].x-Math.cos(P)*b,0,g[0][2].z+Math.sin(P)*b):g[0][2];g[0][3]=a.folds==1?new THREE.Vector3(0,0,0):new THREE.Vector3(p-c-x,0,0);if(a.folds==2){y=(a.angles[1]/2-a.angles[4]/2-90)*Math.PI/180}else if(a.folds==1){y=(a.angles[1]-90)*Math.PI/180}else{y=(a.angles[1]/2-90)*Math.PI/180}T[o-1][0]=new THREE.Vector3(g[0][3].x-Math.cos(y)*b,0,g[0][3].z+Math.sin(y)*b)}if(a.folds>=2){g[1]=[];T[o-2]=[];g[1][0]=g[0][3];T[o-2][3]=T[o-1][0];y=(135+a.angles[1]*3/4)*Math.PI/180;g[1][1]=new THREE.Vector3(p-c-Math.cos(y)*h,0,Math.sin(y)*h);T[o-2][2]=g[1][1];y=0;if(a.folds>2){y=(45-a.angles[4]*3/4)*Math.PI/180;g[1][2]=new THREE.Vector3(p*2-c+x-Math.cos(y)*h,0,Math.sin(y)*h);T[o-2][1]=g[1][2];g[1][3]=new THREE.Vector3(p*2-c+x,0,0);y=(a.angles[4]/2-90)*Math.PI/180;T[o-2][0]=new THREE.Vector3(g[1][3].x+Math.cos(y)*b*1.25,0,g[1][3].z+Math.sin(y)*b*1.25)}else{y=(135-a.angles[4]/4+a.angles[1]/2)*Math.PI/180;g[1][1]=new THREE.Vector3(p-c-Math.cos(y)*h/2,0,Math.sin(y)*h);T[0][2]=g[1][1];y=(180-a.angles[4])*Math.PI/180;g[1][2]=g[1][3]=new THREE.Vector3(p-c-Math.cos(y)*p,0,Math.sin(y)*p);y=(a.angles[4]-90)*Math.PI/180;T[0][0]=T[0][1]=new THREE.Vector3(g[1][3].x+Math.cos(y)*b,0,g[1][3].z+Math.sin(y)*b)}}if(a.folds>2){g[2]=[];T[0]=[];g[2][0]=g[1][3];T[0][3]=T[1][0];y=(135-a.angles[4]*1/4)*Math.PI/180;g[2][1]=new THREE.Vector3(p*2-c-Math.cos(y)*0,0,Math.sin(y)*h);T[0][2]=g[2][1];y=(180-a.angles[4])*Math.PI/180;g[2][2]=g[2][3]=new THREE.Vector3(p*2-c-Math.cos(y)*p,0,Math.sin(y)*p);y=(a.angles[4]-90)*Math.PI/180;T[0][0]=T[0][1]=new THREE.Vector3(g[2][3].x+Math.cos(y)*b,0,g[2][3].z+Math.sin(y)*b)}for(var t=0;t<a.folds;t++){f[t]=new THREE.CubicBezierCurve3(g[t][0],g[t][1],g[t][2],g[t][3]);v[t]=f[t].getPoints(a.segments);var i,r=v[t][0];for(var n=1;n<v[t].length;n++){i=v[t][n];H+=i.distanceTo(r);S.push(H);r=i}m[t]=new THREE.CubicBezierCurve3(T[t][0],T[t][1],T[t][2],T[t][3]);E[t]=m[t].getPoints(a.segments)}}I();var O=H;var C=a.geometry;var A=o*s+1;var L=7,z=8;C.vertices[0].z=C.vertices[2].z=C.vertices[z+A*2-1].z=C.vertices[z+A*3-1].z=C.vertices[z+A*5-1].z=C.vertices[z+A*6-1].z=v[o-1][s].z;C.vertices[0].x=C.vertices[2].x=C.vertices[z+A*2-1].x=C.vertices[z+A*3-1].x=C.vertices[z+A*5-1].x=C.vertices[z+A*6-1].x=v[o-1][s].x;C.vertices[1].z=C.vertices[3].z=C.vertices[z+A-1].z=C.vertices[z+A*4-1].z=C.vertices[z+A*6].z=C.vertices[z+A*7].z=E[0][0].z;C.vertices[1].x=C.vertices[3].x=C.vertices[z+A-1].x=C.vertices[z+A*4-1].x=C.vertices[z+A*6].x=C.vertices[z+A*7].x=E[0][0].x;C.vertices[5].z=C.vertices[7].z=C.vertices[z+A].z=C.vertices[z+A*2].z=C.vertices[z+A*4].z=C.vertices[z+A*5].z=v[0][0].z;C.vertices[5].x=C.vertices[7].x=C.vertices[z+A].x=C.vertices[z+A*2].x=C.vertices[z+A*4].x=C.vertices[z+A*5].x=v[0][0].x;C.vertices[4].z=C.vertices[6].z=C.vertices[z].z=C.vertices[z+A*3].z=C.vertices[z+A*7-1].z=C.vertices[z+A*8-1].z=E[o-1][s].z;C.vertices[4].x=C.vertices[6].x=C.vertices[z].x=C.vertices[z+A*3].x=C.vertices[z+A*7-1].x=C.vertices[z+A*8-1].x=E[o-1][s].x;var N=C.vertices.length;z++;for(var k=0;k<o;k++){var _=k==0;var j=_?s-1:s;for(var B=0;B<j;B++){C.vertices[z].z=C.vertices[z+A*3].z=C.vertices[N-z+L-A].z=C.vertices[N-z+L].z=E[o-1-k][j-B].z;C.vertices[z].x=C.vertices[z+A*3].x=C.vertices[N-z+L-A].x=C.vertices[N-z+L].x=E[o-1-k][j-B].x;C.vertices[z+A].z=C.vertices[z+A*2].z=C.vertices[z+A*4].z=C.vertices[z+A*5].z=v[k][B+_].z;C.vertices[z+A].x=C.vertices[z+A*2].x=C.vertices[z+A*4].x=C.vertices[z+A*5].x=v[k][B+_].x;z++}}var D=C.faceVertexUvs[0];var V=C.faces;var F=0,U=0;for(var B=0;B<D.length;B++){if(V[B].materialIndex==e.MATERIAL_FACE.FRONT){var Y=S[U]/H;if(B%2==0){D[B][0].x=D[B][1].x=D[B+1][0].x=Y;U++}else{D[B-1][2].x=D[B][1].x=D[B][2].x=Y}}else if(V[B].materialIndex==e.MATERIAL_FACE.BACK){var Y=1-S[U]/H;if(B%2==0){D[B][0].x=D[B][1].x=D[B+1][0].x=Y;U--}else{D[B-1][2].x=D[B][1].x=D[B][2].x=Y}}}C.computeBoundingBox();var G=Math.abs(C.boundingBox.min.x-C.boundingBox.max.x);var W=Math.abs(C.boundingBox.min.z-C.boundingBox.max.z);var K=Math.sqrt(G*G+W*W);a.scale.x=a.scale.z=p*a.folds/H;C.computeBoundingSphere();C.verticesNeedUpdate=true;C.computeFaceNormals();C.computeVertexNormals();C.uvsNeedUpdate=true;C.normalsNeedUpdate=true};return a}(e.BoxPaper);e.FlexBoxPaper=i;var r=function(e){__extends(t,e);function t(t,a){t=t||{};e.call(this);this.type="Bundle";if(a!==void 0)a.add(this)}return t}(THREE.Group);e.Bundle=r})(MOCKUP||(MOCKUP={}));(function(e){var t=function(t){__extends(a,t);function a(a,i){a=a||{};var r=this;r._textureRepeat=a.textureRepeat==void 0?50:a.textureRepeat;a.skipMaterials=true;a.bumpScale=a.bumpScale==void 0?.1:a.bumpScale;a.shininess=a.shininess==void 0?0:a.shininess;t.call(this,a,i);this.receiveShadow=true;this.angles=void 0;this.frontImage(a.frontImage==void 0?e.defaults.groundTexture:a.frontImage);r.type="Ground"}a.prototype.frontImage=function(e){if(e===void 0)return a.__super.frontImage.call(this,e);else{a.__super.frontImage.call(this,e)}};e.PlanePaper.prototype.frontBump=void 0;a.prototype.textureRepeat=function(e){if(e===void 0){return this._textureRepeat}else{this._textureRepeat=e;if(this.material.map!==null)this.material.map.repeat.set(e,e)}};return a}(e.PlanePaper);e.Ground=t})(MOCKUP||(MOCKUP={}));MOCKUP.inchTomm=function(e){return e*25.4};MOCKUP.mmToInch=function(e){return e/25.4};MOCKUP.clearChild=function(e){var t=e.material;e.parent.remove(e);var a;if(e.dispose!==void 0)e.dispose();if(e.geometry!==void 0)e.geometry.dispose();if(t==void 0)return;if(t.materials==void 0){if(t.map){a=t.map;t.dispose();a.dispose()}if(t.bumpMap){a=t.bumpMap;t.dispose();a.dispose()}}else{for(var i=0;i<t.materials.length;i++){if(t.materials[i]){if(t.materials[i].map){a=t.materials[i].map;t.materials[i].dispose();a.dispose()}if(t.materials[i].bumpMap){a=t.materials[i].bumpMap;t.materials[i].dispose();a.dispose()}}t.materials[i]=null}}t=null;a=null};THREE.OrbitControls=function(e,t){this.object=e;this.domElement=t!==void 0?t:document;this.enabled=true;this.target=new THREE.Vector3;this.center=this.target;this.noZoom=false;this.zoomSpeed=1;this.minDistance=0;this.maxDistance=Infinity;this.minZoom=0;this.maxZoom=Infinity;this.noRotate=false;this.rotateSpeed=1;this.noPan=false;this.keyPanSpeed=7;this.autoRotate=false;this.autoRotateSpeed=2;this.minPolarAngle=0;this.maxPolarAngle=Math.PI;this.minAzimuthAngle=-Infinity;this.maxAzimuthAngle=Infinity;this.noKeys=false;this.keys={LEFT:37,UP:38,RIGHT:39,BOTTOM:40};this.mouseButtons={ORBIT:THREE.MOUSE.LEFT,ZOOM:THREE.MOUSE.MIDDLE,PAN:THREE.MOUSE.RIGHT};var a=this;var i=1e-6;var r=new THREE.Vector2;var n=new THREE.Vector2;var s=new THREE.Vector2;var o=new THREE.Vector2;var l=new THREE.Vector2;var c=new THREE.Vector2;var d=new THREE.Vector3;var u=new THREE.Vector3;var h=new THREE.Vector2;var p=new THREE.Vector2;var f=new THREE.Vector2;var m;var v;var E=0;var g=0;var T=1;var y=new THREE.Vector3;var b=new THREE.Vector3;var R=new THREE.Quaternion;var M={NONE:-1,ROTATE:0,DOLLY:1,PAN:2,TOUCH_ROTATE:3,TOUCH_DOLLY:4,TOUCH_PAN:5};var x=M.NONE;this.target0=this.target.clone();this.position0=this.object.position.clone();this.zoom0=this.object.zoom;var P=(new THREE.Quaternion).setFromUnitVectors(e.up,new THREE.Vector3(0,1,0));var H=P.clone().inverse();var S={type:"change"};var w={type:"start"};var I={type:"end"};this.rotateLeft=function(e){if(e===void 0){e=O()}g-=e};this.rotateUp=function(e){if(e===void 0){e=O()}E-=e};this.panLeft=function(e){var t=this.object.matrix.elements;d.set(t[0],t[1],t[2]);d.multiplyScalar(-e);y.add(d)};this.panUp=function(e){var t=this.object.matrix.elements;d.set(t[4],t[5],t[6]);d.multiplyScalar(e);y.add(d)};this.pan=function(e,t){var i=a.domElement===document?a.domElement.body:a.domElement;if(a.object instanceof THREE.PerspectiveCamera){var r=a.object.position;var n=r.clone().sub(a.target);var s=n.length();s*=Math.tan(a.object.fov/2*Math.PI/180);a.panLeft(2*e*s/i.clientHeight);a.panUp(2*t*s/i.clientHeight)}else if(a.object instanceof THREE.OrthographicCamera){a.panLeft(e*(a.object.right-a.object.left)/i.clientWidth);a.panUp(t*(a.object.top-a.object.bottom)/i.clientHeight)}else{console.warn("WARNING: OrbitControls.js encountered an unknown camera type - pan disabled.")}};this.dollyIn=function(e){if(e===void 0){e=C()}if(a.object instanceof THREE.PerspectiveCamera){T/=e}else if(a.object instanceof THREE.OrthographicCamera){a.object.zoom=Math.max(this.minZoom,Math.min(this.maxZoom,this.object.zoom*e));a.object.updateProjectionMatrix();a.dispatchEvent(S)}else{console.warn("WARNING: OrbitControls.js encountered an unknown camera type - dolly/zoom disabled.")}};this.dollyOut=function(e){if(e===void 0){e=C()}if(a.object instanceof THREE.PerspectiveCamera){T*=e}else if(a.object instanceof THREE.OrthographicCamera){a.object.zoom=Math.max(this.minZoom,Math.min(this.maxZoom,this.object.zoom/e));a.object.updateProjectionMatrix();a.dispatchEvent(S)}else{console.warn("WARNING: OrbitControls.js encountered an unknown camera type - dolly/zoom disabled.")}};this.update=function(){var e=this.object.position;u.copy(e).sub(this.target);u.applyQuaternion(P);m=Math.atan2(u.x,u.z);v=Math.atan2(Math.sqrt(u.x*u.x+u.z*u.z),u.y);if(this.autoRotate&&x===M.NONE){this.rotateLeft(O())}m+=g;v+=E;m=Math.max(this.minAzimuthAngle,Math.min(this.maxAzimuthAngle,m));v=Math.max(this.minPolarAngle,Math.min(this.maxPolarAngle,v));v=Math.max(i,Math.min(Math.PI-i,v));var t=u.length()*T;t=Math.max(this.minDistance,Math.min(this.maxDistance,t));this.target.add(y);u.x=t*Math.sin(v)*Math.sin(m);u.y=t*Math.cos(v);u.z=t*Math.sin(v)*Math.cos(m);u.applyQuaternion(H);e.copy(this.target).add(u);this.object.lookAt(this.target);g=0;E=0;T=1;y.set(0,0,0);if(b.distanceToSquared(this.object.position)>i||8*(1-R.dot(this.object.quaternion))>i){this.dispatchEvent(S);b.copy(this.object.position);R.copy(this.object.quaternion)}};this.reset=function(){x=M.NONE;this.target.copy(this.target0);this.object.position.copy(this.position0);this.object.zoom=this.zoom0;this.object.updateProjectionMatrix();this.dispatchEvent(S);this.update()};this.getPolarAngle=function(){return v};this.getAzimuthalAngle=function(){return m};function O(){return 2*Math.PI/60/60*a.autoRotateSpeed}function C(){return Math.pow(.95,a.zoomSpeed)}function A(e){if(a.enabled===false)return;e.preventDefault();if(e.button===a.mouseButtons.ORBIT){if(a.noRotate===true)return;x=M.ROTATE;r.set(e.clientX,e.clientY)}else if(e.button===a.mouseButtons.ZOOM){if(a.noZoom===true)return;x=M.DOLLY;h.set(e.clientX,e.clientY)}else if(e.button===a.mouseButtons.PAN){if(a.noPan===true)return;x=M.PAN;o.set(e.clientX,e.clientY)}if(x!==M.NONE){document.addEventListener("mousemove",L,false);document.addEventListener("mouseup",z,false);document.addEventListener("mouseout",z,false);a.dispatchEvent(w)}}function L(e){if(a.enabled===false)return;e.preventDefault();var t=a.domElement===document?a.domElement.body:a.domElement;if(x===M.ROTATE){if(a.noRotate===true)return;n.set(e.clientX,e.clientY);s.subVectors(n,r);a.rotateLeft(2*Math.PI*s.x/t.clientWidth*a.rotateSpeed);a.rotateUp(2*Math.PI*s.y/t.clientHeight*a.rotateSpeed);r.copy(n)}else if(x===M.DOLLY){if(a.noZoom===true)return;p.set(e.clientX,e.clientY);f.subVectors(p,h);if(f.y>0){a.dollyIn()}else if(f.y<0){a.dollyOut()}h.copy(p)}else if(x===M.PAN){if(a.noPan===true)return;l.set(e.clientX,e.clientY);c.subVectors(l,o);a.pan(c.x,c.y);o.copy(l)}if(x!==M.NONE)a.update()}function z(){if(a.enabled===false)return;document.removeEventListener("mousemove",L,false);document.removeEventListener("mouseup",z,false);document.removeEventListener("mouseout",z,false);a.dispatchEvent(I);x=M.NONE}function N(e){if(a.enabled===false||a.noZoom===true||x!==M.NONE)return;e.preventDefault();e.stopPropagation();var t=0;if(e.wheelDelta!==void 0){t=e.wheelDelta}else if(e.detail!==void 0){t=-e.detail}if(t>0){a.dollyOut()}else if(t<0){a.dollyIn()}a.update();a.dispatchEvent(w);a.dispatchEvent(I);if(a.zoomCallback)a.zoomCallback()}function k(e){if(a.enabled===false||a.noKeys===true||a.noPan===true)return;switch(e.keyCode){case a.keys.UP:a.pan(0,a.keyPanSpeed);a.update();break;case a.keys.BOTTOM:a.pan(0,-a.keyPanSpeed);a.update();break;case a.keys.LEFT:a.pan(a.keyPanSpeed,0);a.update();break;case a.keys.RIGHT:a.pan(-a.keyPanSpeed,0);a.update();break}}function _(e){if(a.enabled===false)return;var t=e.touches.length;if(a.mouseButtons.PAN==THREE.MOUSE.LEFT)t=3;switch(t){case 4:if(a.noRotate===true)return;x=M.TOUCH_ROTATE;r.set(e.touches[0].pageX,e.touches[0].pageY);break;case 2:if(a.noZoom===true)return;x=M.TOUCH_DOLLY;var i=e.touches[0].pageX-e.touches[1].pageX;var n=e.touches[0].pageY-e.touches[1].pageY;var s=Math.sqrt(i*i+n*n);h.set(0,s);break;case 3:if(a.noPan===true)return;x=M.TOUCH_PAN;o.set(e.touches[0].pageX,e.touches[0].pageY);break;default:x=M.NONE}if(x!==M.NONE)a.dispatchEvent(w)}function j(e){if(a.enabled===false)return;var t=a.domElement===document?a.domElement.body:a.domElement;var i=e.touches.length;if(a.mouseButtons.PAN==THREE.MOUSE.LEFT)i=3;switch(i){case 4:if(a.noRotate===true)return;if(x!==M.TOUCH_ROTATE)return;e.preventDefault();e.stopPropagation();n.set(e.touches[0].pageX,e.touches[0].pageY);s.subVectors(n,r);a.rotateLeft(2*Math.PI*s.x/t.clientWidth*a.rotateSpeed);a.rotateUp(2*Math.PI*s.y/t.clientHeight*a.rotateSpeed);r.copy(n);a.update();break;case 2:if(a.noZoom===true)return;if(x!==M.TOUCH_DOLLY)return;e.preventDefault();e.stopPropagation();var d=e.touches[0].pageX-e.touches[1].pageX;var u=e.touches[0].pageY-e.touches[1].pageY;var m=Math.sqrt(d*d+u*u);p.set(0,m);f.subVectors(p,h);if(f.y>0){a.dollyOut()}else if(f.y<0){a.dollyIn()}h.copy(p);a.update();break;case 3:if(a.noPan===true)return;if(x!==M.TOUCH_PAN)return;e.preventDefault();e.stopPropagation();l.set(e.touches[0].pageX,e.touches[0].pageY);c.subVectors(l,o);a.pan(c.x,c.y);o.copy(l);a.update();break;default:x=M.NONE}}function B(){if(a.enabled===false)return;a.dispatchEvent(I);x=M.NONE}function D(e){e.preventDefault()}this.dispose=function(){this.domElement.removeEventListener("contextmenu",D,false);this.domElement.removeEventListener("mousedown",A,false);this.domElement.removeEventListener("mousewheel",N,false);this.domElement.removeEventListener("DOMMouseScroll",N,false);this.domElement.removeEventListener("touchstart",_,false);this.domElement.removeEventListener("touchend",B,false);this.domElement.removeEventListener("touchmove",j,false);window.removeEventListener("keydown",k,false)};this.domElement.addEventListener("contextmenu",D,false);this.domElement.addEventListener("mousedown",A,false);this.domElement.addEventListener("mousewheel",N,false);this.domElement.addEventListener("DOMMouseScroll",N,false);this.domElement.addEventListener("touchstart",_,false);this.domElement.addEventListener("touchend",B,false);this.domElement.addEventListener("touchmove",j,false);window.addEventListener("keydown",k,false);this.update()};THREE.OrbitControls.prototype=Object.create(THREE.EventDispatcher.prototype);THREE.OrbitControls.prototype.constructor=THREE.OrbitControls;
THREE.CSS3DObject=function(e){THREE.Object3D.call(this);this.element=e;this.element.style.position="absolute";this.addEventListener("removed",function(e){if(this.element.parentNode!==null){this.element.parentNode.removeChild(this.element)}})};THREE.CSS3DObject.prototype=Object.create(THREE.Object3D.prototype);THREE.CSS3DObject.prototype.constructor=THREE.CSS3DObject;THREE.CSS3DSprite=function(e){THREE.CSS3DObject.call(this,e)};THREE.CSS3DSprite.prototype=Object.create(THREE.CSS3DObject.prototype);THREE.CSS3DSprite.prototype.constructor=THREE.CSS3DSprite;THREE.CSS3DRenderer=function(){console.log("THREE.CSS3DRenderer",THREE.REVISION);var e,t;var a,i;var r=new THREE.Matrix4;var n={camera:{fov:0,style:""},objects:{}};var s=document.createElement("div");s.style.overflow="hidden";s.style.WebkitTransformStyle="preserve-3d";s.style.MozTransformStyle="preserve-3d";s.style.oTransformStyle="preserve-3d";s.style.transformStyle="preserve-3d";this.domElement=s;var o=document.createElement("div");o.style.WebkitTransformStyle="preserve-3d";o.style.MozTransformStyle="preserve-3d";o.style.oTransformStyle="preserve-3d";o.style.transformStyle="preserve-3d";s.appendChild(o);this.setClearColor=function(){};this.getSize=function(){return{width:e,height:t}};this.setSize=function(r,n){e=r;t=n;a=e/2;i=t/2;s.style.width=r+"px";s.style.height=n+"px";o.style.width=r+"px";o.style.height=n+"px"};var l=function(e){return Math.abs(e)<Number.EPSILON?0:e};var c=function(e){var t=e.elements;return"matrix3d("+l(t[0])+","+l(-t[1])+","+l(t[2])+","+l(t[3])+","+l(t[4])+","+l(-t[5])+","+l(t[6])+","+l(t[7])+","+l(t[8])+","+l(-t[9])+","+l(t[10])+","+l(t[11])+","+l(t[12])+","+l(-t[13])+","+l(t[14])+","+l(t[15])+")"};var d=function(e){var t=e.elements;return"translate3d(-50%,-50%,0) matrix3d("+l(t[0])+","+l(t[1])+","+l(t[2])+","+l(t[3])+","+l(-t[4])+","+l(-t[5])+","+l(-t[6])+","+l(-t[7])+","+l(t[8])+","+l(t[9])+","+l(t[10])+","+l(t[11])+","+l(t[12])+","+l(t[13])+","+l(t[14])+","+l(t[15])+")"};var u=function(e,t){if(e instanceof THREE.CSS3DObject){var a;if(e instanceof THREE.CSS3DSprite){r.copy(t.matrixWorldInverse);r.transpose();r.copyPosition(e.matrixWorld);r.scale(e.scale);r.elements[3]=0;r.elements[7]=0;r.elements[11]=0;r.elements[15]=1;a=d(r)}else{a=d(e.matrixWorld)}var i=e.element;var s=n.objects[e.id];if(s===undefined||s!==a){i.style.WebkitTransform=a;i.style.MozTransform=a;i.style.oTransform=a;i.style.transform=a;n.objects[e.id]=a}if(i.parentNode!==o){o.appendChild(i)}}for(var l=0,c=e.children.length;l<c;l++){u(e.children[l],t)}};this.render=function(e,r){var l=.5/Math.tan(THREE.Math.degToRad(r.fov*.5))*t;if(n.camera.fov!==l){s.style.WebkitPerspective=l+"px";s.style.MozPerspective=l+"px";s.style.oPerspective=l+"px";s.style.perspective=l+"px";n.camera.fov=l}e.updateMatrixWorld();if(r.parent===null)r.updateMatrixWorld();r.matrixWorldInverse.getInverse(r.matrixWorld);var d="translate3d(0,0,"+l+"px)"+c(r.matrixWorldInverse)+" translate3d("+a+"px,"+i+"px, 0)";if(n.camera.style!==d){o.style.WebkitTransform=d;o.style.MozTransform=d;o.style.oTransform=d;o.style.transform=d;n.camera.style=d}u(e,r)}};