/**
 * @preserve
 * Plugin Name: dflip
 * Description: dflip - 3D & 2D FlipBook
 *
 * Author: Deepak Ghimire
 * Author URI: http://codecanyon.net/user/deip?ref=deip
 */
"use strict";var DFLIP=DFLIP||{};var PRESENTATION=DFLIP;(function e(t,i){t.version="1.2.61";t.PAGE_MODE={SINGLE:1,DOUBLE:2,AUTO:void 0};t.DIRECTION={LTR:1,RTL:2};t.CORNERS={TL:"tl",TR:"tr",BL:"bl",BR:"br",L:"l",R:"r",NONE:void 0};t.SOURCE_TYPE={IMAGE:"image",PDF:"pdf",HTML:"html"};t.DISPLAY_TYPE={WEBGL:"3D",HTML:"2D"};t.PAGE_SIZE={AUTO:0,SINGLE:1,DOUBLEINTERNAL:2};var n=t.defaults={webgl:true,soundEnable:true,height:"100%",autoEnableOutline:false,overwritePDFOutline:false,enableDownload:true,duration:800,direction:t.DIRECTION.LTR,pageMode:t.PAGE_MODE.AUTO,backgroundColor:"#777",transparent:false,hard:"none",maxTextureSize:1600,minTextureSize:512,icons:{altnext:"ti-angle-right",altprev:"ti-angle-left",next:"ti-angle-right",prev:"ti-angle-left",end:"ti-angle-double-right",start:"ti-angle-double-left",share:"ti-sharethis",help:"ti-help-alt",more:"ti-more-alt",download:"ti-download",zoomin:"ti-zoom-in",zoomout:"ti-zoom-out",fullscreen:"ti-fullscreen",fitscreen:"ti-arrows-corner",thumbnail:"ti-layout-grid2",outline:"ti-menu-alt",close:"ti-close",doublepage:"ti-book",singlepage:"ti-file",sound:"ti-volume",facebook:"ti-facebook",google:"ti-google",twitter:"ti-twitter-alt",mail:"ti-email"},text:{toggleSound:"Turn on/off Sound",toggleThumbnails:"Toggle Thumbnails",toggleOutline:"Toggle Outline/Bookmark",previousPage:"Previous Page",nextPage:"Next Page",toggleFullscreen:"Toggle Fullscreen",zoomIn:"Zoom In",zoomOut:"Zoom Out",toggleHelp:"Toggle Help",singlePageMode:"Single Page Mode",doublePageMode:"Double Page Mode",downloadPDFFile:"Download PDF File",gotoFirstPage:"Goto First Page",gotoLastPage:"Goto Last Page",share:"Share"},allControls:"altPrev,pageNumber,altNext,outline,thumbnail,zoomIn,zoomOut,fullScreen,share,more,download,pageMode,startPage,endPage,sound",mainControls:"altPrev,pageNumber,altNext,outline,thumbnail,zoomIn,zoomOut,fullScreen,share,more",hideControls:"",scrollWheel:true,onCreate:function(){},onCreateUI:function(){},onFlip:function(){},beforeFlip:function(){},onReady:function(){},zoomRatio:1.5,pageSize:t.PAGE_SIZE.AUTO,pdfjsSrc:"js/libs/pdf.min.js",pdfjsCompatibilitySrc:"js/libs/compatibility.js",pdfjsWorkerSrc:"js/libs/pdf.worker.min.js",threejsSrc:"js/libs/three.min.js",mockupjsSrc:"js/libs/mockup.min.js",soundFile:"sound/turn2.mp3",enableDebugLog:false,canvasToBlob:true,textureLoadFallback:"blank",stiffness:3,minTopOffset:30,backgroundImage:"",pageRatio:void 0,defaultPageRatio:210/297};var a="WebKitCSSMatrix"in window||document.body&&"MozPerspective"in document.body.style,o="onmousedown"in window,r="ontouchstart"in window;var s=t.utils={drag:{left:0,right:1,none:-1},mouseEvents:o?{type:"mouse",start:"mousedown",move:"mousemove",end:"mouseup"}:{type:"touch",start:"touchstart",move:"touchmove",end:"touchend"},html:{div:"<div/>",img:"<img/>",a:"<a>",input:"<input type='text'/>"},toRad:function(e){return e*Math.PI/180},toDeg:function(e){return e*180/Math.PI},transition:function(e,t){return e?t/1e3+"s ease-out":"0s none"},display:function(e){return e?"block":"none"},resetTranslate:function(){return v(0,0)},translateStr:function(e,t){return a?" translate3d("+e+"px,"+t+"px, 0px) ":" translate("+e+"px, "+t+"px) "},resetBoxShadow:function(){return"rgba(0, 0, 0, 0) 0px 0px 20px"},rotateStr:function(e){return" rotateZ("+e+"deg) "},bg:function(e){return"#fff"+P(e)},bgImage:function(e){return e==void 0||e=="blank"?"":" url("+e+")"},src:function(e){return e!==void 0?""+e+"":""},limitAt:function(e,t,i){return e<t?t:e>i?i:e},distOrigin:function(e,t){return Math.sqrt(Math.pow(e,2)+Math.pow(t,2))},distPoints:function(e,t,i,n){return Math.sqrt(Math.pow(i-e,2)+Math.pow(n-t,2))},angleByDistance:function(e,t){var i=t/2;var n=C(e,0,t);var a=n<i?p(Math.asin(n/i)):90+p(Math.asin((n-i)/i));return a},log:function(e){if(n.enableDebugLog==true&&window.console)console.log(e)},lowerPowerOfTwo:function(e){return Math.pow(2,Math.floor(Math.log(e)/Math.LN2))},nearestPowerOfTwo:function(e){return Math.pow(2,Math.ceil(Math.log(e)/Math.LN2))},extendOptions:function(e,t){return i.extend(true,{},e,t)},getBasePage:function(e){return Math.floor(e/2)*2},loadResources:function q(e,t,i){var n=document,a=n.createElement(e),o=n.getElementsByTagName(e)[0];a.async=true;if(i){a.addEventListener("load",function(e){i(null,e)},false)}a.src=t;o.parentNode.insertBefore(a,o)},getScript:function(e,t,i){var n=document.createElement("script");var a=document.body.getElementsByTagName("script")[0];n.async=1;n.setAttribute("data-cfasync",false);a.parentNode.insertBefore(n,a);function o(e,i){if(n!==void 0){if(i||!n.readyState||/loaded|complete/.test(n.readyState)){n.onload=n.onreadystatechange=null;n=void 0;if(!i){if(t)t()}}}}n.addEventListener("load",o,false);n.addEventListener("readystatechange",o,false);n.addEventListener("complete",o,false);if(i){n.addEventListener("error",i,false)}n.src=e+(D.dom=="MS"?"?"+Math.random(1):"")},fixMouseEvent:function(e){if(e){var t=e.originalEvent||e;if(t.changedTouches&&t.changedTouches.length>0){var n=i.event.fix(e);var a=t.changedTouches[0];n.clientX=a.clientX;n.clientY=a.clientY;n.pageX=a.pageX;n.pageY=a.pageY;n.movementX=a.movementX;n.movementY=a.movementY;return n}else{return e}}else{return e}},hasWebgl:function(){try{var e=document.createElement("canvas");return!!(window.WebGLRenderingContext&&(e.getContext("webgl")||e.getContext("experimental-webgl")))}catch(t){return false}}(),isMobile:function(){var e=false;(function(t){if(/(android|bb\d+|meego).+mobile|avantgo|bada\/|blackberry|blazer|compal|elaine|fennec|hiptop|iemobile|ip(hone|od)|iris|kindle|lge |maemo|midp|mmp|mobile.+firefox|netfront|opera m(ob|in)i|palm( os)?|phone|p(ixi|re)\/|plucker|pocket|psp|series(4|6)0|symbian|treo|up\.(browser|link)|vodafone|wap|windows ce|xda|xiino|android|ipad|playbook|silk/i.test(t)||/1207|6310|6590|3gso|4thp|50[1-6]i|770s|802s|a wa|abac|ac(er|oo|s\-)|ai(ko|rn)|al(av|ca|co)|amoi|an(ex|ny|yw)|aptu|ar(ch|go)|as(te|us)|attw|au(di|\-m|r |s )|avan|be(ck|ll|nq)|bi(lb|rd)|bl(ac|az)|br(e|v)w|bumb|bw\-(n|u)|c55\/|capi|ccwa|cdm\-|cell|chtm|cldc|cmd\-|co(mp|nd)|craw|da(it|ll|ng)|dbte|dc\-s|devi|dica|dmob|do(c|p)o|ds(12|\-d)|el(49|ai)|em(l2|ul)|er(ic|k0)|esl8|ez([4-7]0|os|wa|ze)|fetc|fly(\-|_)|g1 u|g560|gene|gf\-5|g\-mo|go(\.w|od)|gr(ad|un)|haie|hcit|hd\-(m|p|t)|hei\-|hi(pt|ta)|hp( i|ip)|hs\-c|ht(c(\-| |_|a|g|p|s|t)|tp)|hu(aw|tc)|i\-(20|go|ma)|i230|iac( |\-|\/)|ibro|idea|ig01|ikom|im1k|inno|ipaq|iris|ja(t|v)a|jbro|jemu|jigs|kddi|keji|kgt( |\/)|klon|kpt |kwc\-|kyo(c|k)|le(no|xi)|lg( g|\/(k|l|u)|50|54|\-[a-w])|libw|lynx|m1\-w|m3ga|m50\/|ma(te|ui|xo)|mc(01|21|ca)|m\-cr|me(rc|ri)|mi(o8|oa|ts)|mmef|mo(01|02|bi|de|do|t(\-| |o|v)|zz)|mt(50|p1|v )|mwbp|mywa|n10[0-2]|n20[2-3]|n30(0|2)|n50(0|2|5)|n7(0(0|1)|10)|ne((c|m)\-|on|tf|wf|wg|wt)|nok(6|i)|nzph|o2im|op(ti|wv)|oran|owg1|p800|pan(a|d|t)|pdxg|pg(13|\-([1-8]|c))|phil|pire|pl(ay|uc)|pn\-2|po(ck|rt|se)|prox|psio|pt\-g|qa\-a|qc(07|12|21|32|60|\-[2-7]|i\-)|qtek|r380|r600|raks|rim9|ro(ve|zo)|s55\/|sa(ge|ma|mm|ms|ny|va)|sc(01|h\-|oo|p\-)|sdk\/|se(c(\-|0|1)|47|mc|nd|ri)|sgh\-|shar|sie(\-|m)|sk\-0|sl(45|id)|sm(al|ar|b3|it|t5)|so(ft|ny)|sp(01|h\-|v\-|v )|sy(01|mb)|t2(18|50)|t6(00|10|18)|ta(gt|lk)|tcl\-|tdg\-|tel(i|m)|tim\-|t\-mo|to(pl|sh)|ts(70|m\-|m3|m5)|tx\-9|up(\.b|g1|si)|utst|v400|v750|veri|vi(rg|te)|vk(40|5[0-3]|\-v)|vm40|voda|vulc|vx(52|53|60|61|70|80|81|83|85|98)|w3c(\-| )|webc|whit|wi(g |nc|nw)|wmlb|wonu|x700|yas\-|your|zeto|zte\-/i.test(t.substr(0,4)))e=true})(navigator.userAgent||navigator.vendor||window.opera);return e}(),prefix:function(){var e=window.getComputedStyle(document.documentElement,""),t=Array.prototype.slice.call(e).join("").match(/-(moz|webkit|ms)-/)[1],i="WebKit|Moz|MS".match(new RegExp("("+t+")","i"))[1];return{dom:i,lowercase:t,css:"-"+t+"-",js:t[0].toUpperCase()+t.substr(1)}}(),__extends:window&&window.__extends||function(e,t){for(var i in t)if(t.hasOwnProperty(i))e[i]=t[i];function n(){this.constructor=e}n.prototype=t.prototype;e.prototype=new n;e.__super=t.prototype;return e}};var l=t.SOURCE_TYPE,d=t.DISPLAY_TYPE,c=s.drag,f=s.mouseEvents,u=s.html,h=s.toRad,p=s.toDeg,g=s.transition,v=s.translateStr,m=s.resetBoxShadow,w=s.rotateStr,b=s.bg,P=s.bgImage,x=s.src,C=s.limitAt,y=s.distOrigin,k=s.distPoints,E=s.angleByDistance,L=s.log,S=s.nearestPowerOfTwo,I=s.extendOptions,T=s.getBasePage,R=s.getScript,O=s.fixMouseEvent,D=s.prefix,F=s.isMobile,M=s.hasWebgl,B=s.__extends;var N=function(e){return i.extend(true,{},n,e)};var z=function(e,n){var a="df-ui";var o="df-ui-wrapper";var r=a+"-"+"btn";var s=n.ui=i(u.div,{"class":a});var l=n.options;s.dispose=function(){e.find("."+r).each(function(){i(this).off()});T.remove();m.remove();f.remove();c.remove();h.remove();if(s.shareBox){if(s.shareBox.dispose)s.shareBox.dispose();s.shareBox=null}document.removeEventListener("keyup",se,false);window.removeEventListener("click",x,false);n=null};var d=function(e){if(isNaN(e))e=n.target._activePage;else if(e<1)e=1;else if(e>n.target.pageCount)e=n.target.pageCount;return e};var c=s.next=i(u.div,{"class":r+" "+a+"-next "+l.icons["next"],title:l.text.nextPage,html:"<span>"+l.text.nextPage+"</span>"}).on("click",function(){n.next()});var f=s.prev=i(u.div,{"class":r+" "+a+"-prev "+l.icons["prev"],title:l.text.previousPage,html:"<span>"+l.text.previousPage+"</span>"}).on("click",function(){n.prev()});var h=i(u.div,{"class":o+" "+a+"-zoom"});var p=s.zoomIn=i(u.div,{"class":r+" "+a+"-zoomin "+l.icons["zoomin"],title:l.text.zoomIn,html:"<span>"+l.text.zoomIn+"</span>"}).on("click",function(){n.zoom(true);s.update();if(n.target.startPoint&&n.target.pan)n.target.pan(n.target.startPoint)});var g=s.zoomOut=i(u.div,{"class":r+" "+a+"-zoomout "+l.icons["zoomout"],title:l.text.zoomOut,html:"<span>"+l.text.zoomOut+"</span>"}).on("click",function(){n.zoom(false);s.update();if(n.target.startPoint&&n.target.pan)n.target.pan(n.target.startPoint)});h.append(p).append(g);var v=s.pageNumber=i(u.div,{"class":r+" "+a+"-page"}).on("change",function(){var e=parseInt(s.pageInput.val(),10);e=d(e);n.gotoPage(e)}).on("keyup",function(e){if(e.keyCode==13){var t=parseInt(s.pageInput.val(),10);t=d(t);if(t!==d(n.target._activePage||n._activePage))n.gotoPage(t)}});s.pageInput=i('<input id="df_book_page_number" type="text"/>').appendTo(v);s.pageLabel=i('<label for="df_book_page_number"/>').appendTo(v);var m=i(u.div,{"class":o+" "+a+"-size"});var w=i(u.div,{"class":r+" "+a+"-help "+l.icons["help"],title:l.text.toggleHelp,html:"<span>"+l.text.toggleHelp+"</span>"}).on("click",function(){});var b=s.sound=i(u.div,{"class":r+" "+a+"-sound "+l.icons["sound"],title:l.text.toggleSound,html:"<span>"+l.text.toggleSound+"</span>"}).on("click",function(){l.soundEnable=!l.soundEnable;s.updateSound()});s.updateSound=function(){if(l.soundEnable==false||l.soundEnable=="false")b.addClass("disabled");else b.removeClass("disabled")};s.updateSound();var P=s.more=i(u.div,{"class":r+" "+a+"-more "+l.icons["more"]}).on("click",function(e){if(!P.hasClass("df-active")){i(this).addClass("df-active");e.stopPropagation()}});function x(e){P.removeClass("df-active")}window.addEventListener("click",x,false);var C=i(u.div,{"class":"more-container"});P.append(C);if(typeof l.source=="string"&&l.enableDownload==true){var y=r+" "+a+"-download "+l.icons["download"];var k=s.download=i('<a download target="_blank" class="'+y+'"><span>'+l.text.downloadPDFFile+"</span></a>");k.attr("href",l.source).attr("title",l.text.downloadPDFFile)}var E=document.fullscreenEnabled||document.mozFullScreenEnabled||document.webkitFullscreenEnabled||document.msFullscreenEnabled;if(!E){e.addClass("df-custom-fullscreen")}var S=s.fullScreen=i(u.div,{"class":r+" "+a+"-fullscreen "+l.icons["fullscreen"],title:l.text.toggleFullscreen,html:"<span>"+l.text.toggleFullscreen+"</span>"}).on("click",function(){var e=document.fullscreenElement||document.mozFullScreenElement||document.webkitFullscreenElement||document.msFullscreenElement;var t=n.container[0];if(s.isFullscreen!=true){n.container.addClass("df-fullscreen");if(t.requestFullscreen){t.requestFullscreen()}else if(t.msRequestFullscreen){t.msRequestFullscreen()}else if(t.mozRequestFullScreen){t.mozRequestFullScreen()}else if(t.webkitRequestFullscreen){t.webkitRequestFullscreen()}s.isFullscreen=true}else{n.container.removeClass("df-fullscreen");s.isFullscreen=false;if(document.exitFullscreen){document.exitFullscreen()}else if(document.msExitFullscreen){document.msExitFullscreen()}else if(document.mozCancelFullScreen){document.mozCancelFullScreen()}else if(document.webkitExitFullscreen){document.webkitExitFullscreen()}}setTimeout(function(){i(window).trigger("resize")},50)});var I=s.fit=i(u.div,{"class":r+" "+a+"-fit "+l.icons["fitscreen"]}).on("click",function(){i(this).toggleClass("df-button-fit-active")});m.append(S);var T=i(u.div,{"class":o+" "+a+"-controls"});var R=s.shareBox=new t.Share(e,l);var O=s.share=i(u.div,{"class":r+" "+a+"-share "+l.icons["share"],title:l.text.share,html:"<span>"+l.text.share+"</span>"}).on("click",function(e){if(s.shareBox.isOpen==true)s.shareBox.close();else{s.shareBox.update(n.getURLHash());s.shareBox.show()}});var D=s.startPage=i(u.div,{"class":r+" "+a+"-start "+l.icons["start"],title:l.text.gotoFirstPage,html:"<span>"+l.text.gotoFirstPage+"</span>"}).on("click",function(){n.start()});var F=s.endPage=i(u.div,{"class":r+" "+a+"-end "+l.icons["end"],title:l.text.gotoLastPage,html:"<span>"+l.text.gotoLastPage+"</span>"}).on("click",function(){n.end()});var M=s.pageMode=i(u.div,{"class":r+" "+a+"-pagemode "+l.icons["singlepage"],html:"<span>"+l.text.singlePageMode+"</span>"}).on("click",function(){var e=i(this);n.setPageMode(!e.hasClass(l.icons["doublepage"]))});n.setPageMode(n.target.pageMode==t.PAGE_MODE.SINGLE);var B=s.altPrev=i(u.div,{"class":r+" "+a+"-prev"+" "+a+"-alt "+l.icons["prev"],title:l.text.previousPage,html:"<span>"+l.text.previousPage+"</span>"}).on("click",function(){n.prev()});var N=s.altNext=i(u.div,{"class":r+" "+a+"-next"+" "+a+"-alt "+l.icons["next"],title:l.text.nextPage,html:"<span>"+l.text.nextPage+"</span>"}).on("click",function(){n.next()});var z=s.thumbnail=i(u.div,{"class":r+" "+a+"-thumbnail "+l.icons["thumbnail"],title:l.text.toggleThumbnails,html:"<span>"+l.text.toggleThumbnails+"</span>"}).on("click",function(){var e=i(this);if(n.target.thumbContainer){var t=n.target.thumbContainer;t.toggleClass("df-thumb-visible");e.toggleClass("df-active")}else{n.contentProvider.initThumbs();e.toggleClass("df-active")}if(e.hasClass("df-active")){e.siblings(".df-active").trigger("click")}s.update(true)});var A=s.outline=i(u.div,{"class":r+" "+a+"-outline "+l.icons["outline"],title:l.text.toggleOutline,html:"<span>"+l.text.toggleOutline+"</span>"}).on("click",function(){var e=i(this);if(n.target.outlineContainer){var t=n.target.outlineContainer;e.toggleClass("df-active");t.toggleClass("df-outline-visible");if(e.hasClass("df-active")){e.siblings(".df-active").trigger("click")}s.update(true)}});var _=l.allControls.replace(/ /g,"").split(","),j=","+l.mainControls.replace(/ /g,"")+",",U=","+l.hideControls.replace(/ /g,"")+",";for(var H=0;H<_.length;H++){var W=_[H];if(U.indexOf(","+W+",")<0){var V=s[W];if(V!==void 0){if(j.indexOf(","+W+",")>-1)T.append(V);else if(W!=="more"&&W!=="pageNumber")C.append(V)}}}e.append(T).append(f).append(c).append(h);var G=false,q=false,Y=false;var Z=16,K=17,X=18,Q=83,J=86,$=67,ee=69,te=71,ie=78,ne=79,ae=46,oe=39,re=37;document.addEventListener("keyup",se,false);function se(e){switch(e.keyCode){case Z:q=false;break;case K:G=false;break;case X:Y=false;break;case re:n.prev();break;case oe:n.next();break;default:break}}s.update=function(i){L("ui update");var a=n.target;var o=d(a._activePage||n._activePage);var r=a.pageCount||n.pageCount;var l=a.direction==t.DIRECTION.RTL,c=o==1||o==0,f=o==r;s.next.show();s.prev.show();s.altNext.removeClass("disabled");s.altPrev.removeClass("disabled");if(c&&!l||f&&l){s.prev.hide();s.altPrev.addClass("disabled")}if(f&&!l||c&&l){s.next.hide();s.altNext.addClass("disabled")}s.pageInput.val(o);s.pageLabel.html(o+"/"+r);if(e.find(".df-thumb-visible, .df-outline-visible").length>0){e.addClass("df-sidemenu-open")}else{e.removeClass("df-sidemenu-open")}if(i==true)n.resize();if(a.contentProvider.zoomScale==a.contentProvider.maxZoom){s.zoomIn.addClass("disabled")}else{s.zoomIn.removeClass("disabled")}if(a.contentProvider.zoomScale==1){s.zoomOut.addClass("disabled")}else{s.zoomOut.removeClass("disabled")}};if(n.target!==void 0){n.target.ui=s}if(l.onCreateUI!==void 0)l.onCreateUI()};var A=function(e){var i=function(){MOCKUP.defaults.anisotropy=0;MOCKUP.defaults.groundTexture="blank";THREE.skipPowerOfTwo=true;j();if(e!==void 0)e()};if(window.MOCKUP==void 0){R(n.threejsSrc+"?ver="+t.version,function(){R(n.mockupjsSrc+"?ver="+t.version,function(){i()})})}else{i()}};var _=void 0;function j(){_=function(e){B(t,e);function t(t){t=t||{};var n=this;e.call(this,t);n.options=t;n.canvas=i(n.renderer.domElement).addClass("df-3dcanvas");n.container=t.container;n.container.append(n.canvas);n.type="PreviewStage";n.mouse=new THREE.Vector2;n.raycaster=new THREE.Raycaster;n.camera.position.set(0,20,600);n.camera.lookAt(new THREE.Vector3(0,0,0));n.spotLight.position.set(-100,200,400);n.spotLight.castShadow=!F;n.spotLight.shadow.bias=-8e-4;n.spotLight.intensity=.2;n.ambientLight.color=new THREE.Color("#888");n.ambientLight.intensity=1.45;var a=new THREE.ShadowMaterial;a.opacity=.15;n.ground.material=a;n.ground.position.z=-3;n.orbitControl.maxAzimuthAngle=.4;n.orbitControl.minAzimuthAngle=-.4;n.orbitControl.minPolarAngle=1.4;n.orbitControl.maxPolarAngle=2.2;n.orbitControl.mouseButtons.ORBIT=THREE.MOUSE.RIGHT;n.orbitControl.mouseButtons.PAN=-1;n.orbitControl.maxDistance=5e3;n.orbitControl.minDistance=50;n.orbitControl.noZoom=true;n.selectiveRendering=true;n.orbitControl.zoomSpeed=5;n.orbitControl.keyPanSpeed=0;n.orbitControl.center.set(0,0,0);n.orbitControl.update();n.swipe_threshold=F?15:20;var o=n.cssRenderer=new THREE.CSS3DRenderer;i(o.domElement).css({position:"absolute",top:0,pointerEvents:"none"}).addClass("df-3dcanvas");n.container[0].appendChild(o.domElement);var r=n.cssScene=new THREE.Scene;var s=document.createElement("div");var l=document.createElement("div");var d=r.divLeft=new THREE.CSS3DObject(s);var c=r.divRight=new THREE.CSS3DObject(l);r.add(d);r.add(c);n.resizeCallback=function(){o.setSize(n.canvas.width(),n.canvas.height())};function u(){n.renderRequestPending=true}window.addEventListener(f.move,u,false);window.addEventListener("keyup",u,false);n.dispose=function(){n.clearChild();n.render();window.removeEventListener(f.move,u,false);if(n.options.scrollWheel==true){n.renderer.domElement.removeEventListener("mousewheel",h,false);n.renderer.domElement.removeEventListener("DOMMouseScroll",h,false)}window.removeEventListener("keyup",u,false);n.renderer.domElement.removeEventListener("mousemove",p,false);n.renderer.domElement.removeEventListener("touchmove",p,false);n.renderer.domElement.removeEventListener("mousedown",g,false);n.renderer.domElement.removeEventListener("touchstart",g,false);n.renderer.domElement.removeEventListener("mouseup",m,false);n.renderer.domElement.removeEventListener("touchend",m,false);n.canvas.remove();o.domElement.remove();n.renderCallback=null;n.orbitControl.dispose();n.renderer.dispose();n.cancelRAF()};n.renderCallback=function(){if(TWEEN.getAll().length>0)n.renderRequestPending=true;TWEEN.update();o.render(r,n.camera)};var h=function(e){var t=0;if(e.wheelDelta!==void 0){t=e.wheelDelta}else if(e.detail!==void 0){t=-e.detail}if(t){var i=n.previewObject.contentProvider.zoomScale;if(t>0&&i==1||t<0&&i>1){e.preventDefault()}n.previewObject.zoom(t>0)}u()};var p=function(e){n.renderRequestPending=true;e=O(e);if(n.isMouseDown&&e.movementX!=0&&e.movementY!=0){n.isMouseMoving=true}if(n.isMouseDown==true&&n.previewObject.contentProvider.zoomScale==1){var t=e.pageX-n.lastPos,i=performance.now()-n.lastTime;if(Math.abs(t)>n.swipe_threshold){if(t<0){n.target.next()}else{n.target.prev()}e.preventDefault();n.isMouseDown=false}n.lastPos=e.pageX;n.lastTime=performance.now()}};var g=function(e){e=O(e);document.activeElement.blur();n.mouseValue=e.pageX+","+e.pageY;n.isMouseMoving=false;n.isMouseDown=true;n.lastPos=e.pageX;n.lastTime=performance.now()};var v=function(e){n.isMouseDown=false;if(e.button!==0)return this;var t=e.pageX+","+e.pageY;if(n.isMouseMoving){}else if(t==n.mouseValue){e=e||window.event;e=i.event.fix(e);var a=n.mouse,o=n.raycaster;a.x=e.offsetX/n.canvas.innerWidth()*2-1;a.y=1-e.offsetY/n.canvas.innerHeight()*2;o.setFromCamera(a,n.camera);var r=o.intersectObjects(n.target instanceof MOCKUP.Bundle?n.target.children:[n.target],true);if(r.length>0){var s,l=0;do{s=r[l]!==void 0?r[l].object:void 0;l++}while((s instanceof THREE.BoxHelper||!(s instanceof MOCKUP.Paper)||s.isFlipping==true)&&l<r.length);if(s.userData.object!==void 0){}else{if(s.angles[1]>90){if(s.isEdge!=true)n.target.next()}else{if(s.isEdge!=true)n.target.prev()}}}else{}}};var m=function(e){e=O(e);v(e)};n.renderer.domElement.addEventListener("mousemove",p,false);n.renderer.domElement.addEventListener("touchmove",p,false);n.renderer.domElement.addEventListener("mousedown",g,false);n.renderer.domElement.addEventListener("touchstart",g,false);n.renderer.domElement.addEventListener("mouseup",m,false);n.renderer.domElement.addEventListener("touchend",m,false);if(n.options.scrollWheel==true){n.renderer.domElement.addEventListener("mousewheel",h,false);n.renderer.domElement.addEventListener("DOMMouseScroll",h,false)}i(n.renderer.domElement).css({display:"block"});i(window).trigger("resize");return this}t.prototype.width=function(){return this.container.width()};t.prototype.height=function(){return this.container.height()};return t}(MOCKUP.Stage);MOCKUP.PreviewStage=_;var e=function(e){B(t,e);function t(t,i){t=t||{};t.folds=1;e.call(this,t,i);this.angle=0;this.isFlipping=false;this.type="BookPaper"}t.prototype.tween=function(e,t){var i=this;var n=1e-5;i.originalStiff=i.stiffness;var a=i.newStiffness;var o=t-e;i.init={angle:e,angle2:e<90?0:180,stiff:i.originalStiff};i.first={angle:e+o/4,angle2:e<90?90:90,stiff:i.originalStiff};i.mid={angle:e+o*2/4,angle2:e<90?135:45,stiff:i.newStiffness};i.mid2={angle:e+o*3/4,angle2:e<90?180:0,stiff:i.newStiffness};i.end={angle:t,angle2:e<90?180:0,stiff:i.newStiffness};i.isFlipping=true;var r=function(e,t){i.angles[1]=e.angle;i.angles[4]=e.angle2;i.stiffness=e.stiff/(a+n)*(i.newStiffness+n);i.stiffness=isNaN(i.stiffness)?0:e.stiff;i.updateAngle(true)};new TWEEN.Tween(i.init).to({angle:[i.first.angle,i.mid.angle,i.mid2.angle,i.end.angle],angle2:[i.first.angle2,i.mid.angle2,i.mid2.angle2,i.end.angle2],stiff:[i.first.stiff,i.mid.stiff,i.mid2.stiff,i.end.stiff]},i.parent.duration).onUpdate(function(e){r(this,e)}).easing(TWEEN.Easing.Sinusoidal.Out).onComplete(function(e){i.stiffness=i.newStiffness;i.updateAngle();i.isFlipping=false;if(i.parent&&i.parent.refresh)i.parent.refresh()}).start()};return t}(MOCKUP.FlexBoxPaper);MOCKUP.BookPaper=e;var n=function(e){B(i,e);function i(i,n){i=i||{};i.segments=i.segments||50;this.pageCount=i.pageCount;this.height=i.height;this.width=i.width;this.pageCount=this.pageCount==1?this.pageCount:Math.ceil(this.pageCount/2)*2;this.direction=i.direction||t.DIRECTION.LTR;this.startPage=1;this.endPage=this.pageCount;this.stackCount=i.stackCount||6;this.materials=[];e.call(this,i,n);this.angles=[0,0,0,0,0,0];this.stiffness=i.stiffness||1.5;this._activePage=i.openPage||this.startPage;this.createStack(i);this.pageMode=i.pageMode||(F||this.pageCount<=2?t.PAGE_MODE.SINGLE:t.PAGE_MODE.DOUBLE);this.type="Book"}i.prototype.getPageByNumber=function(e){return this.getObjectByName(Math.floor((e-1)/2).toString())};i.prototype.activePage=function(e){if(e==void 0)return this._activePage;this.gotoPage(e)};i.prototype.gotoPage=function(e){e=parseInt(e,10);this._activePage=e;this.updatePage(e)};i.prototype.moveBy=function(e){var t=this._activePage+e;t=C(t,this.startPage,this.endPage);this.gotoPage(t)};i.prototype.next=function(e){if(e==void 0)e=this.direction==t.DIRECTION.RTL?-this.pageMode:this.pageMode;this.moveBy(e)};i.prototype.prev=function(e){if(e==void 0)e=this.direction==t.DIRECTION.RTL?this.pageMode:-this.pageMode;this.moveBy(e)};i.prototype.updateAngle=function(){var e=this.angles[1];var t=this.angles[4];var i=t-e;var n=this.stackCount;for(var a=0;a<n;a++){var o=this.children[a];o.angles[1]=e+a*i/(n*100);o.stiffness=this.stiffness;o.updateAngle()}};i.prototype.refresh=function(){this.updatePage(this._activePage);if(this.flipCallback!==void 0)this.flipCallback()};i.prototype.updatePage=function(e){var i=this.direction==t.DIRECTION.RTL;e=Math.floor(e/2);if(i)e=Math.floor(this.pageCount/2)-e;var n=this.oldBaseNumber||0;var a=this.pageCount/2;var o=this.stackCount;var r=.02;var s=.4;var l=(.5-Math.abs(a/2-e)/a)/this.stiffness;var d=1;var c=Math.floor(o/2);var f=c;var u=false;if(n>e){u=true;this.children[o-1].skipFlip=true;this.children.unshift(this.children.pop())}else if(n<e){this.children[0].skipFlip=true;this.children.push(this.children.shift())}else{}if(Math.abs(n-e)>1){}var h=a-e;var p=5/a;var g=p*e/2;var v=p*h/2;var m=g<v?v:g;for(var w=0;w<o;w++){var b=this.children[w];var P=b.color;var x=b.angles[1];var C;var y=e-f+w;var k=b.name;b.visible=y>=0&&y<a;if(this.requestPage!==void 0){if(i)y=Math.floor(this.pageCount/2)-y-1;b.name=y.toString();if(b.name!=k&&b.visible==true){b.textureLoaded=false;b.backTextureLoaded=false;b.frontTextureLoaded=false;b.thumbLoaded=false;this.requestPage(y*2+1);this.requestPage(y*2+2)}}b.isEdge=false;if(w==0){b.depth=g<s?s:g}else if(w==o-1){b.depth=v<s?s:v}else{b.depth=s;b.isEdge=false}if(b.isFlipping==true){b.depth=s}b.position.x=0;var E=r*w,L=180-r*(w-f)+r*w;if(w<f){b.newStiffness=l/(e/a)/4;C=E;b.position.z=m-(-w+f)*s;if(u==true)b.position.z-=s}else{C=L;b.newStiffness=l/(Math.abs(a-e)/a)/4;b.position.z=m-(-o+w+f+1)*s-b.depth}if(b.isFlipping==false){if(Math.abs(x-C)>20&&b.skipFlip==false){b.depth=s;var S=b.stiffness;if(x>C){S=l/(Math.abs(a-e)/a)/4}else{S=l/(e/a)/4}b.position.z+=s;b.stiffness=isNaN(S)?b.stiffness:S;b.updateAngle(true);b.targetStiffness=w<e?l/(Math.abs(a-e)/a)/4:l/(e/a)/4;b.targetStiffness=isNaN(b.targetStiffness)?b.stiffness:b.targetStiffness;b.isFlipping=true;b.tween(x,C);if(this.preFlipCallback!==void 0)this.preFlipCallback()}else{b.skipFlip=false;b.newStiffness=isNaN(b.newStiffness)?0:b.newStiffness;if(b.angles[1]!=C||b.stiffness!=b.newStiffness||b.depth!=b.oldDepth){b.angles[1]=b.angles[4]=C;b.stiffness=b.newStiffness;b.updateAngle(true)}else{}}}b.oldDepth=b.depth;var I=Math.abs(b.geometry.boundingBox.max.x)<Math.abs(b.geometry.boundingBox.min.x)?b.geometry.boundingBox.max.x:b.geometry.boundingBox.min.x;b.position.x=b.isEdge==true&&b.isFlipping==false?w<f?I:-I:0}this.oldBaseNumber=e;if(this.updatePageCallback!==void 0)this.updatePageCallback()};i.prototype.createCover=function(e){e.width=e.width*2;this.cover=new MOCKUP.BiFold(e);this.add(this.cover)};i.prototype.createStack=function(e){var t="red,green,blue,yellow,orange,black".split(",");for(var i=0;i<this.stackCount;i++){e.angles=[,this.stackCount-i];e.stiffness=(this.stackCount-i)/100;var n=new MOCKUP.BookPaper(e);n.angles[1]=180;n.index=i;n.updateAngle();n.textureReady=false;n.textureRequested=false;this.add(n);n.color=t[i];n.position.z=-1*i}};i.prototype.shininess=function(e){if(e==void 0){return this.mainObject.shininess()}else{this.mainObject.shininess(e)}};i.prototype.bumpScale=function(e){if(e==void 0){return this.mainObject.bumpScale()}else{this.mainObject.bumpScale(e)}};i.prototype.frontImage=function(e){if(e==void 0){return this.mainObject.frontImage()}else{this.mainObject.frontImage(e)}};i.prototype.backImage=function(e){if(e==void 0){return this.mainObject.backImage()}else{this.mainObject.backImage(e)}};return i}(MOCKUP.Bundle);MOCKUP.Book=n}var U=function(e){function n(e){e=e||{};this.type="PreviewObject";var i=this;function n(){setTimeout(function(){i.resize()},50)}window.addEventListener("resize",n,false);this.sound=document.createElement("audio");this.sound.setAttribute("src",e.soundFile+"?ver="+t.version);this.sound.setAttribute("type","audio/mpeg");this.dispose=function(){if(this.container&&this.container.info&&this.container.info.remove)this.container.info.remove();if(this.target&&this.target.dispose)this.target.dispose();this.target=null;if(this.stage&&this.stage.dispose)this.stage.dispose();this.stage=null;if(this.ui&&this.ui.dispose)this.ui.dispose();this.ui=null;if(this.contentProvider&&this.contentProvider.dispose)this.contentProvider.dispose();this.contentProvider=null;window.removeEventListener("resize",n)}}n.prototype={start:function(){this.target.gotoPage(this.target.startPage)},end:function(){this.target.gotoPage(this.target.endPage)},next:function(){},prev:function(){},zoom:function(e){this.pendingZoom=true;this.zoomDelta=e;this.resize();this.ui.update()},resize:function(){var e=this;if(e.target==void 0||e.target.ui==void 0||e.target.contentProvider==void 0||e.target.contentProvider.viewport==void 0||e.target.stage==void 0)return;var n=this.target.pageMode==t.PAGE_MODE.SINGLE,a=e.container.hasClass("df-floating");var o=e.target,r=o.stage,l=o.contentProvider,d=l.pageRatio,c=l.zoomViewport,f=o.mode!=="css";var u,h,p=i(window).height();var g=o.ui.isFullscreen==true?p:this.options.height;e.container.height(g);if(Math.min(e.container.height(),p)==p)g=p;e.container.height(g);g=e.container.height();if(!f){r.css({top:0,bottom:0,right:0,left:0,transform:"translate3d("+e.target.left+"px,"+e.target.top+"px,0)"});o.stageHeight=r.height()}u=r.width();h=r.height();var v=u,m=Math.min(h,p),w=Math.floor(n?v:v/2);var b=Math.floor(w/d);var P,x,k,E,L;P=Math.min(b,m);x=Math.floor(P*d);l.maxZoom=l.zoomViewport.height/P;if(e.pendingZoom==true&&e.zoomDelta!==void 0){e.pendingZoom=false;var I=e.zoomDelta,T,R=Math.max(P,x);var O=l.zoomScale==1;var D=C(O?l.zoomScale:l.zoomScale+I,1,l.maxZoom);if(I>0){T=S(R*D)}else{T=s.lowerPowerOfTwo(R*D)}l.zoomScale=C(I>0?e.options.zoomRatio*l.zoomScale:l.zoomScale/e.options.zoomRatio,1,l.maxZoom);e.zoomDelta=void 0}L=l.zoomScale==1||l.zoomScale==void 0?1:l.zoomScale;l.checkViewportSize(x*L,P*L);if(l.zoomScale!=1){this.target.container.addClass("df-zoom-enabled")}else{this.target.container.removeClass("df-zoom-enabled")}var F=l.maxZoom;if(f){P=g;var M=e.container.find(".df-ui-controls").height();if(M==null||a)M=0;r.canvas.height(P-M);if(e.container.hasClass("df-sidemenu-open")){u=u-220}r.resizeCanvas(u,P-M);var B=o.height,N=u*B/P,z=u/P;var A=o.width*(n?1:2);var _=N<A?A/z:o.height;var j=e.options.minTopOffset+(a?60:30);var U=L==1?P/(P-j):B/_;k=1/(2*Math.tan(Math.PI*r.camera.fov*.5/180)/(_/(L/U)));r.camera.updateProjectionMatrix();r.renderRequestPending=true;r.camera.position.z=k;var H=j/2-e.options.minTopOffset;e.target.position.y=H*B/(e.container.height()-j);r.cssScene.position.y=e.target.position.y;if(l.zoomScale==1){r.camera.position.set(0,0,k);r.orbitControl.target=new THREE.Vector3(0,0,0)}r.orbitControl.update();r.orbitControl.mouseButtons.ORBIT=L!=1?-1:THREE.MOUSE.RIGHT;r.orbitControl.mouseButtons.PAN=L!=1?THREE.MOUSE.LEFT:-1}else{if(o!==void 0){o.pageWidth=Math.floor(x);o.fullWidth=o.pageWidth*2;o.height=P;var W=o.stage.innerWidth()-o.stage.width(),V=o.stage.innerHeight()-o.stage.height();var G=o.shiftHeight=C((P*L-(g-V))/2,0,o.height*L),q=o.shiftWidth=C(L==1?1:(o.fullWidth*L-o.container.width()+W)/2,0,o.fullWidth*L);o.stage.css({top:-G,bottom:-G,right:-q,left:-q,transform:"translate3d("+o.left+"px,"+o.top+"px,0)"});var Y=o.stage.innerHeight();o.wrapper.css({width:o.fullWidth*L,height:P*L,marginTop:g-P*L-V>0?(g-V-P*L)/2:0});var Z=Math.floor(y(x,P))*L;o.stage.find(".df-page-wrapper").width(Z).height(Z);o.stage.find(".df-book-page, .df-page-front , .df-page-back, .df-page-fold-inner-shadow").height(P*L).width(x*L)}}this.checkCenter();if(o.thumblist){o.thumblist.reset(i(o.thumblist.container).height())}var K=e.container.width();if(K<400){e.container.addClass("df-xs")}else{e.container.removeClass("df-xs")}},playSound:function(){try{if(this.options&&this.options.soundEnable==true){this.sound.currentTime=0;
this.sound.play()}}catch(e){}},setPageMode:function(e){if(e==true){this.ui.pageMode.addClass(this.options.icons["doublepage"]);this.ui.pageMode.html("<span>"+this.options.text.doublePageMode+"</span>");this.ui.pageMode.attr("title",this.options.text.doublePageMode);this.target.pageMode=t.PAGE_MODE.SINGLE}else{this.ui.pageMode.removeClass(this.options.icons["doublepage"]);this.ui.pageMode.html("<span>"+this.options.text.singlePageMode+"</span>");this.ui.pageMode.attr("title",this.options.text.singlePageMode);this.target.pageMode=t.PAGE_MODE.DOUBLE}this.resize()},height:function(e){if(e==void 0){return this.container.height()}else{this.options.height=e;this.container.height(e);this.resize()}},checkCenter:function(){this.centerType=this.centerType||"start";var e=this.target;var i=0,n=0,a=0;var o=s.getBasePage(e._activePage);var r=e._activePage%2==0;var l=e.direction==t.DIRECTION.RTL;var d=e.pageMode==t.PAGE_MODE.SINGLE;var c=e.stage.width(),f;if(e.mode=="css"){f=e.wrapper.width();i=Math.max((f-c)/2,0);n=-f/4,a=f/4;if(o==0){e.wrapper.css({left:d?l?a-i:n-i:l?a:n});e.shadow.css({width:"50%",left:l?0:"50%",transitionDelay:""})}else if(o==e.pageCount){e.wrapper.css({left:d?l?n-i:a-i:l?n:a});e.shadow.css({width:"50%",left:l?"50%":0,transitionDelay:""})}else{e.wrapper.css({left:d?l?r?n-i:a-i:r?a-i:n-i:0});e.shadow.css({width:"100%",left:0,transitionDelay:parseInt(e.duration,10)+50+"ms"})}}else if(e.stage!==void 0){var u=e.position.x,h;i=e.width/4;f=e.width;n=-f/2,a=f/2;if(o==0){h=l?a:n}else if(o==e.pageCount){h=l?n:a}else{h=d?l?r?n:a:r?a:n:0}if(h!==this.centerEnd){this.centerTween=new TWEEN.Tween({x:u}).delay(0).to({x:h},e.duration).onUpdate(function(){e.position.x=this.x;e.stage.cssScene.position.x=this.x}).easing(e.ease).start();this.centerEnd=h}}},width:function(e){if(e==void 0){return this.container.width()}else{this.options.width=e;this.container.width(e);this.resize()}}};return n}({});t.PreviewObject=U;var H=function(e){B(o,e);var a=void 0;function o(e,a,o,r){o=o||{};var s=this;s.contentRawSource=e||[n.textureLoadFallback];s.contentSource=s.contentRawSource;s.contentSourceType=void 0;s.minDimension=o.minTextureSize||512;s.maxDimension=o.maxTextureSize||2048;s.flipbook=r;s.waitPeriod=50;s.enableDebug=false;s.zoomScale=1;s.maxZoom=2;s.options=o;s.outline=o.outline;s.links=o.links;s.html=o.html;s.isCrossOrigin=o.isCrossOrigin;s.normalViewport={height:297,width:210,scale:1};s.viewport={height:297,width:210,scale:1};s.zoomViewport={height:297,width:210};s.thumbsize=128;s.cacheIndex=512;s.cache=[];s.pageRatio=o.pageRatio||s.viewport.width/s.viewport.height;s.textureLoadTimeOut=void 0;s.type="TextureLibrary";if(Array===s.contentSource.constructor||Array.isArray(s.contentSource)||s.contentSource instanceof Array){s.contentSourceType=l.IMAGE;s.pageCount=s.contentSource.length;i("<img/>").attr("src",s.contentSource[0]).on("load",function(){s.viewport.height=this.height;s.viewport.width=this.width;s.pageRatio=s.viewport.width/s.viewport.height;s.zoomViewport={width:(s.pageRatio>1?1:s.pageRatio)*s.maxDimension,height:s.maxDimension/(s.pageRatio<1?1:s.pageRatio)};s.linkService=new PDFLinkService;i(this).off();if(a!=void 0)a(s);L(this.height+":"+this.width)})}else if(typeof s.contentSource=="string"||s.contentSource instanceof String){var d=function(){PDFJS.workerSrc=n.pdfjsWorkerSrc;s.contentSourceType=l.PDF;PDFJS.disableAutoFetch=true;PDFJS.disableStream=true;PDFJS.externalLinkTarget=PDFJS.LinkTarget.BLANK;var i=PDFJS.getDocument(e);i.then(function o(e){s.pdfDocument=e;e.getPage(1).then(function(i){s.normalViewport=i.getViewport(1);s.viewport=i.getViewport(1);s.viewport.height=s.viewport.height/10;s.viewport.width=s.viewport.width/10;s.pageRatio=s.viewport.width/s.viewport.height;s.zoomViewport={width:(s.pageRatio>1?1:s.pageRatio)*s.maxDimension,height:s.maxDimension/(s.pageRatio<1?1:s.pageRatio)};s.refPage=i;if(e.numPages>1){e.getPage(2).then(function(i){if(s.options.pageSize==t.PAGE_SIZE.AUTO){var n=i.getViewport(1);if(n.width>s.normalViewport.width*1.5){s.options.pageSize=t.PAGE_SIZE.DOUBLEINTERNAL;s.pageCount=e.numPages*2-2}else{s.options.pageSize=t.PAGE_SIZE.SINGLE}}if(a!=void 0)a(s)})}else{if(a!=void 0)a(s)}});s.linkService=new PDFLinkService;s.linkService.setDocument(e,null);s.pageCount=e.numPages;s.contentSource=e},function r(e){var t="",i=document.createElement("a");i.href=s.contentSource;if(i.hostname!==window.location.hostname)t="CROSS ORIGIN!! ";s.updateInfo(t+"Cannot access file!  "+s.contentSource)});i.onProgress=function d(e){var t=100*e.loaded/e.total;if(isNaN(t)){if(e&&e.loaded){s.updateInfo("Loading PDF "+(Math.ceil(e.loaded/1e4)/100).toString()+"MB ...")}else{s.updateInfo("Loading PDF ...")}}else{s.updateInfo("Loading PDF "+t.toString().split(".")[0]+"% ...")}}};var c=function(){n.pdfjsWorkerSrc+="?ver="+t.version;s.updateInfo("Loading PDF Worker ...");var e=document.createElement("a");e.href=n.pdfjsWorkerSrc;if(e.hostname!==window.location.hostname){s.updateInfo("Loading PDF Worker CORS ...");i.ajax({url:n.pdfjsWorkerSrc,cache:true,success:function(e){n.pdfjsWorkerSrc=t.createObjectURL(e,"text/javascript");d()}})}else{d()}};if(window.PDFJS==void 0){s.updateInfo("Loading PDF Service ...");R(n.pdfjsCompatibilitySrc+"?ver="+t.version,function(){R(n.pdfjsSrc+"?ver="+t.version,function(){if(typeof define==="function"&&define.amd){s.updateInfo("Loading PDF Service (require) ...");require(["pdfjs-dist/build/pdf"],function(e){c()})}else{c()}},function(){s.updateInfo("Unable to load PDF service..")})})}else{d()}}else{console.error("Unknown source type. Please check documentation for help")}this.dispose=function(){if(this.targetObject){if(this.targetObject.dispose)this.targetObject.dispose();this.targetObject.processPage=null;this.targetObject.requestPage=null}if(this.pdfDocument&&this.pdfDocument.destroy)this.pdfDocument.destroy();if(this.linkService&&this.linkService.dispose)this.linkService.dispose();if(this.outlineViewer&&this.outlineViewer.dispose)this.outlineViewer.dispose();if(this.thumblist&&this.thumblist.dispose)this.thumblist.dispose();this.targetObject=null;this.pdfDocument=null;this.linkService=null;this.outlineViewer=null;this.thumblist=null};return this}o.prototype.updateInfo=function(e){if(this.flipbook&&this.flipbook.updateInfo){this.flipbook.updateInfo(e)}};o.prototype.initThumbs=function(){var e=this;if(e.cache[e.thumbsize]==void 0)e.cache[e.thumbsize]=[];var t;var n=function(){clearTimeout(t);t=setTimeout(function(){t=setTimeout(a,e.waitPeriod/2)},e.waitPeriod)};var a=function(){var a=0;if(Date.now()-e.thumblist.lastScrolled<100){a=1}else{e.targetObject.container.find(".df-thumb-container .df-vrow").each(function(){var t=i(this);if(!t.hasClass("df-thumb-loaded")){a++;var o=i(this).attr("id").replace("df-thumb","");e.getPage(o,n,true);t.addClass("df-thumb-loaded");return false}});if(a==0){clearTimeout(t)}}if(a>0){n()}};e.thumblist=e.targetObject.thumblist=new ThumbList({h:500,addFn:function(e){},scrollFn:n,itemHeight:128,totalRows:e.pageCount,generatorFn:function(e){var t=document.createElement("div");var i=e+1;t.id="df-thumb"+i;var n=document.createElement("div");n.innerHTML=i;t.appendChild(n);return t}});e.thumblist.lastScrolled=Date.now();n();e.targetObject.thumbContainer=i(e.thumblist.container).addClass("df-thumb-container df-thumb-visible");e.targetObject.container.append(e.targetObject.thumbContainer);e.thumblist.reset(i(e.thumblist.container).height());e.targetObject.container.on("click",".df-thumb-container .df-vrow",function(t){t.stopPropagation();var n=i(this).attr("id").replace("df-thumb","");e.targetObject.gotoPage(parseInt(n,10))})};o.prototype.initOutline=function(){var e=this;var t=i("<div>").addClass("df-outline-container");e.targetObject.container.append(t);e.targetObject.outlineContainer=t;e.outlineViewer=new BookMarkViewer({container:t[0],linkService:e.linkService,outlineItemClass:"df-outline-item",outlineToggleClass:"df-outline-toggle",outlineToggleHiddenClass:"df-outlines-hidden"});function n(t){if(e.options.overwritePDFOutline==true){t=[]}t=t||[];if(e.outline){for(var i=0;i<e.outline.length;i++){e.outline[i].custom=true;if(t)t.push(e.outline[i])}}e.outlineViewer.render({outline:t})}if(e.pdfDocument){e.pdfDocument.getOutline().then(function(e){n(e)})}else{n([])}if(e.options.autoEnableOutline==true){e.targetObject.ui.outline.trigger("click")}};o.prototype.checkViewportSize=function(e,t){var i=this;var n=i.targetObject;var a=i.cacheIndex;if(i.contentSourceType==l.PDF){i.viewport=n.mode=="css"?i.refPage.getViewport(t/i.normalViewport.height):i.refPage.getViewport(300/i.normalViewport.height);i.cacheIndex=S(Math.max(e,t));i.cacheIndex=C(i.cacheIndex,i.minDimension,i.maxDimension);i.cacheScale=i.cacheIndex/Math.max(i.normalViewport.width,i.normalViewport.height);if(i.cache[i.cacheIndex]==void 0)i.cache[i.cacheIndex]=[];if(a!==i.cacheIndex){for(var o=0;o<n.children.length;o++){var r=n.children[o];r.name="-1"}n.refresh()}var s=n.container.find(".linkAnnotation");s.css({transform:"matrix("+i.viewport.clone({dontFlip:true}).transform.join(",")+")"})}else{if(i.cache[i.cacheIndex]==void 0)i.cache[i.cacheIndex]=[]}};o.prototype.getCache=function(e,t){return t==true?this.cache[this.thumbsize]==void 0?void 0:this.cache[this.thumbsize][e]:this.cache[this.cacheIndex]==void 0?void 0:this.cache[this.cacheIndex][e]};o.prototype.setCache=function(e,t,i,n){if(i==true){if(this.cache[this.thumbsize]!=void 0)this.cache[this.thumbsize][e]=t}else{var a=n==void 0?this.cacheIndex:n;if(this.cache[a]!=void 0)this.cache[a][e]=t}};o.prototype.setTarget=function(e){var t=this;if(e==void 0){return this.targetObject}else{this.targetObject=e;e.contentProvider=this;e.container.removeClass("df-loading df-init");if(t.linkService!==void 0){t.linkService.setViewer(e);t.initOutline()}e.processPage=function(e,i){if(e>0&&e<=t.pageCount){t.getPage(e,i)}else{t.setPage(e,n.textureLoadFallback,i)}};e.requestPage=function(e){t.setPage(e,n.textureLoadFallback);t.review("Request")};if(e.resize!==void 0)e.resize()}};o.prototype.review=function(e){var t=this;e=e||"timer review";clearTimeout(a);a=setTimeout(function(){a=setTimeout(t.reviewPages,t.waitPeriod/2,t,e)},t.waitPeriod)};o.prototype.reviewPages=function(e,t){e=e||this;var n=e.targetObject;if(n==void 0)return;if(t!==void 0)L(t);var a=false;var o,r;for(o=0;o<e.targetObject.children.length;o++){r=n.children[o];if(r.isFlipping==true){a=true;break}}if(a==false){var s=n.children.length;var l=s/2;var d=T(n._activePage);if(e.zoomScale>1){s=1}for(o=0;o<s;o++){var c=Math.floor(o/2);var f=o%2==0?-c*2:(c==0?1:c)*2;var u=d+f,h=d+f+1;var p=n.getPageByNumber(u);var g=n.getPageByNumber(h);var v=0;if(p!==void 0&&p.frontTextureLoaded!=true){n.processPage(u,function(){e.review("Batch Call")});p.frontTextureLoaded=true;v++}if(g!==void 0&&g.backTextureLoaded!=true){n.processPage(h,function(){e.review("Batch Call")});g.backTextureLoaded=true;v++}if(f==0&&e.annotedPage!==d&&n.mode!=="css"){e.getAnnotations(u);e.getAnnotations(h);e.annotedPage=d}if(v>0){break}}if(v==0)e.setLoading(d),e.setLoading(d+1)}else{e.review("Revisit request");if(e.annotedPage!==void 0&&n.mode!=="css"){var m=T(n._activePage);i(n.getContentLayer(m)).html("");i(n.getContentLayer(m+1)).html("");e.annotedPage=void 0}}};o.prototype.getPage=function(e,i,a){var o=this;e=parseInt(e,10);var r=o.contentSource;if(e<=0&&e>=o.pageCount){o.setPage(e,n.textureLoadFallback,i,a)}else{if(o.contentSourceType==l.PDF){if(o.getCache(e,a)!==void 0){o.setPage(e,o.getCache(e,a),i,a);L("Page "+e+" loaded from cache")}else{if(a!==true)o.setLoading(e,true);var s=e;if(o.options.pageSize==t.PAGE_SIZE.DOUBLEINTERNAL&&e>2){s=Math.ceil((e-1)/2)+1}r.getPage(s,a).then(function(t){c(t,e,i,a)})}}else if(o.contentSourceType==l.IMAGE||o.contentSourceType==l.HTML){if(o.getCache(e,a)!==void 0){o.setPage(e,o.getCache(e,a),i,a);L("Page "+e+" loaded from cache")}else{if(a!==true)o.setLoading(e,true);d(r[e-1],function(t){o.setCache(e,t,a,o.cacheIndex);o.setPage(e,t,i,a);if(i!=void 0)i()},o.isCrossOrigin)}}}function d(e,i,a){var o=new Image;o.crossOrigin="Anonymous";o.onload=function(){if(a==true){var r=document.createElement("canvas"),s=r.getContext("2d");r.width=o.width;r.height=o.height;s.drawImage(o,0,0);if(n.canvasToBlob==true){r.toBlob(function(e){var n=t.createObjectURL(e,"image/jpeg");if(i!=void 0)i(n)},"image/jpeg",.85)}else{if(i!=void 0)i(r)}}else{if(i!=void 0)i(e)}o.onload=null;o=null};o.src=e;if(o.complete||o.complete===undefined){o.src="data:image/gif;base64,R0lGODlhAQABAIAAAAAAAP///ywAAAAAAQABAAACAUwAOw==";o.src=e}}function c(e,i,n,a){L("rendering"+i);var r=o.cacheScale;var s;var l=document.createElement("canvas");var d=performance.now();var c=o.cacheIndex;var f=l.getContext("2d");if(a==true){r=o.thumbsize/o.normalViewport.height}l.height=o.normalViewport.height*r;l.width=o.normalViewport.width*r;s=e.getViewport(r);if(o.options.pageSize==t.PAGE_SIZE.DOUBLEINTERNAL&&i>2&&i%2==1){s.transform[4]=-l.width}var u={canvasContext:f,viewport:s};e.cleanupAfterRender=true;var h=e.render(u);h.promise.then(function(){L(performance.now()-d);d=performance.now();if(a==true||o.options.canvasToBlob==true&&o.webgl!==true){l.toBlob(function(e){var r=t.createObjectURL(e,"image/jpeg");L(performance.now()-d);o.setCache(i,r,a,c);o.setPage(i,r,n,a)},"image/jpeg",.85)}else{o.setPage(i,l,n,a)}u=null})}};o.prototype.getTargetPage=function(e){};o.prototype.setLoading=function(e,t){if(this.targetObject!==void 0){if(this.webgl==true){var n=this.targetObject.container;if(t==true)n.addClass("df-loading");else n.removeClass("df-loading")}else{var a=i(this.targetObject.getContentLayer(e));if(a!==void 0){if(t==true)a.addClass("df-page-loading");else a.removeClass("df-page-loading")}}}};o.prototype.getAnnotations=function(e){var n=this;var a=n.targetObject;e=parseInt(e,10);var o=n.contentSource;var r=i(a.getContentLayer(e));r.empty();if(e>0&&e<=n.pageCount){if(n.contentSourceType==l.PDF){var s=T(e);var d=e;if(n.options.pageSize==t.PAGE_SIZE.DOUBLEINTERNAL&&e>2){d=Math.ceil((e-1)/2)+1}o.getPage(d).then(function(t){if(r!==void 0&&r.length>0){n.setupAnnotations(t,n.viewport,r,e)}})}if(n.links!==void 0&&n.links[e]!==void 0){var c=n.links[e];for(var f=0;f<c.length;f++){var u=c[f];var h=document.createElement("a");h.setAttribute("dest",u.dest);h.className="customLinkAnnotation";h.href="#"+u.dest;h.onclick=function(){var e=this.getAttribute("dest");if(e){n.linkService.customNavigateTo(e)}return false};h.style.left=u.x+"%";h.style.top=u.y+"%";h.style.width=u.w+"%";h.style.height=u.h+"%";r[0].appendChild(h)}}if(n.html!==void 0&&n.html[e]!==void 0){var p=n.html[e];r.append(i("<div class='customHTMLAnnotation'>").html(p))}}};o.prototype.setPage=function(e,i,a,o){var r=this;var s=r.targetObject;if(o==true){var l=r.targetObject.container.find("#df-thumb"+e);l.css({backgroundImage:P(i)})}else{if(i==n.textureLoadFallback){L("Fallback on "+e)}else{if(s.mode=="css")r.getAnnotations(e)}var d=s.getPageByNumber(e);if(d!==void 0){if(e%2!=0&&s.direction==t.DIRECTION.LTR||e%2!=1&&s.direction==t.DIRECTION.RTL){L(e+"rendered to back of "+d.color);d.backImage(i,function(){r.setLoading(e);if(a!=void 0)a()})}else{L(e+"rendered to front of "+d.color);d.frontImage(i,function(){r.setLoading(e);if(a!=void 0)a()})}}else{L("Invalid set request on Page "+e)}}};o.prototype.setupAnnotations=function(e,n,a,o){if(a==void 0||i(a).length==0)return;var r=this;return e.getAnnotations().then(function(s){n=n.clone({dontFlip:true});if(r.options.pageSize==t.PAGE_SIZE.DOUBLEINTERNAL&&o>2&&o%2==1){}else if(o==1){}if(a==void 0){return}a=i(a);if(a.find(".annotationDiv").length==0){a.append(i("<div class='annotationDiv'>"))}var l=a.find(".annotationDiv");l.empty();if(r.options.pageSize==t.PAGE_SIZE.DOUBLEINTERNAL&&o>2&&o%2==1){l.css({left:"-100%"})}else if(o==1){l.css({left:""})}PDFJS.AnnotationLayer.render({annotations:s,div:l[0],page:e,viewport:n,linkService:r.linkService});l.find(" > section").addClass("someclass")})};return o}({});var W=function(){function e(e){this.angles=e.angles||[0,0,0,0,0,0];this.stiffness=e.angles||.1;this.segments=e.segments||1;this.initDOM()}function n(e){var t=e.contentLayer=i(u.div,{"class":"df-page-content"});e.append(t)}e.prototype={initDOM:function(){var e=this.element=i(u.div,{"class":"df-book-page"});var t=this.wrapper=i(u.div,{"class":"df-page-wrapper"});var a=this.front=i(u.div,{"class":"df-page-front"});var o=this.back=i(u.div,{"class":"df-page-back"});var r=this.foldInnerShadow=i(u.div,{"class":"df-page-fold-inner-shadow"});var s=this.foldOuterShadow=i(u.div,{"class":"df-page-fold-outer-shadow"});n(a,this.segments,true);n(o,this.segments,false);e.append(t).append(s);t.append(a).append(o).append(r)},updatePoint:function(e){if(e==void 0)return;var i=this.parent.dragPage!=void 0?this.parent.dragPage:e.page!=void 0?e.page:this;var n=i.element.width(),a=i.element.height();var o=this.parent.corner!==void 0?this.parent.corner:e.corner,r=t.CORNERS;var s=i.side==c.right,l=o==r.BL||o==r.BR;e.rx=s==true?n*2-e.x:e.x;e.ry=l==true?a-e.y:e.y;var d=Math.atan2(e.ry,e.rx);d=Math.PI/2-C(d,0,h(90));var f=s?e.x/2:n-e.x/2,u=e.ry/2,g=Math.max(0,Math.sin(d-Math.atan2(u,f))*y(f,u)),m=.5*y(e.rx,e.ry);var b=Math.round(n-g*Math.sin(d)),P=Math.round(g*Math.cos(d)),x=p(d);var k=l?s?180+(90-x):180+x:s?x:90-x;var E=l?s?180+(90-x):x:s?x+180:k,L=l?s?90-x:x+90:s?k-90:k+180,S=s?n-b:b,I=l?a+P:-P,T=s?-b:b-n,R=l?-a-P:P;var O=C(e.distance*.5/n,0,.5);var F=C((n*2-e.rx)*.5/n,.05,.3);i.element.addClass("df-folding");var M=s?i.back:i.front;var B=s?i.front:i.back;var N=i.foldOuterShadow;var z=i.foldInnerShadow;i.wrapper.css({transform:v(S,I)+w(k)});M.css({transform:w(-k)+v(-S,-I)});B.css({transform:w(E)+v(T,R),boxShadow:"rgba(0, 0, 0, "+O+") 0px 0px 20px"});z.css({transform:w(E)+v(T,R),opacity:F/2,backgroundImage:D.css+"linear-gradient( "+L+"deg, rgba(0, 0, 0, 0.25) , rgb(0, 0, 0) "+m*.7+"px, rgb(255, 255, 255) "+m+"px)"});N.css({opacity:F/2,left:s?"auto":0,right:s?0:"auto",backgroundImage:D.css+"linear-gradient( "+(-L+180)+"deg, rgba(0, 0, 0,0) "+m/3+"px, rgb(0, 0, 0) "+m+"px)"})},updateAngle:function(e,t){var i=this.element.width()*5;this.wrapper.css({perspective:i,perspectiveOrigin:t==true?"0% 50%":"100% 50%"});this.front.css({display:t==true?e<=-90?"block":"none":e<90?"block":"none",transform:(D.dom!=="MfS"?"":"perspective("+i+"px) ")+(t==true?"translateX(-100%) ":"")+"rotateY("+((t==true?180:0)+e)+"deg)"});this.back.css({display:t==true?e>-90?"block":"none":e>=90?"block":"none",transform:(D.dom!=="MSd"?"":"perspective("+i+"px) ")+(t==false?"translateX(100%) ":"")+"rotateY("+((t==false?-180:0)+e)+"deg)"});return},tween:function(e){var i=this;if(i==void 0||i.parent==void 0)return;var n=i.side==c.right;var a=i.parent.corner==t.CORNERS.BL||i.parent.corner==t.CORNERS.BR;var o=a?i.parent.height:0;var r,s,l,d=0;var f=i.end=i&&i.animateToReset==true?{x:n?i.parent.fullWidth:0,y:o}:{x:n?0:i.parent.fullWidth,y:o};i.ease=i.isHard?TWEEN.Easing.Quadratic.InOut:TWEEN.Easing.Linear.None;var u=i.parent.duration;if(i.isHard==true){if(e!=void 0){d=E(e.distance,e.fullWidth)}r=i.init={angle:d*(n?-1:1)};f=i.end=i&&i.animateToReset==true?{angle:n?0:-0}:{angle:n?-180:180}}else{if(e==void 0){r=i.init=i&&i.animateToReset==true?{x:n?0:i.parent.fullWidth,y:0}:{x:n?i.parent.fullWidth:0,y:0};s=i.first={x:(n?3:1)*i.parent.fullWidth/4,y:0};l=i.mid={x:(n?1:3)*i.parent.fullWidth/4,y:0}}else{r=i.init={x:e.x,y:e.y};s=i.first={x:e.x*3/4,y:e.y*3/4};l=i.mid={x:e.x/4,y:e.y/4};u=i.parent.duration*k(r.x,r.y,f.x,f.y)/i.parent.fullWidth;u=C(u,i.parent.duration/3,i.parent.duration)}}i.isFlipping=true;var h=function(e){if(i.isHard==true){i.updateAngle(e.angle,n)}else{i.updatePoint({x:e.x,y:e.y})}};var p=i.completeTween=i.completeTween||function(e){i.isFlipping=false;if(i.isHard==true){i.updateAngle(i.end.angle);i.back.css({display:"block"});i.front.css({display:"block"})}else{i.updatePoint({x:i.end.x,y:i.end.y})}if(i.animateToReset!==true){i.side=i.side==c.right?c.left:c.right}else i.animateToReset=void 0;i.currentTween=void 0;i.pendingPoint=void 0;i.magnetic=false;i.parent.dragPage=void 0;i.parent.corner=t.CORNERS.NONE;if(e!=true)i.parent.refresh()};if(i.isHard==true){i.currentTween=new TWEEN.Tween(r).delay(0).to(f,i.parent.duration).onUpdate(function(){h(this)}).easing(i.ease).onComplete(i.completeTween).start()}else{if(e==void 0){i.currentTween=new TWEEN.Tween(r).delay(0).to(f,i.parent.duration).onUpdate(function(){h(this)}).easing(TWEEN.Easing.Sinusoidal.Out).onComplete(i.completeTween).start()}else{i.currentTween=new TWEEN.Tween(r).delay(0).to(f,u).onUpdate(function(){h(this)}).easing(TWEEN.Easing.Sinusoidal.Out).onComplete(i.completeTween);i.currentTween.start()}}},frontImage:function(e,t){if(e.nodeName=="CANVAS"){this.front.find(">canvas").remove();this.front.append(i(e))}else{this.front.css({backgroundImage:P(e)})}if(t!==void 0)t()},backImage:function(e,t){if(e.nodeName=="CANVAS"){this.back.find(">canvas").remove();this.back.append(i(e))}else{this.back.css({backgroundImage:P(e)})}if(t!==void 0)t()},updateCSS:function(e){this.element.css(e)},resetCSS:function(){this.wrapper.css({transform:""});this.front.css({transform:"",boxShadow:""});this.back.css({transform:"",boxShadow:""})},clearTween:function(e){this.currentTween.stop();this.completeTween(e==true);this.resetCSS()}};return e}();var V=function(e){B(r,e);function n(e){e.parent.container.find(".df-folding").removeClass("df-folding");e.element.addClass("df-folding")}function o(e){var t=false;for(var i=0;i<e.pages.length;i++){var n=e.pages[i];if(n.isFlipping==true){t=true;break}}return t}function r(e,r){var s=this;s.type="BookCSS";s.images=e.images||[];s.pageCount=e.pageCount||2;s.foldSense=50;s.stackCount=4;s.mode="css";s.pages=[];s.duration=e.duration;s.container=i(r);s.options=e;s.drag=c.none;s.pageCount=s.pageCount==1?s.pageCount:Math.ceil(s.pageCount/2)*2;s.pageMode=e.pageMode||(F||s.pageCount<=2?t.PAGE_MODE.SINGLE:t.PAGE_MODE.DOUBLE);s.swipe_threshold=F?15:50;s.direction=e.direction||t.DIRECTION.LTR;s.startPage=1;s.endPage=s.pageCount;s._activePage=e.openPage||s.startPage;s.hardConfig=e.hard;a="WebKitCSSMatrix"in window||document.body&&"MozPerspective"in document.body.style;s.animateF=function(){if(TWEEN.getAll().length>0)TWEEN.update();else clearInterval(s.animate)};s.init(e);s.skipDrag=false;function l(e){if(s.dragPage!=e.page&&e.page.visible==true){s.dragPage.clearTween(true);s.dragPage=e.page;s.corner=e.corner;s.dragPage.pendingPoint=e}}var d=function(e){var i=s.eventToPoint(e);if(e.touches!==void 0&&e.touches.length>1)return;var n=s.dragPage||i.page;if(s.contentProvider.zoomScale!==1){if(e.touches!==void 0||s.isPanning==true){s.pan(i);e.preventDefault()}}else{if(s.skipDrag!==true){var a=i.distance;if(!o(s)){if(s.dragPage!==void 0||i.isInside==true){if(s.dragPage!==void 0){L("set mouse down move")}else{i.y=C(i.y,1,s.height-1);i.x=C(i.x,1,i.fullWidth-1)}var r=s.corner||i.corner;if(n.isHard){var l=r==t.CORNERS.BR||r==t.CORNERS.TR;var d=E(i.distance,i.fullWidth);n.updateAngle(d*(l?-1:1),l)}else{n.updatePoint(i,s)}n.magnetic=true;n.magneticCorner=i.corner;e.preventDefault()}if(s.dragPage==void 0&&n!==void 0&&i.isInside==false&&n.magnetic==true){n.pendingPoint=i;n.animateToReset=true;s.corner=n.magneticCorner;s.animatePage(n);n.pendingPoint=void 0;n.magnetic=false;n.magneticCorner=void 0}if(s.isPanning==true&&s.dragPage==void 0&&s.contentProvider.zoomScale==1){var f=i.x-s.lastPos,u=performance.now()-s.lastTime;if(Math.abs(f)>s.swipe_threshold){if(f<0){s.next()}else{s.prev()}s.drag=c.none;s.isPanning=false;e.preventDefault()}s.lastPos=i.x;s.lastTime=performance.now()}}}}},f=function(e){s.isPanning=false;if(e.touches!==void 0&&e.touches.length>1)return;if(s.skipDrag!==true){if(s.dragPage){e.preventDefault();var i=s.eventToPoint(e);s.dragPage.pendingPoint=i;if(i.x==s.startPoint.x&&i.y==s.startPoint.y&&i.isInside==true){if(s.corner==t.CORNERS.BR||s.corner==t.CORNERS.TR){l(i);if(s.dragPage.isFlipping!==true)s.next()}else if(s.corner==t.CORNERS.BL||s.corner==t.CORNERS.TL){l(i);if(s.dragPage.isFlipping!==true)s.prev()}}else if(s.dragPage.isFlipping!==true){if(i.distance>i.fullWidth/2){if(i.x>i.fullWidth/2)s.prev();else s.next()}else{s.dragPage.animateToReset=true;s.animatePage(s.dragPage)}}if(s.dragPage){s.dragPage.pendingPoint=void 0;s.dragPage.magnetic=false}}s.drag=c.none}},u=function(e){if(e.touches!==void 0&&e.touches.length>1)return;var i=s.eventToPoint(e);s.startPoint=i;s.left=s.left||0;s.top=s.top||0;s.isPanning=true;s.lastPos=i.x;s.lastTime=performance.now();if(s.skipDrag!==true){if(i.isInside==true&&!o(s)){s.startPoint=i;s.drag=i.drag;s.dragPage=i.page;s.corner=i.corner;L(s.corner);n(s.dragPage);if(i.page.isHard){}else{i.page.updatePoint(i,s)}if(i.page.name=="0"){s.shadow.css({width:"50%",left:s.direction==t.DIRECTION.RTL?0:"50%",transitionDelay:""})}else if(i.page.name==Math.ceil(s.pageCount/2)-1){s.shadow.css({width:"50%",left:s.direction==t.DIRECTION.RTL?"50%":0,transitionDelay:""})}}}},h=function(e){var t=0;if(e.wheelDelta!=void 0){t=e.wheelDelta/120}else if(e.detail!==void 0){t=-e.detail/3}var i=s.contentProvider.zoomScale,n=s.contentProvider.maxZoom;if(t){if(t>0&&i<n||t<0&&i>1){e.stopPropagation();e.preventDefault();var a=s.eventToPoint(e);var o=s.eventToPoint(e);var r={x:s.container.width()/2,y:-23+s.container.height()/2};s.previewObject.zoom(t);var l=s.contentProvider.zoomScale;if(i!==l){var d=l/i;if(l==1){s.left=0;s.top=0}else{s.left*=d;s.top*=d}var c=(a.raw.x-r.x)*d,f=(a.raw.y-r.y)*d;o.raw.x=r.x+c;o.raw.y=r.y+f;s.startPoint=o;s.pan(a);var u=s.dragPage||a.page;if(s.dragPage==void 0&&u!==void 0&&a.isInside==true&&u.magnetic==true){u.pendingPoint=a;u.animateToReset=true;s.corner=u.magneticCorner;s.animatePage(u);u.pendingPoint=void 0;u.magnetic=false;u.magneticCorner=void 0}}}}};var p=s.container[0];var g=s.stage[0];if(p){p.addEventListener("mousemove",d,false);p.addEventListener("touchmove",d,false);p.addEventListener("mousedown",u,false);p.addEventListener("mouseup",f,false);p.addEventListener("touchend",f,false);p.addEventListener("touchstart",u,false);if(s.options.scrollWheel==true){g.addEventListener("mousewheel",h,false);g.addEventListener("DOMMouseScroll",h,false)}}this.dispose=function(){p.removeEventListener("mousemove",d,false);p.removeEventListener("touchmove",d,false);p.removeEventListener("mousedown",u,false);p.removeEventListener("mouseup",f,false);p.removeEventListener("touchend",f,false);p.removeEventListener("touchstart",u,false);if(s.options.scrollWheel==true){g.removeEventListener("mousewheel",h,false);g.removeEventListener("DOMMouseScroll",h,false)}s.flipCallback=null;s.animateF=null;s.stage.remove()}}function s(e,t){return true}r.prototype={add:function(e){if(e instanceof W)this.container.append(i(e.element));else this.container.append(i(e))},pan:function(e){var t=this.startPoint;var i=this.contentProvider.zoomScale;var n=this.left+(e.raw.x-t.raw.x),a=this.top+(e.raw.y-t.raw.y);this.left=C(n,-this.shiftWidth,this.shiftWidth);this.top=C(a,-this.shiftHeight,this.shiftHeight);this.startPoint=e;this.stage.css({transform:"translate3d("+this.left+"px,"+this.top+"px,0)"})},getPageByNumber:function(e){var t=Math.floor((e-1)/2);var i;for(var n=0;n<this.pages.length;n++){if(t==parseInt(this.pages[n].name,10))i=this.pages[n]}return i},getPageSide:function(e){var i=this.direction==t.DIRECTION.RTL;var n=this.getPageByNumber(e);if(n==void 0)return;if(e%2==0)return i?n.back:n.front;else return i?n.front:n.back},getContentLayer:function(e){var t=this.getPageSide(e);return t==void 0?void 0:t.contentLayer}};r.prototype.init=function(e){var t=this;t.stage=i(u.div,{"class":"df-book-stage"});t.wrapper=i(u.div,{"class":"df-book-wrapper"});t.shadow=i(u.div,{"class":"df-book-shadow"});t.container.append(t.stage);t.stage.append(t.wrapper);t.wrapper.append(t.shadow);t.createStack(e)};r.prototype.createStack=function(e){var t="red,green,blue,yellow,orange,black".split(",");for(var i=0;i<this.stackCount;i++){e.angles=[,this.stackCount-i];e.stiffness=(this.stackCount-i)/100;var n=new W(e);n.angles[1]=180;n.index=i;n.parent=this;n.textureReady=false;n.textureRequested=false;this.wrapper.append(n.element);n.isFlipping=false;this.pages.push(n);n.color=t[i]}this.children=this.pages};r.prototype.isPageHard=function(e){if(this.hardConfig!==void 0){var t=this.hardConfig;if(t=="cover"){return e==0||e==Math.floor(this.pageCount/2)-1}else if(t=="all"){return true}else{var i=(","+t+",").indexOf(","+(e*2+1)+",")>-1;var n=(","+t+",").indexOf(","+(e*2+2)+",")>-1;return i||n}}return false};r.prototype.setDuration=function(e){this.duration=e};r.prototype.moveBy=function(e){var t=this._activePage+e;t=C(t,this.startPage,this.endPage);this.gotoPage(t)};r.prototype.next=function(e){if(e==void 0)e=this.direction==t.DIRECTION.RTL?-this.pageMode:this.pageMode;this.moveBy(e)};r.prototype.prev=function(e){if(e==void 0)e=this.direction==t.DIRECTION.RTL?this.pageMode:-this.pageMode;this.moveBy(e)};r.prototype.eventToPoint=function(e){e=O(e);var n=this.wrapper,a=this.pages,o=this.pageWidth,r=this.fullWidth,s=this.height,l=i(window),d={x:e.clientX,y:e.clientY};var f=d.x-n[0].getBoundingClientRect().left;var u=d.y-n[0].getBoundingClientRect().top;d.x=d.x-this.container[0].getBoundingClientRect().left;d.y=d.y-this.container[0].getBoundingClientRect().top;var h=this.drag==c.none?f<o?f:r-f:this.drag==c.left?f:r-f;var p=f<o?a[this.stackCount/2-1]:a[this.stackCount/2];var g=f<this.foldSense?c.left:f>r-this.foldSense?c.right:c.none;var v=f,m=u,w=s,b=r,P=this.foldSense,x=t.CORNERS,C;if(v>=0&&v<P){if(m>=0&&m<=P)C=x.TL;else if(m>=w-P&&m<=w)C=x.BL;else if(m>P&&m<w-P)C=x.L;else C=x.NONE}else if(v>=b-P&&v<=b){if(m>=0&&m<=P)C=x.TR;else if(m>=w-P&&m<=w)C=x.BR;else if(m>P&&m<w-P)C=x.R;else C=x.NONE}else C=x.NONE;return{isInside:C!==x.NONE&&C!==x.L&&C!==x.R,x:f,y:u,fullWidth:r,rawDistance:r-f,distance:h,page:p,drag:g,foldSense:this.foldSense,event:e,raw:d,corner:C}};r.prototype.gotoPage=function(e){e=parseInt(e,10);this._activePage=e;this.updatePage(e)};r.prototype.refresh=function(){this.updatePage(this._activePage);if(this.flipCallback!==void 0)this.flipCallback()};r.prototype.updatePage=function(e){var n=this.direction==t.DIRECTION.RTL;e=Math.floor(e/2);if(n)e=Math.floor(this.pageCount/2)-e;var a=this.oldBaseNumber||0;var o=this.pageCount/2;var r=this.stackCount;var s=Math.floor(r/2);if(a>e){this.children[r-1].skipFlip=true;this.children.unshift(this.children.pop())}else if(a<e){this.children[0].skipFlip=true;this.children.push(this.children.shift())}for(var l=0;l<r;l++){var d=this.children[l];if(a!==e){if(d.currentTween!==void 0){d.clearTween(true)}}var f=d.side;var u;var h=e-s+l;var p=d.name;d.isHard=this.isPageHard(h);if(d.isHard){d.element.addClass("df-hard-page")}else{d.element.removeClass("df-hard-page");d.front.css({display:"block"});d.back.css({display:"block"})}var g=i(d.element).attr("pageNumber");if(g!=h){d.front.contentLayer.empty();d.back.contentLayer.empty()}i(d.element).attr("pageNumber",h);d.visible=h>=0&&h<o;if(this.requestPage!==void 0&&d.visible==true){if(n)h=Math.floor(this.pageCount/2)-h-1;d.name=h.toString();if(d.name!=p){d.backTextureLoaded=false;d.frontTextureLoaded=false;d.thumbLoaded=false;this.requestPage(h*2+1);this.requestPage(h*2+2)}}d.isEdge=false;if(l==0){}else if(l==r-1){}else{d.isEdge=false}if(l<s){u=c.left}else{u=c.right}if(d.isFlipping==false){if(u!==f&&d.skipFlip==false){this.animatePage(d);if(this.preFlipCallback!==void 0)this.preFlipCallback()}else{d.skipFlip=false;d.element.removeClass("df-flipping df-quick-turn df-folding df-left-side df-right-side");d.element.addClass(l<s?"df-left-side":"df-right-side");d.side=u}}d.oldDepth=d.depth;d.updateCSS({display:d.visible==true?"block":"none",zIndex:6+(l<s?l-s:s-l),transform:""});if(d.pendingPoint==void 0){d.resetCSS()}}if(TWEEN.getAll().length==0){clearInterval(this.animate)}i(".quick-hint").html(e);this.oldBaseNumber=e;if(this.updatePageCallback!==void 0)this.updatePageCallback()};r.prototype.animatePage=function(e){e.element.addClass("df-flipping");e.isFlipping=true;if(this.animate!==void 0){clearInterval(this.animate)}this.animate=setInterval(this.animateF,30);
e.tween(e.pendingPoint)};return r}({});var G=function(e){B(n,e);function n(n,a,o){e.call(this,o);var r=this;r.type="FlipBook";r.container=n;r.options=o;r.options.source=a;r.contentSource=a;if(o.height!==void 0&&o.height.toString().indexOf("%")<0){r.container.height(Math.min(o.height,i(window).height()))}else{r.container.height(o.height)}if(!r.options.isLightBox&&r.container.attr("id")!==void 0){r.options.id=r.container.attr("id")}if(r.options.parsed!==true&&r.options.links!=void 0){t.parseLinks(r.options.links)}var s=r.webgl=o.webgl==true&&M==true;n.addClass("df-container df-loading df-init df-floating");if(r.options.transparent==true){n.addClass("df-transparent")}r.container.info=i(u.div,{"class":"loading-info"}).appendTo(r.container).html("Loading...");if(navigator.userAgent.indexOf("MSIE")!==-1||navigator.appVersion.indexOf("Trident/")>0){r.options.webgl=false}if(!!navigator.userAgent.match(/msie\s[5-9]/i)){r.container.info.html("Your browser (Internet Explorer) is out of date to run DFlip Flipbook Plugin. <br><a href='http://browsehappy.com/'>Upgrade to a new one</a>").addClass("df-old-browser");n.removeClass("df-loading");return r}r.container.css({position:"relative",overflow:"hidden",backgroundColor:o.backgroundColor,backgroundImage:"url('"+o.backgroundImage+"')"});r.init(s,a);if(r.options.onCreate!==void 0)r.options.onCreate();return r}n.prototype.init=function(e){var n=this;var a=n.target;var o=n.options;if(e==true){A(function(){n.container.css({minHeight:300,minWidth:300});n.stage=new _(I(n.options,{container:n.container}));n.stage.previewObject=n;n.contentProvider=new H(n.contentSource,function(o){var r={pageCount:o.pageCount,stackCount:6,segments:20,width:300*o.pageRatio,height:300};n.checkOpenPage();n.target=a=n.stage.target=new MOCKUP.Book(I(n.options,r),n.stage);z(n.container,n);a.ui=n.ui;a.container=n.container;o.webgl=e;o.setTarget(n.target);a.getContentLayer=function(e){var i=a.direction==t.DIRECTION.RTL,o=n.stage.cssScene.divLeft.element,r=n.stage.cssScene.divRight.element;var s=T(a._activePage);if(e%2==0)return i?r:o;else return i?o:r};a.stage=n.stage;a.flipCallback=function(){n.contentProvider.review("flipCallback");var e=T(a._activePage);var o,r;var s=a.getPageByNumber(e),l=a.getPageByNumber(e+1);var d=a.parent.cssScene.divLeft,c=a.parent.cssScene.divRight;var f=a.pageMode==t.PAGE_MODE.SINGLE;var u=a.direction==t.DIRECTION.RTL;if(s!==void 0&&d!==void 0){o=Math.abs(s.geometry.boundingBox.max.x-s.geometry.boundingBox.min.x);r=Math.abs(s.geometry.boundingBox.max.z-s.geometry.boundingBox.min.z);d.rotation.y=-Math.atan2(r,o)*.9;d.position.z=r*.8;d.position.x=r/2.5;i(d.element).css({width:o,left:-o/2})}if(l!==void 0&&c!==void 0){o=Math.abs(l.geometry.boundingBox.max.x-l.geometry.boundingBox.min.x);r=Math.abs(l.geometry.boundingBox.max.z-l.geometry.boundingBox.min.z);c.rotation.y=Math.atan2(r,o)*.9;c.position.z=r*.8;c.position.x=-r/2.5;i(c.element).css({width:o,left:o/2})}if(n.options.onFlip!==void 0)n.options.onFlip()};a.resize=function(){n.resize()}();a.updatePageCallback=function(){n.ui.update();n.checkCenter();n.stage.renderRequestPending=true};var s=i(n.stage.cssScene.divLeft.element);var l=i(n.stage.cssScene.divRight.element);a.preFlipCallback=function(){s.empty();l.empty();if(n.options.beforeFlip!==void 0)n.options.beforeFlip();n.playSound()};i(window).trigger("resize");s.css({width:300*o.pageRatio,height:300,left:-300*o.pageRatio/2});l.css({width:300*o.pageRatio,height:300,left:300*o.pageRatio/2});a.ease=TWEEN.Easing.Cubic.InOut;a.contentProvider=o;a.duration=n.options.duration;a.gotoPage(a._activePage);a.flipCallback();if(n.options.onReady!==void 0)n.options.onReady()},o,n)})}else{n.contentProvider=new H(n.contentSource,function(t){var o={pageCount:t.pageCount};n.checkOpenPage();n.target=a=new V(I(n.options,o),n.container);n.target.previewObject=n;z(n.container,n);t.webgl=e;t.setTarget(n.target);t.waitPeriod=2;a.ease=TWEEN.Easing.Quadratic.InOut;a.duration=n.options.duration;a.container=n.container;a.updatePageCallback=function(){n.ui.update();n.checkCenter()};a.gotoPage(a._activePage);a.resize=function(){n.resize()}();i(window).trigger("resize");a.flipCallback=function(){n.contentProvider.review("flipCallback");if(n.options.onFlip!==void 0)n.options.onFlip()};a.preFlipCallback=function(){if(n.options.beforeFlip!==void 0)n.options.beforeFlip();n.playSound()};if(n.options.onReady!==void 0)n.options.onReady()},o,n)}};n.prototype.getURLHash=function(){if(this.options.id!=void 0){var e="dflip-"+this.options.id+"/";if(this.target!=void 0&&this.target._activePage!=void 0){e+=this.target._activePage+"/"}window.location.hash=e}return window.location.href};n.prototype.checkOpenPage=function(){if(this.options.id!=void 0){var e=i("#"+this.options.id);if(e.length>0&&e.data("page")!==void 0){var t=parseInt(e.data("page"),10);if(!isNaN(t))this.options.openPage=t}}};n.prototype.end=function(){this.target.gotoPage(this.target.endPage)};n.prototype.gotoPage=function(e){this.target.gotoPage(e);if(this.ui!==void 0)this.ui.update()};n.prototype.prev=function(){this.target.prev()};n.prototype.next=function(){this.target.next()};n.prototype.updateInfo=function(e){if(this.container&&this.container.info&&this.container.info.html)this.container.info.html(e)};return n}(U);i.fn.extend({shelf:function(){},flipBook:function(e,t){return new G(i(this),e,N(t))}})})(DFLIP,jQuery);(function(e){"use strict";e.URL=e.URL||e.webkitURL;if(e.Blob&&e.URL){try{new Blob;return}catch(t){}}var i=e.BlobBuilder||e.WebKitBlobBuilder||e.MozBlobBuilder||function(e){var t=function(e){return Object.prototype.toString.call(e).match(/^\[object\s(.*)\]$/)[1]},i=function b(){this.data=[]},n=function P(e,t,i){this.data=e;this.size=e.length;this.type=t;this.encoding=i},a=i.prototype,o=n.prototype,r=e.FileReaderSync,s=function(e){this.code=this[this.name=e]},l=("NOT_FOUND_ERR SECURITY_ERR ABORT_ERR NOT_READABLE_ERR ENCODING_ERR "+"NO_MODIFICATION_ALLOWED_ERR INVALID_STATE_ERR SYNTAX_ERR").split(" "),d=l.length,c=e.URL||e.webkitURL||e,f=c.createObjectURL,u=c.revokeObjectURL,h=c,p=e.btoa,g=e.atob,v=e.ArrayBuffer,m=e.Uint8Array,w=/^[\w-]+:\/*\[?[\w\.:-]+\]?(?::[0-9]+)?/;n.fake=o.fake=true;while(d--){s.prototype[l[d]]=d+1}if(!c.createObjectURL){h=e.URL=function(e){var t=document.createElementNS("http://www.w3.org/1999/xhtml","a"),i;t.href=e;if(!("origin"in t)){if(t.protocol.toLowerCase()==="data:"){t.origin=null}else{i=e.match(w);t.origin=i&&i[1]}}return t}}h.createObjectURL=function(e){var t=e.type,i;if(t===null){t="application/octet-stream"}if(e instanceof n){i="data:"+t;if(e.encoding==="base64"){return i+";base64,"+e.data}else if(e.encoding==="URI"){return i+","+decodeURIComponent(e.data)}if(p){return i+";base64,"+p(e.data)}else{return i+","+encodeURIComponent(e.data)}}else if(f){return f.call(c,e)}};h.revokeObjectURL=function(e){if(e.substring(0,5)!=="data:"&&u){u.call(c,e)}};a.append=function(e){var i=this.data;if(m&&(e instanceof v||e instanceof m)){var a="",o=new m(e),l=0,d=o.length;for(;l<d;l++){a+=String.fromCharCode(o[l])}i.push(a)}else if(t(e)==="Blob"||t(e)==="File"){if(r){var c=new r;i.push(c.readAsBinaryString(e))}else{throw new s("NOT_READABLE_ERR")}}else if(e instanceof n){if(e.encoding==="base64"&&g){i.push(g(e.data))}else if(e.encoding==="URI"){i.push(decodeURIComponent(e.data))}else if(e.encoding==="raw"){i.push(e.data)}}else{if(typeof e!=="string"){e+=""}i.push(unescape(encodeURIComponent(e)))}};a.getBlob=function(e){if(!arguments.length){e=null}return new n(this.data.join(""),e,"raw")};a.toString=function(){return"[object BlobBuilder]"};o.slice=function(e,t,i){var a=arguments.length;if(a<3){i=null}return new n(this.data.slice(e,a>1?t:this.data.length),i,this.encoding)};o.toString=function(){return"[object Blob]"};o.close=function(){this.size=0;delete this.data};return i}(e);e.Blob=function(e,t){var n=t?t.type||"":"";var a=new i;if(e){for(var o=0,r=e.length;o<r;o++){if(Uint8Array&&e[o]instanceof Uint8Array){a.append(e[o].buffer)}else{a.append(e[o])}}}var s=a.getBlob(n);if(!s.slice&&s.webkitSlice){s.slice=s.webkitSlice}return s};var n=Object.getPrototypeOf||function(e){return e.__proto__};e.Blob.prototype=n(new e.Blob)})(window);(function(e){"use strict";var t=e.Uint8Array,i=e.HTMLCanvasElement,n=i&&i.prototype,a=/\s*;\s*base64\s*(?:;|$)/i,o="toDataURL",r,s=function(e){var i=e.length,n=new t(i/4*3|0),a=0,o=0,s=[0,0],l=0,d=0,c,f;while(i--){f=e.charCodeAt(a++);c=r[f-43];if(c!==255&&c!==void 0){s[1]=s[0];s[0]=f;d=d<<6|c;l++;if(l===4){n[o++]=d>>>16;if(s[1]!==61){n[o++]=d>>>8}if(s[0]!==61){n[o++]=d}l=0}}}return n};if(t){r=new t([62,-1,-1,-1,63,52,53,54,55,56,57,58,59,60,61,-1,-1,-1,0,-1,-1,-1,0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,-1,-1,-1,-1,-1,-1,26,27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49,50,51])}if(i&&!n.toBlob){n.toBlob=function(e,i){if(!i){i="image/png"}if(this.mozGetAsFile){e(this.mozGetAsFile("canvas",i));return}if(this.msToBlob&&/^\s*image\/png\s*(?:$|;)/i.test(i)){e(this.msToBlob());return}var n=Array.prototype.slice.call(arguments,1),r=this[o].apply(this,n),l=r.indexOf(","),d=r.substring(l+1),c=a.test(r.substring(0,l)),f;if(Blob.fake){f=new Blob;if(c){f.encoding="base64"}else{f.encoding="URI"}f.data=d;f.size=d.length}else if(t){if(c){f=new Blob([s(d)],{type:i})}else{f=new Blob([decodeURIComponent(d)],{type:i})}}e(f)};if(n.toDataURLHD){n.toBlobHD=function(){o="toDataURLHD";var e=this.toBlob();o="toDataURL";return e}}else{n.toBlobHD=n.toBlob}}})(window);(function t(){if("performance"in window===false){window.performance={}}Date.now=Date.now||function(){return(new Date).getTime()};if("now"in window.performance===false){var e=window.performance.timing&&window.performance.timing.navigationStart?window.performance.timing.navigationStart:Date.now();window.performance.now=function(){return Date.now()-e}}})();(function i(){var e=e||function(){var e=[];return{getAll:function(){return e},removeAll:function(){e=[]},add:function(t){e.push(t)},remove:function(t){var i=e.indexOf(t);if(i!==-1){e.splice(i,1)}},update:function(t){if(e.length===0){return false}var i=0;t=t!==void 0?t:window.performance.now();while(i<e.length){if(e[i].update(t)){i++}else{e.splice(i,1)}}return true}}}();e.Tween=function(t){var i=t;var n={};var a={};var o={};var r=1e3;var s=0;var l=false;var d=false;var c=false;var f=0;var u=null;var h=e.Easing.Linear.None;var p=e.Interpolation.Linear;var g=[];var v=null;var m=false;var w=null;var b=null;var P=null;for(var x in t){n[x]=parseFloat(t[x],10)}this.to=function(e,t){if(t!==void 0){r=t}a=e;return this};this.start=function(t){e.add(this);d=true;m=false;u=t!==void 0?t:window.performance.now();u+=f;for(var r in a){if(a[r]instanceof Array){if(a[r].length===0){continue}a[r]=[i[r]].concat(a[r])}if(n[r]===void 0){continue}n[r]=i[r];if(n[r]instanceof Array===false){n[r]*=1}o[r]=n[r]||0}return this};this.stop=function(){if(!d){return this}e.remove(this);d=false;if(P!==null){P.call(i)}this.stopChainedTweens();return this};this.stopChainedTweens=function(){for(var e=0,t=g.length;e<t;e++){g[e].stop()}};this.complete=function(){if(!d){return this}e.remove(this);d=false;if(b!==null){b.call(i)}this.completeChainedTweens();return this};this.completeChainedTweens=function(){for(var e=0,t=g.length;e<t;e++){g[e].complete()}};this.delay=function(e){f=e;return this};this.repeat=function(e){s=e;return this};this.yoyo=function(e){l=e;return this};this.easing=function(e){h=e==void 0?h:e;return this};this.interpolation=function(e){p=e;return this};this.chain=function(){g=arguments;return this};this.onStart=function(e){v=e;return this};this.onUpdate=function(e){w=e;return this};this.onComplete=function(e){b=e;return this};this.onStop=function(e){P=e;return this};this.update=function(e){var t;var d;var P;if(e<u){return true}if(m===false){if(v!==null){v.call(i)}m=true}d=(e-u)/r;d=d>1?1:d;P=h(d);for(t in a){if(n[t]===void 0){continue}var x=n[t]||0;var C=a[t];if(C instanceof Array){i[t]=p(C,P)}else{if(typeof C==="string"){if(C.startsWith("+")||C.startsWith("-")){C=x+parseFloat(C,10)}else{C=parseFloat(C,10)}}if(typeof C==="number"){i[t]=x+(C-x)*P}}}if(w!==null){w.call(i,P)}if(d===1){if(s>0){if(isFinite(s)){s--}for(t in o){if(typeof a[t]==="string"){o[t]=o[t]+parseFloat(a[t],10)}if(l){var y=o[t];o[t]=a[t];a[t]=y}n[t]=o[t]}if(l){c=!c}u=e+f;return true}else{if(b!==null){b.call(i)}for(var k=0,E=g.length;k<E;k++){g[k].start(u+r)}return false}}return true}};e.Easing={Linear:{None:function(e){return e}},Quadratic:{In:function(e){return e*e},Out:function(e){return e*(2-e)},InOut:function(e){if((e*=2)<1){return.5*e*e}return-.5*(--e*(e-2)-1)}},Quartic:{In:function(e){return e*e*e*e},Out:function(e){return 1- --e*e*e*e},InOut:function(e){if((e*=2)<1){return.5*e*e*e*e}return-.5*((e-=2)*e*e*e-2)}},Sinusoidal:{In:function(e){return 1-Math.cos(e*Math.PI/2)},Out:function(e){return Math.sin(e*Math.PI/2)},InOut:function(e){return.5*(1-Math.cos(Math.PI*e))}},Cubic:{In:function(e){return e*e*e},Out:function(e){return--e*e*e+1},InOut:function(e){if((e*=2)<1){return.5*e*e*e}return.5*((e-=2)*e*e+2)}}};e.Interpolation={Linear:function(t,i){var n=t.length-1;var a=n*i;var o=Math.floor(a);var r=e.Interpolation.Utils.Linear;if(i<0){return r(t[0],t[1],a)}if(i>1){return r(t[n],t[n-1],n-a)}return r(t[o],t[o+1>n?n:o+1],a-o)},Bezier:function(t,i){var n=0;var a=t.length-1;var o=Math.pow;var r=e.Interpolation.Utils.Bernstein;for(var s=0;s<=a;s++){n+=o(1-i,a-s)*o(i,s)*t[s]*r(a,s)}return n},Utils:{Linear:function(e,t,i){return(t-e)*i+e},Bernstein:function(t,i){var n=e.Interpolation.Utils.Factorial;return n(t)/n(i)/n(t-i)},Factorial:function(){var e=[1];return function(t){var i=1;if(e[t]){return e[t]}for(var n=t;n>1;n--){i*=n}e[t]=i;return i}}(),CatmullRom:function(e,t,i,n,a){var o=(i-e)*.5;var r=(n-t)*.5;var s=a*a;var l=a*s;return(2*t-2*i+o+r)*l+(-3*t+3*i-2*o-r)*s+o*a+t}}};window.TWEEN=e})();DFLIP.createBlob=function n(e,t){if(typeof Blob!=="undefined"){return new Blob([e],{type:t})}var i=new MozBlobBuilder;i.append(e);return i.getBlob(t)};DFLIP.createObjectURL=function a(){var e="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=";return function t(i,n){if(typeof URL!=="undefined"&&URL.createObjectURL){var a=DFLIP.createBlob(i,n);return URL.createObjectURL(a)}var o="data:"+n+";base64,";for(var r=0,s=i.length;r<s;r+=3){var l=i[r]&255;var d=i[r+1]&255;var c=i[r+2]&255;var f=l>>2,u=(l&3)<<4|d>>4;var h=r+1<s?(d&15)<<2|c>>6:64;var p=r+2<s?c&63:64;o+=e[f]+e[u]+e[h]+e[p]}return o}}();var ThumbList=function o(){function e(t){var i=t&&t.w+"px"||"100%";var n=t&&t.h+"px"||"100%";var a=this.itemHeight=t.itemHeight;this.items=t.items;this.generatorFn=t.generatorFn;this.totalRows=t.totalRows||t.items&&t.items.length;this.addFn=t.addFn;this.scrollFn=t.scrollFn;var o=e.createScroller(a*this.totalRows);this.container=e.createContainer(i,n);this.container.appendChild(o);this.screenItemsLen=Math.ceil(t.h/a);this.offsetItems=this.screenItemsLen;this.cachedItemsLen=this.screenItemsLen+this.offsetItems*2;this._renderChunk(this.container,0);var r=this;r.lastRepaintY=0;var s=this.screenItemsLen*a;var l=0;var d;function c(e){var t=e.target.scrollTop;if(!r.lastRepaintY||Math.abs(t-r.lastRepaintY)>=r.offsetItems*r.itemHeight){var i=parseInt(t/a,10)-r.offsetItems;r._renderChunk(r.container,i<0?0:i);r.lastRepaintY=t}r.lastScrolled=l=Date.now();if(r.scrollFn!==void 0){r.scrollFn()}e.preventDefault&&e.preventDefault()}r.dispose=function(){if(r.container){if(r.container.parentNode){r.container.parentNode.removeChild(r.container)}}r.container.removeEventListener("scroll",c)};r.container.addEventListener("scroll",c)}e.prototype.reset=function(e){this.screenItemsLen=Math.ceil(e/this.itemHeight);this.cachedItemsLen=this.screenItemsLen+this.offsetItems*2;var t=parseInt(this.lastRepaintY/this.itemHeight,10)-this.offsetItems;this.needReset=true;this._renderChunk(this.container,Math.max(t,0))};e.prototype.createRow=function(e){var t;if(this.generatorFn){t=this.generatorFn(e);t.classList.add("df-vrow");t.style.position="absolute";t.style.top=e*this.itemHeight+"px";t.setAttribute("index",e)}return t};e.prototype._renderChunk=function(e,t){var i=this.range==void 0;this.range=this.range||{min:0,max:this.cachedItemsLen};var n=this.range;var a=n.min,o=n.max;var r=i?true:t>=a;if(!i&&t==a&&this.needReset==false)return;var s;var l=i?a:r?o:t;l=l>this.totalRows?this.totalRows:l<0?0:l;var d=t+this.cachedItemsLen;d=d>this.totalRows?this.totalRows:d;for(s=l;s<d;s++){if(r)e.appendChild(this.createRow(s));else e.insertBefore(this.createRow(s),e.childNodes[1+s-l]);if(this.addFn!==void 0){this.addFn(s)}}var c=Math.abs(t-a);this.needReset=false;if(!i&&e.childNodes.length>this.cachedItemsLen+1){var f=r?1:1+this.cachedItemsLen,u=f+(d-l);for(var h=u;h>f;h--){if(e.childNodes[f])this.container.removeChild(e.childNodes[f])}}this.range.min=t;this.range.max=d};e.createContainer=function(e,t){var i=document.createElement("div");i.style.width=e;i.style.height=t;i.style.overflow="auto";i.style.position="relative";i.style.padding=0;return i};e.createScroller=function(e){var t=document.createElement("div");t.style.opacity=0;t.style.position="absolute";t.style.top=0;t.style.left=0;t.style.width="1px";t.style.height=e+"px";return t};return e}();var BookMarkViewer=function r(){function e(e){this.outline=null;this.lastToggleIsShow=true;this.container=e.container;this.linkService=e.linkService;this.outlineItemClass=e.outlineItemClass||"outlineItem";this.outlineToggleClass=e.outlineToggleClass||"outlineItemToggler";this.outlineToggleHiddenClass=e.outlineToggleHiddenClass||"outlineItemsHidden"}e.prototype={dispose:function(){if(this.container){if(this.container.parentNode){this.container.parentNode.removeChild(this.container)}}this.linkService=null},reset:function t(){this.outline=null;this.lastToggleIsShow=true;var e=this.container;while(e.firstChild){e.removeChild(e.firstChild)}},_dispatchEvent:function i(e){var t=document.createEvent("CustomEvent");t.initCustomEvent("outlineloaded",true,true,{outlineCount:e});this.container.dispatchEvent(t)},_bindLink:function n(e,t){var i=this.linkService;if(t.custom==true){e.href=i.getCustomDestinationHash(t.dest);e.onclick=function n(e){i.customNavigateTo(t.dest);return false}}else{if(t.url){PDFJS.addLinkAttributes(e,{url:t.url});return}e.href=i.getDestinationHash(t.dest);e.onclick=function a(e){i.navigateTo(t.dest);return false}}},_addToggleButton:function a(e){var t=document.createElement("div");t.className=this.outlineToggleClass+" "+this.outlineToggleHiddenClass;t.onclick=function(i){i.stopPropagation();t.classList.toggle(this.outlineToggleHiddenClass);if(i.shiftKey){var n=!t.classList.contains(this.outlineToggleHiddenClass);this._toggleOutlineItem(e,n)}}.bind(this);e.insertBefore(t,e.firstChild)},_toggleOutlineItem:function o(e,t){this.lastToggleIsShow=t;var i=e.querySelectorAll("."+this.outlineToggleClass);for(var n=0,a=i.length;n<a;++n){i[n].classList[t?"remove":"add"](this.outlineToggleHiddenClass)}},toggleOutlineTree:function r(){if(!this.outline){return}this._toggleOutlineItem(this.container,!this.lastToggleIsShow)},render:function s(e){var t=e&&e.outline||null;var i=0;if(this.outline){this.reset()}this.outline=t;if(!t){return}var n=document.createDocumentFragment();var a=[{parent:n,items:this.outline}];var o=false;while(a.length>0){var r=a.shift();var s=r.custom;for(var l=0,d=r.items.length;l<d;l++){var c=r.items[l];var f=document.createElement("div");f.className=this.outlineItemClass;var u=document.createElement("a");if(c.custom==void 0&&s!==void 0)c.custom=s;this._bindLink(u,c);u.textContent=c.title.replace(/\x00/g,"");f.appendChild(u);if(c.items&&c.items.length>0){o=true;this._addToggleButton(f);var h=document.createElement("div");h.className=this.outlineItemClass+"s";f.appendChild(h);a.push({parent:h,custom:c.custom,items:c.items})}r.parent.appendChild(f);i++}}if(o){if(this.container.classList!=void 0){this.container.classList.add(this.outlineItemClass+"s")}else if(this.container.className!=void 0){this.container.className+=" picWindow"}}this.container.appendChild(n);this._dispatchEvent(i)}};return e}();var DFLightBox=function s(e){function t(t){this.duration=300;var i=this;i.lightboxWrapper=e("<div>").addClass("df-lightbox-wrapper");i.container=e("<div>").addClass("df-container").appendTo(i.lightboxWrapper);i.controls=e("<div>").addClass("df-lightbox-controls").appendTo(i.lightboxWrapper);i.closeButton=e("<div>").addClass("df-lightbox-close df-ui-btn ti-close").on("click",function(){i.close(t)}).appendTo(i.controls);i.lightboxWrapper.append(i.container);return i}t.prototype.show=function(t){if(this.lightboxWrapper.parent().length==0)e("body").append(this.lightboxWrapper);this.lightboxWrapper.fadeIn(this.duration,t);return this};t.prototype.close=function(e){this.lightboxWrapper.fadeOut(this.duration,e);return this};return t}(jQuery);DFLIP.Share=function l(e){function t(t,i){var n=this;var a="<div>";var o="df-share-button";var r="width=500,height=400";n.isOpen=false;n.shareUrl="";n.wrapper=e('<div class="df-share-wrapper" style="display: none;">').on("click",function(e){n.close()});n.box=e('<div class="df-share-box">').on("click",function(e){e.preventDefault();e.stopPropagation()}).appendTo(n.wrapper).html('<span class="df-share-title">'+i.text.share+"</span>");n.urlInput=e('<textarea class="df-share-url">').on("click",function(){e(this).select()});n.facebook=e(a,{"class":o+" df-share-facebook "+i.icons["facebook"]}).on("click",function(e){window.open("https://www.facebook.com/sharer/sharer.php?u="+encodeURIComponent(n.shareUrl),"Sharer",r)});n.google=e(a,{"class":o+" df-share-google "+i.icons["google"]}).on("click",function(e){window.open("https://plus.google.com/share?url="+encodeURIComponent(n.shareUrl),"Sharer",r)});n.twitter=e(a,{"class":o+" df-share-twitter "+i.icons["twitter"]}).on("click",function(e){window.open("http://twitter.com/share?url="+encodeURIComponent(n.shareUrl),"Sharer",r)});n.box.append(n.urlInput).append(n.facebook).append(n.twitter);e(t).append(n.wrapper)}t.prototype.show=function(){this.wrapper.fadeIn(300);this.urlInput.val(this.shareUrl);this.urlInput.trigger("click");this.isOpen=true};t.prototype.dispose=function(){var e=this;e.box.off();e.google.off();e.twitter.off();e.facebook.off();e.urlInput.off();e.wrapper.off().remove()};t.prototype.close=function(){this.wrapper.fadeOut(300);this.isOpen=false};t.prototype.update=function(e){this.shareUrl=e};return t}(jQuery);var PDFLinkService=function(){function e(){this.baseUrl=null;this.pdfDocument=null;this.pdfViewer=null;this.pdfHistory=null;this._pagesRefCache=null}e.prototype={dispose:function(){this.baseUrl=null;this.pdfDocument=null;this.pdfViewer=null;this.pdfHistory=null;this._pagesRefCache=null},setDocument:function t(e,i){this.baseUrl=i;this.pdfDocument=e;this._pagesRefCache=Object.create(null)},setViewer:function i(e){this.pdfViewer=e},setHistory:function n(e){this.pdfHistory=e},get pagesCount(){return this.pdfDocument.numPages},get page(){return this.pdfViewer.currentPageNumber},set page(e){this.pdfViewer.currentPageNumber=e},navigateTo:function a(e){var t="";var i=this;var n=function(a){var o=a instanceof Object?i._pagesRefCache[a.num+" "+a.gen+" R"]:a+1;if(o){if(o>i.pagesCount){o=i.pagesCount}i.pdfViewer.gotoPage(o);if(i.pdfHistory){i.pdfHistory.push({dest:e,hash:t,page:o})}}else{i.pdfDocument.getPageIndex(a).then(function(e){var t=e+1;var o=a.num+" "+a.gen+" R";i._pagesRefCache[o]=t;n(a)})}};var a;if(typeof e==="string"){t=e;a=this.pdfDocument.getDestination(e)}else{a=Promise.resolve(e)}a.then(function(t){e=t;if(!(t instanceof Array)){return}n(t[0])})},customNavigateTo:function o(e){if(e==""||e==void 0||e=="void 0")return;var t=void 0;if(!isNaN(Math.round(e))){t=e}else if(typeof e==="string"){t=parseInt(e.replace("#",""),10);if(isNaN(t)){window.open(e);return}}if(t!==void 0)this.pdfViewer.gotoPage(t)},getDestinationHash:function r(e){if(typeof e==="string"){return this.getAnchorUrl("#"+escape(e))}if(e instanceof Array){var t=e[0];var i=t instanceof Object?this._pagesRefCache[t.num+" "+t.gen+" R"]:t+1;if(i){var n=this.getAnchorUrl("#page="+i);var a=e[1];if(typeof a==="object"&&"name"in a&&a.name==="XYZ"){var o=e[4]||this.pdfViewer.currentScaleValue;var r=parseFloat(o);if(r){o=r*100}n+="&zoom="+o;if(e[2]||e[3]){n+=","+(e[2]||0)+","+(e[3]||0)}}return n}}return this.getAnchorUrl("")},getCustomDestinationHash:function s(e){return"#"+escape(e)},getAnchorUrl:function l(e){return(this.baseUrl||"")+e},setHash:function d(e){if(e.indexOf("=")>=0){var t=parseQueryString(e);if("nameddest"in t){if(this.pdfHistory){this.pdfHistory.updateNextHashParam(t.nameddest)}this.navigateTo(t.nameddest);return}var i,n;if("page"in t){i=t.page|0||1}if("zoom"in t){var a=t.zoom.split(",");var o=a[0];var r=parseFloat(o);if(o.indexOf("Fit")===-1){n=[null,{name:"XYZ"},a.length>1?a[1]|0:null,a.length>2?a[2]|0:null,r?r/100:o]}else{if(o==="Fit"||o==="FitB"){n=[null,{name:o}]}else if(o==="FitH"||o==="FitBH"||(o==="FitV"||o==="FitBV")){n=[null,{name:o},a.length>1?a[1]|0:null]}else if(o==="FitR"){if(a.length!==5){console.error("PDFLinkService_setHash: "+"Not enough parameters for 'FitR'.")}else{n=[null,{name:o},a[1]|0,a[2]|0,a[3]|0,a[4]|0]}}else{console.error("PDFLinkService_setHash: '"+o+"' is not a valid zoom value.")}}}if(n){this.pdfViewer.scrollPageIntoView(i||this.page,n)}else if(i){this.page=i}if("pagemode"in t){var s=document.createEvent("CustomEvent");s.initCustomEvent("pagemode",true,true,{mode:t.pagemode});this.pdfViewer.container.dispatchEvent(s)}}else if(/^\d+$/.test(e)){this.page=e}else{if(this.pdfHistory){this.pdfHistory.updateNextHashParam(unescape(e))}this.navigateTo(unescape(e))}},executeNamedAction:function c(e){switch(e){case"GoBack":if(this.pdfHistory){this.pdfHistory.back()}break;case"GoForward":if(this.pdfHistory){this.pdfHistory.forward()}break;case"NextPage":this.page++;break;case"PrevPage":this.page--;break;case"LastPage":this.page=this.pagesCount;break;case"FirstPage":this.page=1;break;default:break}var t=document.createEvent("CustomEvent");t.initCustomEvent("namedaction",true,true,{action:e});this.pdfViewer.container.dispatchEvent(t)},cachePageRef:function f(e,t){var i=t.num+" "+t.gen+" R";this._pagesRefCache[i]=e}};return e}();DFLIP.TextLayerBuilder=function d(){function e(e){this.textLayerDiv=e.textLayerDiv;this.renderingDone=false;this.divContentDone=false;this.pageIdx=e.pageIndex;this.pageNumber=this.pageIdx+1;this.matches=[];this.viewport=e.viewport;this.textDivs=[];this.findController=e.findController||null;this.textLayerRenderTask=null;this.enhanceTextSelection=e.enhanceTextSelection;this._bindMouse()}e.prototype={_finishRendering:function t(){this.renderingDone=true;if(!this.enhanceTextSelection){var e=document.createElement("div");e.className="endOfContent";this.textLayerDiv.appendChild(e)}},render:function i(e){if(!this.divContentDone||this.renderingDone){return}if(this.textLayerRenderTask){this.textLayerRenderTask.cancel();this.textLayerRenderTask=null}this.textDivs=[];var t=document.createDocumentFragment();this.textLayerRenderTask=PDFJS.renderTextLayer({textContent:this.textContent,container:t,viewport:this.viewport,textDivs:this.textDivs,timeout:e,enhanceTextSelection:this.enhanceTextSelection});this.textLayerRenderTask.promise.then(function(){this.textLayerDiv.appendChild(t);this._finishRendering();this.updateMatches()}.bind(this),function(e){})},setTextContent:function n(e){if(this.textLayerRenderTask){this.textLayerRenderTask.cancel();this.textLayerRenderTask=null}this.textContent=e;this.divContentDone=true},convertMatches:function a(e,t){var i=0;var n=0;var a=this.textContent.items;var o=a.length-1;var r=this.findController===null?0:this.findController.state.query.length;var s=[];if(!e){return s}for(var l=0,d=e.length;l<d;l++){var c=e[l];while(i!==o&&c>=n+a[i].str.length){n+=a[i].str.length;i++}if(i===a.length){console.error("Could not find a matching mapping")}var f={begin:{divIdx:i,offset:c-n}};if(t){c+=t[l]}else{c+=r}while(i!==o&&c>n+a[i].str.length){n+=a[i].str.length;i++}f.end={divIdx:i,offset:c-n};s.push(f)}return s},renderMatches:function o(e){if(e.length===0){return}var t=this.textContent.items;var i=this.textDivs;var n=null;var a=this.pageIdx;var o=this.findController===null?false:a===this.findController.selected.pageIdx;var r=this.findController===null?-1:this.findController.selected.matchIdx;var s=this.findController===null?false:this.findController.state.highlightAll;var l={divIdx:-1,offset:undefined};function d(e,t){var n=e.divIdx;i[n].textContent="";c(n,0,e.offset,t)}function c(e,n,a,o){var r=i[e];var s=t[e].str.substring(n,a);var l=document.createTextNode(s);if(o){var d=document.createElement("span");d.className=o;d.appendChild(l);r.appendChild(d);return}r.appendChild(l)}var f=r,u=f+1;if(s){f=0;u=e.length}else if(!o){return}for(var h=f;h<u;h++){var p=e[h];var g=p.begin;var v=p.end;var m=o&&h===r;var w=m?" selected":"";if(this.findController){this.findController.updateMatchPosition(a,h,i,g.divIdx)}if(!n||g.divIdx!==n.divIdx){if(n!==null){c(n.divIdx,n.offset,l.offset)}d(g)}else{c(n.divIdx,n.offset,g.offset)}if(g.divIdx===v.divIdx){c(g.divIdx,g.offset,v.offset,"highlight"+w)}else{c(g.divIdx,g.offset,l.offset,"highlight begin"+w);for(var b=g.divIdx+1,P=v.divIdx;b<P;b++){i[b].className="highlight middle"+w}d(v,"highlight end"+w)}n=v}if(n){c(n.divIdx,n.offset,l.offset)}},updateMatches:function r(){if(!this.renderingDone){return}var e=this.matches;var t=this.textDivs;var i=this.textContent.items;var n=-1;for(var a=0,o=e.length;a<o;a++){var r=e[a];var s=Math.max(n,r.begin.divIdx);for(var l=s,d=r.end.divIdx;l<=d;l++){var c=t[l];c.textContent=i[l].str;c.className=""}n=r.end.divIdx+1}if(this.findController===null||!this.findController.active){return}var f,u;if(this.findController!==null){f=this.findController.pageMatches[this.pageIdx]||null;u=this.findController.pageMatchesLength?this.findController.pageMatchesLength[this.pageIdx]||null:null}this.matches=this.convertMatches(f,u);this.renderMatches(this.matches)},_bindMouse:function s(){var e=this.textLayerDiv;var t=this;e.addEventListener("mousedown",function(i){if(t.enhanceTextSelection&&t.textLayerRenderTask){t.textLayerRenderTask.expandTextDivs(true);return}var n=e.querySelector(".endOfContent");if(!n){return}var a=i.target!==e;a=a&&window.getComputedStyle(n).getPropertyValue("-moz-user-select")!=="none";if(a){var o=e.getBoundingClientRect();var r=Math.max(0,(i.pageY-o.top)/o.height);n.style.top=(r*100).toFixed(2)+"%"}n.classList.add("active")});e.addEventListener("mouseup",function(i){if(t.enhanceTextSelection&&t.textLayerRenderTask){t.textLayerRenderTask.expandTextDivs(false);return}var n=e.querySelector(".endOfContent");if(!n){return}n.style.top="";n.classList.remove("active")})}};return e}();DFLIP.ConvertPageLinks=function(){var e=arguments[0]/100,t=arguments[1]/100;var i=function(i,n,a,o,r){return{x:i/e,y:n/t,w:a/e,h:o/t,dest:r}};var n=[];var a;for(var o=2;o<arguments.length;o++){a=arguments[o];n[o-2]=i.apply(this,a)}return n};DFLIP.parseLinks=function(e){var t;if(e!==void 0&&e.length>0){for(var i=0;i<e.length;i++){t=e[i];if(t!==void 0&&t[0]!==void 0&&t[0].dest==void 0){t=DFLIP.ConvertPageLinks.apply(this,t);e[i]=t}}}return e};(function(e){function t(e){return e=="true"}function i(e){if(e.webgl!==void 0)e.webgl=t(e.webgl);if(e.enableDownload!==void 0)e.enableDownload=t(e.enableDownload);if(e.scrollWheel!==void 0)e.scrollWheel=t(e.scrollWheel);if(e.autoEnableOutline!==void 0)e.autoEnableOutline=t(e.autoEnableOutline);if(e.transparent!==void 0)e.transparent=t(e.transparent);if(e.overwritePDFOutline!==void 0)e.overwritePDFOutline=t(e.overwritePDFOutline);if(e.soundEnable!==void 0)e.soundEnable=t(e.soundEnable);if(e.minTopOffset!==void 0)e.minTopOffset=parseInt(e.minTopOffset,10);if(e.pageMode==0||e.pageMode=="0")e.pageMode=void 0}function n(e){if(e.parsed==true)return;e.parsed=true;var t=[];i(e);if(typeof dFlipWPGlobal!=="undefined"&&e.wpOptions=="true"){try{for(var n in e.links){var a=e.links[n];var o=[100,100];for(var r=0;r<a.length;r++){var s=a[r];var l=s.replace("[","").replace("]","").split(",");
var d=[];for(var c=0;c<5;c++){d[c]=l[c]}o.push(d)}t[parseInt(n,10)+1]=o}}catch(f){console.error(f.stack)}e.links=DFLIP.parseLinks(t)}else{e.links=DFLIP.parseLinks(e.links)}}DFLIP.getOptions=function(t){t=e(t);var i=t.attr("id");var a="option_"+i,o=t.attr("source")||t.attr("df-source");a=a==void 0||a==""||window[a]==void 0?{}:window[a];a.source=o==void 0||o==""?a.source:o;var r={webgl:t.attr("webgl"),height:t.attr("height"),soundEnable:t.attr("sound"),transparent:t.attr("transparent"),enableDownload:t.attr("download"),duration:t.attr("duration"),hard:t.attr("hard"),pageMode:t.attr("pagemode"),direction:t.attr("direction"),backgroundColor:t.attr("backgroundcolor"),scrollWheel:t.attr("scrollwheel"),backgroundImage:t.attr("backgroundimage"),minTopOffset:t.attr("mintopoffset"),wpOptions:t.attr("wpoptions")};a=e.extend(true,{},a,r);n(a);return a};DFLIP.parseBooks=function(){e("._df_button, ._df_thumb, ._df_custom, ._df_book").each(function(){var t=e(this);var i=t.attr("parsed")||t.attr("df-parsed");if(i!=="true"){t.attr("df-parsed","true");if(t.hasClass("_df_book")){var n=t.attr("id");var a=DFLIP.getOptions(t);a.id=n;window[n.toString()]=e(t).flipBook(a.source,a)}else{t.on("click",function(){var t=e(this);if(!window.dfLightBox){window.dfLightBox=new DFLightBox(function(){window.location.hash="";window.dfActiveLightBoxBook.dispose();window.dfActiveLightBoxBook=null})}window.dfLightBox.duration=500;if(window.dfActiveLightBoxBook&&window.dfActiveLightBoxBook.dispose){window.dfActiveLightBoxBook.dispose()}else{window.dfLightBox.show(function(){var i=DFLIP.getOptions(t);i.transparent=false;i.id=t.attr("id");i.isLightBox=true;window.dfActiveLightBoxBook=e(window.dfLightBox.container).flipBook(i.source,i)})}});if(t.hasClass("_df_thumb")){var o=e("<div class='_df_book-cover'>");var r=t.html();t.html("");var s=e("<span class='_df_book-title'>").html(r).appendTo(o);var l=t.attr("thumb")||t.attr("df-thumb"),d=t.attr("tags")||t.attr("df-tags");if(d){d=d.split(",");if(d.length>0){for(var c=0;c<d.length;c++){t.append("<span class='_df_book-tag'>"+d[c]+"</span>")}}}if(l!==void 0&&l.toString().trim()!=""){o.css({backgroundImage:"url("+l+")"})}else{o.addClass("_df_thumb-not-found")}t.append(o)}}}})};e(document).ready(function(){if(typeof dFlipLocation!=="undefined"){if(dFlipLocation.length>2&&dFlipLocation.slice(-1)!=="/"){dFlipLocation+="/"}DFLIP.defaults.mockupjsSrc=dFlipLocation+"js/libs/mockup.min.js";DFLIP.defaults.pdfjsSrc=dFlipLocation+"js/libs/pdf.min.js";DFLIP.defaults.pdfjsCompatibilitySrc=dFlipLocation+"js/libs/compatibility.js";DFLIP.defaults.threejsSrc=dFlipLocation+"js/libs/three.min.js";DFLIP.defaults.pdfjsWorkerSrc=dFlipLocation+"js/libs/pdf.worker.min.js";DFLIP.defaults.soundFile=dFlipLocation+"sound/turn2.mp3";if(typeof dFlipWPGlobal!=="undefined"){i(dFlipWPGlobal);e.extend(DFLIP.defaults,dFlipWPGlobal)}}DFLIP.preParseHash=window.location.hash;DFLIP.parseBooks();if(DFLIP.preParseHash&&DFLIP.preParseHash.indexOf("dflip-")>=0){var t=DFLIP.preParseHash.split("dflip-")[1].split("/")[0];var n=DFLIP.preParseHash.split("dflip-")[1].split("/")[1];if(n!=void 0){n=n.split("/")[0]}var a=e("#"+t);if(a.length>0){var o=window.location.hash;window.location.hash=t;window.location.hash=DFLIP.preParseHash;if(n!=void 0){a.data("page",n)}if(a.is("._df_button, ._df_thumb, ._df_custom")){a.trigger("click")}}}})})(jQuery);