<?php
/**
 * @author QuanticaLabs - http://codecanyon.net/user/QuanticaLabs/portfolio?ref=QuanticaLabs
 *
 * @link			http://codecanyon.net/item/timetable-responsive-schedule-for-joomla/9749539?ref=QuanticaLabs
 * @copyright		Copyright (C) 2008 - 2014 quanticalabs.com . All rights reserved.
 * @license			GNU General Public License version 2 or later; see LICENSE under Licensing/ directory
 */
 
defined('_JEXEC') or die('Restricted access');

class plgContentTimetable_Content extends JPlugin {
	
	public function onContentPrepare($context, &$article, &$params, $limitstart=0) {
		$this->prepareDocument();		
		require_once(JPATH_ROOT . "/components/com_timetable/config.php");
		require_once(COM_TIMETABLE_CLASSES_PATH . "timetable_shortcode.php");
		$article->text = Timetable_Shortcode::process_shortcodes($article->text);		
	}

	private function prepareDocument() {
		require_once(JPATH_ROOT . "/components/com_timetable/config.php");
		global $timetable_head_flag;

		if($timetable_head_flag == NULL) {
			$document = JFactory::getDocument();
			$document->addStyleSheet(COM_TIMETABLE_STYLES_URL . "superfish.css");
			$document->addStyleSheet(COM_TIMETABLE_STYLES_URL . "style.css");
			$document->addStyleSheet(COM_TIMETABLE_STYLES_URL . "event_template.css");
			$document->addStyleSheet(COM_TIMETABLE_STYLES_URL . "responsive.css");
			$document->addStyleSheet("//fonts.googleapis.com/css?family=Lato:400,700");

			JHtml::_('jquery.framework');
			$document->addScript(JURI::base() . "/media/jui/js/jquery-migrate.min.js");
			$document->addScript(JURI::base() . "/media/jui/js/jquery.ui.core.min.js");			
			$document->addScript(COM_TIMETABLE_SCRIPTS_URL . "jquery.ba-bbq.min.js");
			$document->addScript(COM_TIMETABLE_SCRIPTS_URL . "jquery.carouFredSel-6.2.1-packed.js");
			$document->addScript(COM_TIMETABLE_SCRIPTS_URL . "jquery.ui.tabs.js");
			$document->addScript(COM_TIMETABLE_SCRIPTS_URL . "timetable.js");
			
			$lang = JFactory::getLanguage();
			$extension = 'com_timetable';
			$base_dir = JPATH_SITE;
			$language_tag = 'en-GB';
			$reload = true;
			$lang->load($extension, $base_dir, $language_tag, $reload);

			$timetable_head_flag = 1 ;
		}
	}	
}
?>