<?php
/**
 * @author QuanticaLabs - http://codecanyon.net/user/QuanticaLabs/portfolio?ref=QuanticaLabs
 *
 * @link			http://codecanyon.net/item/timetable-responsive-schedule-for-joomla/9749539?ref=QuanticaLabs
 * @copyright		Copyright (C) 2008 - 2014 quanticalabs.com . All rights reserved.
 * @license			GNU General Public License version 2 or later; see LICENSE under Licensing/ directory
 */
 
defined('_JEXEC') or die('Restricted access');

$db = JFactory::getDbo();
$config = JFactory::getConfig();
$current_date = JFactory::getDate("now", $config->get('offset'));

if($time_mode=="server")
{
	$phpDayNumber = $current_date->format("w", ($timezone!="utc" ? true : false));	
	if($phpDayNumber==0)
		$phpDayNumber = 7;
}

//get all weekdays order numbers
if($display_settings=="all")
{
	$query = "SELECT ordering FROM #__timetable_columns
			WHERE
			ordering=" . ($time_mode=="server" ? $phpDayNumber : "CASE WHEN DATE_FORMAT(CURDATE(), '%w') = 0 THEN 7 ELSE DATE_FORMAT(CURDATE(), '%w') END");

	$db->setQuery($query);
	$current_day_number = $db->loadObject();
		
	$query = "SELECT ordering FROM #__timetable_columns
			ORDER BY ordering";
	$db->setQuery($query);
	$weekdays_orders = $db->loadObjectList();
	
	$count_weekdays_orders = count($weekdays_orders);
	$weekdays_orders_sql = "";
	$weekdays_orders_array = array();
	for($i=0; $i<$count_weekdays_orders; $i++)	
		$weekdays_orders_array[] = $weekdays_orders[$i]->ordering;
	$weekdays_orders_array = array_values(array_unique($weekdays_orders_array));
	$current_day_number_index = array_search($current_day_number->ordering, $weekdays_orders_array);
	$weekdays_before_current = array_slice($weekdays_orders_array, 0, $current_day_number_index);
	$weekdays_after_current = array_slice($weekdays_orders_array, $current_day_number_index+1, $count_weekdays_orders-$current_day_number_index);
	$weekdays_orders_array_sorted = array_merge($weekdays_after_current, $weekdays_before_current);
	if((int)$within_next>0)
		$weekdays_orders_array_sorted = array_slice($weekdays_orders_array_sorted, 0, (int)$within_next);
	$count_weekdays_orders_sorted = count($weekdays_orders_array_sorted);
	for($i=0; $i<$count_weekdays_orders_sorted; $i++)
		$weekdays_orders_sql .= "'" . $weekdays_orders_array_sorted[$i] . "'" . ($i+1<$count_weekdays_orders_sorted ? "," : "");
}
$category_join = join("','", (array)$categories);
$query = "SELECT TIME_FORMAT(t1.start, '%H.%i') AS start, TIME_FORMAT(t1.end, '%H.%i') AS end, t1.event_id AS event_id, t1.before_hour_text AS description1, t1.after_hour_text AS description2, t2.title, t2.alias, t3.title as weekday FROM #__timetable_event_hours AS t1 
	LEFT JOIN #__timetable_events AS t2 ON t1.event_id=t2.ID 
	LEFT JOIN #__timetable_columns AS t3 ON t1.weekday_id=t3.ID";
if(!empty($category_join))
	$query .= "
		LEFT JOIN #__timetable_event_categories ec ON(t2.id = ec.event_id)
		LEFT JOIN #__timetable_categories c ON(ec.category_id = c.id)
		WHERE c.alias IN ('" . $category_join . "') ";
else
	$query .= "
		WHERE 1=1 ";

if($display_settings=="today")
	$query .= "
	AND t3.ordering=" . ($time_mode=="server" ? $phpDayNumber : "CASE WHEN DATE_FORMAT(CURDATE(), '%w') = 0 THEN 7 ELSE DATE_FORMAT(CURDATE(), '%w') END") . " 
	AND 
	SUBTIME(t1.start, " . ($time_mode=="server" ? "TIME('" . $current_date->format("H:i:s", ($timezone!="utc" ? true : false)) . "')" : "CURRENT_TIME()") . ")>0";
else if($display_settings=="current")
	$query .= "	AND 
	t3.ordering=" . ($time_mode=="server" ? $phpDayNumber : "CASE WHEN DATE_FORMAT(CURDATE(), '%w') = 0 THEN 7 ELSE DATE_FORMAT(CURDATE(), '%w') END") . " 
	AND 
	SUBTIME(t1.end, " . ($time_mode=="server" ? "TIME('" . $current_date->format("H:i:s", ($timezone!="utc" ? true : false)) . "')" : "CURRENT_TIME()") . ")>0
	AND
	SUBTIME(t1.end, " . ($time_mode=="server" ? "TIME('" . $current_date->format("H:i:s", ($timezone!="utc" ? true : false)) . "')" : "CURRENT_TIME()") . ")<SUBTIME(t1.end, t1.start)";
else
	$query .= "	AND(
	(t3.ordering=" . ($time_mode=="server" ? $phpDayNumber : "CASE WHEN DATE_FORMAT(CURDATE(), '%w') = 0 THEN 7 ELSE DATE_FORMAT(CURDATE(), '%w') END") . " 
	AND 
	SUBTIME(t1.start, " . ($time_mode=="server" ? "TIME('" . $current_date->format("H:i:s", ($timezone!="utc" ? true : false)) . "')" : "CURRENT_TIME()") . ")>0)
	OR t3.ordering IN(" . $weekdays_orders_sql . "))";
$query .= " GROUP BY t1.id";
if($display_settings=="today" || $display_settings=="current")
	$query .= " ORDER BY t1.start, t1.end";
else
	$query .= " ORDER BY FIELD(t3.ordering," . ($time_mode=="server" ? $phpDayNumber : "CASE WHEN DATE_FORMAT(CURDATE(), '%w') = 0 THEN 7 ELSE DATE_FORMAT(CURDATE(), '%w') END") . "," . $weekdays_orders_sql . "), t1.start, t1.end";
if((int)$count>0)
	$query .= " LIMIT " . $count;

$db->setQuery($query);
$event_hours = $db->loadObjectList();
$event_hours_count = count($event_hours);

$output = '';
$output .= '<div class="tt_upcoming_events_widget widget clearfix">';
		if($title) 
		{
			$output .= "<h5 class='box_header'" . (!empty($title_color) ? " style='color: #{$title_color}'; " : "") ." >{$title}</h5>";
		}
$output .= '<div class="tt_upcoming_events_wrapper page_margin_top">';
if($event_hours_count):
		$output .= '<ul class="tt_upcoming_events clearfix autoscroll-' . (int)$auto_scroll . '">';
		for($i=0; $i<$event_hours_count; $i++)
		{
			if($time_format!='custom')
				$time_format_custom = $time_format;
			
			$event_hours[$i]->start = date($time_format_custom, strtotime($event_hours[$i]->start));
			$event_hours[$i]->end = date($time_format_custom, strtotime($event_hours[$i]->end));
			//get event color
			$reset_bg_color = false;
			$reset_border_color = false;
		
			if($hover_background_color=="" || $item_border_color=="")
			{
				$event_color = Timetable_Shortcode::db_get_event_option($event_hours[$i]->event_id, "color");

				if($hover_background_color=="")
				{
					$hover_background_color = $event_color;
					$reset_bg_color = true;
				}
				if($item_border_color=="")
				{
					$item_border_color = $event_color;
					$hover_item_border_color = $event_color;
					$reset_border_color = true;
				}
			}

			$event_custom_url = "";
			$event_custom_url = Timetable_Shortcode::db_get_event_option($event_hours[$i]->event_id, "custom_url");
			if($event_custom_url!="")
				$custom_url = $event_custom_url;
			$output .= '<li><' . ((int)$disable_url ? 'span' : 'a') . ' class="tt_upcoming_events_event_container"' . ($background_color!="" || $item_border_color!="" || $text_color!="" ? ' style="' . ($background_color!="" ? 'background-color: #' . $background_color . ';' : '') . ($item_border_color!="" ? 'border-left-color: #' . $item_border_color . ';' : '') . ($text_color!="" ? 'color: #' . $text_color . ';' : '') . '"' : '') . ($background_color!="" || $hover_background_color!="" || $item_border_color!="" || $hover_item_border_color!="" || $text_color!="" || $hover_text_color!="" ? ' onMouseOver="' . ($background_color!="" || $hover_background_color!="" ? 'this.style.backgroundColor=\'#'.($hover_background_color!="" ? $hover_background_color : '00A27C').'\';' : '') . ($item_border_color!="" || $hover_item_border_color!="" ? 'this.style.borderColor=\'#'.($hover_item_border_color!="" ? $hover_item_border_color : '00A27C').'\';' : '' ) . ($text_color!="" || $hover_text_color!="" ? 'this.style.color=\'#'.($hover_text_color!="" ? $hover_text_color : 'FFFFFF') . '\';' : '' ) . '" onMouseOut="' . ($background_color!="" || $hover_background_color!="" || $item_border_color!="" || $hover_item_border_color!="" || $text_color!="" || $hover_text_color!="" ? ($background_color!="" || $hover_background_color!="" ? 'this.style.backgroundColor=\'#'.($background_color!="" ? $background_color : 'FFF').'\';' : '') . ($item_border_color!="" || $hover_item_border_color!="" ? 'this.style.borderColor=\'#EFEFEF\';this.style.borderLeftColor=\'#'.($item_border_color!="" ? $item_border_color : 'EFEFEF').'\';' : '' ) . ($text_color!="" || $hover_text_color!="" ? 'this.style.color=\'#'.($text_color!="" ? $text_color : '34495E').'\';' : '') : '' ). '"' : '') . (!(int)$disable_url ? ' href="' . ($custom_url!="" ? htmlentities($custom_url) : Timetable_Shortcode::get_event_url($event_hours[$i]->alias)) . '"' : '') . ' title="' . $event_hours[$i]->title . '">' . ($event_hours[$i]->description1!="" || $event_hours[$i]->description2!="" ? '<span class="tt_upcoming_events_arrow"></span>' : '') . $event_hours[$i]->title . '<span class="tt_upcoming_events_hours timetable_clearfix"><span class="tt_calendar_icon"></span>' . $event_hours[$i]->weekday . ', ' . $event_hours[$i]->start . ' - ' .  $event_hours[$i]->end . '</span>' . ($event_hours[$i]->description1!="" || $event_hours[$i]->description2!="" ? '<span class="tt_event_hours_description">' . $event_hours[$i]->description1 . ($event_hours[$i]->description1!="" && $event_hours[$i]->description2!="" ? '<br>' : '') . $event_hours[$i]->description2 . '</span>' : '') . '</' . ((int)$disable_url ? 'span' : 'a') . '></li>';
			if($reset_bg_color)
				$hover_background_color = "";
			if($reset_border_color)
			{
				$item_border_color = "";
				$hover_item_border_color = "";
			}
		}
$output .= '</ul><div class="tt_upcoming_event_controls">
	<a href="#" id="upcoming_event_prev"><span class="tt_upcoming_event_prev_arrow"></span></a>
	<a href="#" id="upcoming_event_next"><span class="tt_upcoming_event_next_arrow"></span></a>
</div>';
else:
	$output .= '<p class="message">' . JText::_("MOD_TIMETABLE_NO_UPCOMING_EVENTS") . '</p>';
endif;
$output .= '</div>
</div>';
echo $output;