<?php
/**
 * @author QuanticaLabs - http://codecanyon.net/user/QuanticaLabs/portfolio?ref=QuanticaLabs
 *
 * @link			http://codecanyon.net/item/timetable-responsive-schedule-for-joomla/9749539?ref=QuanticaLabs
 * @copyright		Copyright (C) 2008 - 2014 quanticalabs.com . All rights reserved.
 * @license			GNU General Public License version 2 or later; see LICENSE under Licensing/ directory
 */
 
defined('_JEXEC') or die('Restricted access');

jimport('joomla.form.formfield');

class JFormFieldTimezone extends JFormField {

    protected $type = 'Timezone';
	
    public function getInput() {
		$config = JFactory::getConfig();
		$current_date = JFactory::getDate("now", $config->get('offset'));
		$current_localtime = $current_date->format("H:i:s", true);
		$current_utc = $current_date->format("H:i:s", false);
		
		$output = "<select id='{$this->id}' class='{$this->class}' name='{$this->name}'>
			<option value='localtime' " . ($this->value=="localtime" ? "selected='selected'" : "") . ">" . JText::_("MOD_TIMETABLE_TIMEZONE_LOCALTIME") . " (now: " . $current_localtime . ")</option>
			<option value='utc' " . ($this->value=="utc" ? "selected='selected'" : "") . ">" . JText::_("MOD_TIMETABLE_TIMEZONE_UTC") . " (now: " . $current_utc . ")</option>
		</select>";
		$output .= "<script>
			if(jQuery('.upcoming-events-time_mode').val()!=='server')
				jQuery('.upcoming-events-timezone').closest('.control-group').css('display', 'none');
			jQuery('.upcoming-events-time_mode').change(function() {
				if(jQuery('.upcoming-events-time_mode').val()==='server')
					jQuery('.upcoming-events-timezone').closest('.control-group').css('display', 'block');
				else
					jQuery('.upcoming-events-timezone').closest('.control-group').css('display', 'none');
			});
		</script>";
		return $output;
    }
}



