<?php 

/**
* @version		1.5.1
* @package		JCountDown Module
* @file		    mod_jcountdown.php
* JCountDown counts the number of days remaining until any annual occasion on the calendar (ie: birthday, Christmas etc).
* @copyright	Copyright (C) 2010 - fxwebdesign.nl
* @license		GNU/GPL, see LICENSE.php
*/

defined('_JEXEC') or die('Restricted access');
JHTML::_('behavior.tooltip');
$doc = JFactory::getDocument();?>

<div class="<?php echo $params->get('moduleclass_sfx'); ?>">
<script>
CountDownDate = "<?php echo $jcountdownDate?> <?php echo $jcountdownTime?>";
CountActive = true;
CountStepper = -1;
LeadingZero = true;
DisplayFormat = "<?php echo $jcountdownContent?></div><div class='tm-cntdwn-details'><h3 class='tm-cntdwn-title'><a href='<?php echo $jcountdownEventlink?>'><?php echo $jcountdownEventtitle?></a></h3><p><?php echo $jcountdownEventdesc?></p></div>";
NoDisplayFormat = "<?php echo $jcountdownContent?></div><div class='tm-cntdwn-details'><h3 class='tm-cntdwn-title'><a href='<?php echo $jcountdownEventlink?>'><?php echo $jcountdownEventtitle?></a></h3><p><?php echo $jcountdownEventdesc?></p></div>";
FinishMessage = "<?php echo $jcountdownFinished?>";

function calcage(secs, num1, num2) {
  s = ((Math.floor(secs/num1))%num2).toString();
  if (LeadingZero && s.length < 2)
    s = "0" + s;
  return "<b>" + s + "</b>";
}

function CountBack(secs) {
  if (secs < 0) {
    document.getElementById("cntdwn").innerHTML = FinishMessage;
    return;
  }
  <?php if ($jcountdownModuletitle) {
  echo 'DisplayStr = DisplayFormat.replace(/%%D%%/g, calcage(secs,86400,100000));
  DisplayStr = DisplayStr.replace(/%%H%%/g, calcage(secs,3600,24));
  DisplayStr = DisplayStr.replace(/%%M%%/g, calcage(secs,60,60));
  DisplayStr = DisplayStr.replace(/%%S%%/g, calcage(secs,1,60));
  DisplayStr = DisplayStr.replace(/%%CDDATE%%/g, CountDownDate);';
  }
  else {
  echo 'DisplayStr = NoDisplayFormat.replace(/%%D%%/g, calcage(secs,86400,100000));
  DisplayStr = DisplayStr.replace(/%%H%%/g, calcage(secs,3600,24));
  DisplayStr = DisplayStr.replace(/%%M%%/g, calcage(secs,60,60));
  DisplayStr = DisplayStr.replace(/%%S%%/g, calcage(secs,1,60));
  DisplayStr = DisplayStr.replace(/%%CDDATE%%/g, CountDownDate);';
  } 
  ?>
  document.getElementById("cntdwn").innerHTML = '<div class="tm-counter uk-float-right">'+DisplayStr+'</div>';
  if (CountActive)
    setTimeout("CountBack(" + (secs+CountStepper) + ")", SetTimeOutPeriod);
}

function putspan() {
document.write("<div><div id='cntdwn'></div>");
}

if (typeof(CountDownDate)=="undefined")
  CountDownDate = "12/25/2015 0:00 AM";
if (typeof(DisplayFormat)=="undefined")
  DisplayFormat = "%%D%% Days, %%H%% Hours, %%M%% Minutes, %%S%% Seconds.";
if (typeof(CountActive)=="undefined")
  CountActive = true;
if (typeof(FinishMessage)=="undefined")
  FinishMessage = "";
if (typeof(CountStepper)!="number")
  CountStepper = -1;
if (typeof(LeadingZero)=="undefined")
  LeadingZero = true;


CountStepper = Math.ceil(CountStepper);
if (CountStepper == 0)
  CountActive = false;
var SetTimeOutPeriod = (Math.abs(CountStepper)-1)*1000 + 990;
putspan();
var dthen = new Date(CountDownDate);
var dnow = new Date();
if(CountStepper>0)
  ddiff = new Date(dnow-dthen);
else
  ddiff = new Date(dthen-dnow);
gsecs = Math.floor(ddiff.valueOf()/1000);
CountBack(gsecs);
</script>
<?php if ($toolTip) {
echo '</div>';
} ?>

<?php if ($jcountdownFooter) {
echo '<br>'.JText::_('DATE').' <i>'.$jcountdownDate.'</i><br>
'.JText::_('TIME').' <i>'.$jcountdownTime.'</i><br>
'.JText::_('EVENT').' <i>'.$jcountdownEventtitle.'</i><br>';
} ?>
</div>