<?php
/**
 * @package J2Store
 * @copyright Copyright (c)2014-17 Ramesh Elamathi / J2Store.org
 * @license GNU GPL v3 or later
 */
// No direct access to this file
defined('_JEXEC') or die;
//do we have shipping methods
$shipping_methods = $session->get('shipping_methods', array(), 'j2store');
$shipping_method = $session->get('shipping_method','', 'j2store');
$shipping_values = $session->get('shipping_values', array(), 'j2store');

?>

<?php if(isset($shipping_methods) && count($shipping_methods)): ?>
<form action="index.php" name="j2store-cart-shipping-form"
	id="j2store-cart-shipping-form" enctype="multipart/form-data">
	<div id="j2store-cart-shipping" class="j2store-cart-shipping">
		<h3>
			<?php echo JText::_('J2STORE_CHECKOUT_SELECT_A_SHIPPING_METHOD');?>
		</h3>
		<?php foreach($shipping_methods as $method):

		?>
		<?php
		$checked = '';
		if(isset($shipping_values['shipping_name']) && $shipping_values['shipping_name'] ==  $method['name']) {
			$checked = 'checked';
		}
		?>
		<input type="radio" id="shipping_<?php echo $method['element']; ?>"
			rel="<?php echo addslashes($method['name'])?>" name="shipping_method"
			<?php echo $checked; ?>
			onClick="j2storeUpdateShippingMod('<?php echo addslashes($method['name']); ?>','<?php echo $method['price']; ?>',<?php echo $method['tax']; ?>,<?php echo $method['extra']; ?>, '<?php echo $method['code']; ?>', true );" />
			<label for="shipping_<?php echo $method['element']; ?>"
			onClick="j2storeUpdateShippingMod('<?php echo addslashes($method['name']); ?>','<?php echo $method['price']; ?>',<?php echo $method['tax']; ?>,<?php echo $method['extra']; ?>, '<?php echo $method['code']; ?>', true );">
			<?php echo stripslashes(JText::_($method['name'])); ?> ( <?php echo $currency->format( $method['total']); ?>
			)
		</label>

		<?php endforeach; ?>

	</div>
	<?php endif;?>
	<?php $setval = false;?>
	<input type="hidden" name="shipping_price" id="shipping_price"
		value="<?php echo $setval ? $shipping_methods['0']['price'] : "";?>" />
	<input type="hidden" name="shipping_tax" id="shipping_tax"
		value="<?php echo $setval ? $shipping_methods['0']['tax'] : "";?>" />
	<input type="hidden" name="shipping_name" id="shipping_name"
		value="<?php echo $setval ? $shipping_methods['0']['name'] : "";?>" />
	<input type="hidden" name="shipping_code" id="shipping_code"
		value="<?php echo $setval ? $shipping_methods['0']['code'] : "";?>" />
	<input type="hidden" name="shipping_extra" id="shipping_extra"
		value="<?php echo $setval ? $shipping_methods['0']['extra'] : "";?>" />
</form>
<script type="text/javascript">

	function j2storeUpdateShippingMod(name, price, tax, extra, code, combined) {
		(function($) {
			var form = $('#j2store-cart-shipping-form');
			form.find("input[type='hidden'][name='shipping_name']").val(name);
			form.find("input[type='hidden'][name='shipping_code']").val(code);
			form.find("input[type='hidden'][name='shipping_price']").val(price);
			form.find("input[type='hidden'][name='shipping_tax']").val(tax);
			form.find("input[type='hidden'][name='shipping_extra']").val(extra);
			//override the task
			form.find("input[type='hidden'][name='task']").val('shippingUpdate');

			$.ajax({
				url: 'index.php?option=com_j2store&view=carts&task=shippingUpdate',
				type: 'get',
				data: $('#j2store-cart-shipping-form input[type=\'hidden\'], #j2store-cart-shipping-form input[type=\'radio\']:checked'),
				dataType: 'json',
				cache: false,
				beforeSend: function() {
					$('#j2store-cart-shipping').after('<span class="wait">&nbsp;<img src="<?php echo JUri::root(true); ?>/media/j2store/images/loader.gif" alt="" /></span>');
				},
				complete: function() {
					$('.wait').remove();
				},
				success: function(json) {
					if (json['redirect']) {
						//reload the page
						location.reload();
					}
				},
				error: function(xhr, ajaxOptions, thrownError) {
					//alert(thrownError + "\r\n" + xhr.statusText + "\r\n" + xhr.responseText);
				}
			});
		})(j2store.jQuery);
	}

	</script>
