<?php
/**
 * @package J2Store
 * @copyright Copyright (c)2014-17 Ramesh Elamathi / J2Store.org
 * @license GNU GPL v3 or later
 */
// No direct access to this file
defined('_JEXEC') or die;
?>
<style type="text/css">
.cart-thumb-image img {
	width:80px;
}
</style>
<?php if($items):?>
<div class="alert alert-block" id="detailCart-alertblock-<?php echo $module->id;?>" style="display:none;" ></div>
<table id="detailCart-table<?php echo $module->id;?>" class="j2store-cart-table table table-bordered table-striped">
	<?php if($params->get('show_table_header', 1)) : ?>
	<thead>
		<tr>
			<th><?php echo JText::_('J2STORE_CART_LINE_ITEM'); ?></th>
			<?php if(isset($taxes) && count($taxes) && $main_params->get('show_item_tax', 0)): ?>
			<th><?php echo JText::_('J2STORE_CART_LINE_ITEM_TAX'); ?>
			<?php endif; ?>
			<?php if($params->get('show_product_price', 1)):?>
			<th><?php echo JText::_('J2STORE_CART_LINE_ITEM_TOTAL'); ?></th>
			<?php endif;?>
			<?php if($params->get('show_remove_cart', 1)):?>
			<th></th>
			<?php endif;?>
		</tr>
	</thead>
	<?php endif;?>
	<tbody>

		<?php foreach ($items as $key => $item): ?>
		<?php
			$registry = new JRegistry;
			$registry->loadString($item->orderitem_params);
			$item->params = $registry;
			$thumb_image = $item->params->get('thumb_image', '');
		?>
		<tr id="detailcart-item-<?php echo $item->cartitem_id;?>" >
			<td>
				<?php if($main_params->get('show_thumb_cart', 1) && !empty($thumb_image)): ?>
					<span class="cart-thumb-image">
					<img
						alt="<?php echo $item->orderitem_name; ?>"
						src="<?php echo $thumb_image; ?>" />
					</span>
					<?php endif; ?>
					<span class="cart-product-name">
						<?php if($params->get('show_product_name', 1)):?>
							<?php echo $item->orderitem_name; ?>
						<?php endif;?>
						<?php if($params->get('show_product_qty', 1)):?>
							x <?php echo $item->orderitem_quantity; ?>
						<?php endif;?>
					</span>
					<br />
					<?php if( $params->get('show_product_options', 1) && isset($item->orderitemattributes) && $item->orderitemattributes): ?>
					<span class="cart-item-options"> <?php foreach ($item->orderitemattributes as $attribute): ?>
						<small> - <?php echo JText::_($attribute->orderitemattribute_name); ?>
							: <?php echo $attribute->orderitemattribute_value; ?>
						</small> <br /> <?php endforeach;?>
					</span>
					<?php endif; ?>


				<?php if($main_params->get('show_price_field', 1)): ?>
				<span class="cart-product-unit-price">
					<span class="cart-item-title">
						<?php echo JText::_('J2STORE_CART_LINE_ITEM_UNIT_PRICE'); ?>
					</span>
				<span class="cart-item-value">
					<?php  echo $currency->format($order->get_formatted_lineitem_price($item, $main_params->get('checkout_price_display_options', 1))); ?>
				</span>
			</span> <?php endif; ?>
			<?php if( $params->get('show_product_sku', 1)): ?>
				<br />
				<span class="cart-product-sku">
					<span class="cart-item-title">
						<?php echo JText::_('J2STORE_CART_LINE_ITEM_SKU'); ?>
					</span>
					<span class="cart-item-value">
						<?php echo $item->orderitem_sku; ?>
					</span>
				</span>
			 <?php endif; ?>
			</td>

			<?php if(isset($taxes) && count($taxes) && $params->get('show_item_tax', 0)): ?>
			<td>
				<?php  echo $currency->format($item->orderitem_tax);?>
			</td>
			<?php endif; ?>
			<?php if($params->get('show_product_price', 1)):?>
			<td class="cart-line-subtotal">
				<?php echo $currency->format($order->get_formatted_lineitem_total($item, $params->get('checkout_price_display_options', 1))); ?>
			</td>
			<?php endif; ?>
			<td>
			<?php if($params->get('show_remove_cart', 1)):?>
						<a href="javascript:void(0);"   data-cartitem_id="<?php echo $item->cartitem_id;?>"
							class="j2store-remove remove-icon"
							data-alert_block="#detailCart-alertblock-<?php echo $module->id;?>"
							onclick="j2storeDetailCartRemove(this);" >
							<i class="fa fa-remove j2store-remove remove-icon"></i>
						</a>
				<?php endif; ?>
			</td>
		</tr>
		<?php endforeach; ?>
		<tfooter>
			<?php require( JModuleHelper::getLayoutPath('mod_j2store_detailcart','v3_total'));?>
		</tfooter>
	</tbody>
</table>
<div id="warning-container-<?php echo $module->id?>" class="mod-j2storedetailcart-status">
	<!-- Make sure the show checkout is enable &&  check country id is set in session  &&  check zone_id is set in session  &&  check postcode is set in session  -->
	<?php if( $show_checkout != 1 && $shipping_country_id != '' && $shipping_zone_id !='' && $shipping_postcode !='' &&  empty($shipping_methods)):?>
		<p class="j2store-mdc-error text text-warning">
			<?php echo JText::_('MOD_J2STORE_NO_SHIPPING_METHOD_MATCHES');?>
		</p>
	<?php endif;?>
</div>
<?php else: ?>
<?php echo JText::_('J2STORE_NO_ITEMS_FOUND');?>
<?php endif;?>
<script type="text/javascript">

function j2storeDetailCartRemove(element) {
	(function($) {
		$('.j2store-mdc-error').remove();
		 request = {
				'option' : 'com_ajax',
				'module' : 'j2store_detailcart',
				'method' : 'removeCartItem',
				'format' : 'json',
				'cartitem_id' : $(element).data('cartitem_id')
				};
				$.ajax({
					type: 'GET',
					dataType: "json",
					data : request,
					success: function(json){
						if(json['status']){
							location.reload();
						}else{
							if(json['msg']){
								$($(element).data('alert_block')).html('<p class="j2store-mdc-error">'+ json['msg'] +'</p>');
							}
						}
				  	}
				});
	})(j2store.jQuery);
}

function getDetailCartUpdate(product_id,input){
	 (function($){
		 var new_qty;
		 var old_qty =$("#detailCartQty"+product_id).attr('value');
		 var data = $(input).serialize();
		$.ajax({
			type:'GET',
			/*contentType: "application/json; charset=utf-8",*/
			dataType: "json",
			url	   :'index.php?option=com_j2store&view=carts&task=update',
			data   :data,
			complete: function(response){
				doMiniCart();
			}
		});
  	})(j2store.jQuery);
 }
</script>


