<?php
/*------------------------------------------------------------------------
 # com_j2store - J2Store
# ------------------------------------------------------------------------
# author    Ramesh Elamathi - Weblogicx India http://www.weblogicxindia.com
# copyright Copyright (C) 2014 - 19 Weblogicxindia.com. All Rights Reserved.
# @license - http://www.gnu.org/licenses/gpl-2.0.html GNU/GPL
# Websites: http://j2store.org
# Technical Support:  Forum - http://j2store.org/forum/index.html
-------------------------------------------------------------------------*/

// no direct access
defined( '_JEXEC' ) or die( 'Restricted access' );
$show_country_list = $params->get('show_shipping_country',1);
$show_zone_list = $params->get('show_shipping_zone',1);
$show_postcode = $params->get('show_shipping_postcode',1);
?>
<div id="j2store-cart-modules">
	<?php  if($main_params->get('show_tax_calculator', 1)): ?>
	<label>
		<input type="radio" name="next" value="shipping" id="shipping_estimate" />
			<?php echo JText::_('J2STORE_CART_TAX_SHIPPING_CALCULATOR_HEADING'); ?>
	</label>
	<div id="shipping" class="content" style="display: none;">
		<form action="<?php echo JRoute::_('index.php');?>"
		    method="post"
		    data-show_country="<?php $show_country_list; ?>"
		    data-show_zone="<?php $show_country_list; ?>"
		    data-show_zone="<?php $show_postcode; ?>"
			id="shipping-estimate-form">
			<table>
				<?php // if($show_country_list):?>
				<tr>
					<td><span class="required">*</span>
					 <?php echo JText::_('J2STORE_SELECT_A_COUNTRY'); ?>
					</td>
					<td><?php
					$countryList = J2Html::select()->clearState()
					->type('genericlist')
					->name('country_id')
					->idTag('shippingInput')
					->value($country_id)
					->setPlaceHolders(array(''=>JText::_('J2STORE_SELECT_OPTION')))
					->hasOne('Countries')
					->setRelations(
							array (
									'fields' => array (
											'key'=>'j2store_country_id',
											'name'=>'country_name'
									)
							)
					)->getHtml();
					echo $countryList;
					?>
					</td>
				</tr>
					<?php //  endif; ?>
					<?php // if($show_zone_list):?>
				<tr>
					<td>
						<span class="required">*</span>
						<?php echo JText::_('J2STORE_STATE_PROVINCE'); ?>
					</td>
					<td><select name="zone_id"></select></td>
				</tr>
				<?php // endif; ?>
				<?php // if($show_postcode):?>
				<tr>
					<td><?php echo JText::_('J2STORE_POSTCODE'); ?></td>
					<td>
						<input type="text" name="postcode"	value="<?php  echo $postcode; ?>" /></td>
				</tr>
				<?php //  endif; ?>
			</table>
				<input type="button" value="<?php echo JText::_('J2STORE_CART_CALCULATE_TAX_SHIPPING'); ?>"
					 id="button-quote-<?php echo $module->id?>" class="btn btn-primary" />
				<input type="hidden" name="option" value="com_j2store" />
				<input type="hidden" name="view" value="carts" />
				<input type="hidden" name="task"	value="estimate" />
				<input type="hidden" name="show_message"	value="1" />
		</form>
	</div>
	<?php  endif; ?>
</div>

<script type="text/javascript"><!--
j2store.jQuery('input[name=\'next\']').bind('click', function() {
	j2store.jQuery('#j2store-cart-modules > div').hide();
	j2store.jQuery('#' + this.value).slideToggle('slow');
});
//--></script>

<?php
if(!isset($zone_id)) {
	$zone_id = '';
} else {
	$zone_id = $zone_id;
}

?>
<script type="text/javascript"><!--
 (function($) {
	 $(document).on('click', '#button-quote-<?php echo $module->id?>', function() {
		 $('.j2store-mdc-error').remove();
		 var values = $('#shipping-estimate-form').serializeArray();
		 $.ajax({
				url:'index.php?option=com_j2store&view=carts&task=estimate',
				type: 'POST',
				data: values,
				dataType: 'json',
				beforeSend: function() {
					$('#button-quote').after('<span class="wait">&nbsp;<img src="media/j2store/images/loader.gif" alt="" /></span>');
				},
				complete: function() {
					$('.wait').remove();
				},
				success: function(json) {
					var html ='';
					if(json['error']){
						if( json['error']  && json['error']['postcode'] !=''){
							html+='<p class="j2store-mdc-error text text-warning">'+json['error']['postcode']+'</p>';
						}
						if(json['error']['country_id']){
							html+='<p class="j2store-mdc-error text text-warning">'+json['error']['country_id']+'</p>';
						}

						if(json['error']['zone_id']){
							html+='<p class="j2store-mdc-error text text-warning">'+json['error']['zone_id']+'</p>';
						}

							$('.mod-j2storedetailcart-status').html(html);

					}
					if(json['redirect']){
						location.reload();

						/*
						  var estimate = 1;
						request = {
								'option' : 'com_ajax',
								'module' : 'j2store_detailcart',
								'method' : 'getEstimatedshipping',
								'format' : 'json',
								}
						$.ajax({
							type : 'POST',
							data : request,
							dataType:'json',
							success: function (json) {
							if(json['error']){
								var html = '<p class="j2store-mdc-error text text-warning">'+json['error']['msg']+'</p>';
							//	$('#warning-container-').append(html);
								$("#estimateShip").show();
								return false;
								}else if(json['success']){
									 $.ajax({
						   				url:"index.php?option=com_j2store&view=carts&task=update"
						   			 });
									//custom event
									$(document).trigger('onJ2StoreCartAfteractioncomplete',true);
									$("#estimateShip").show();
								}
							  }
							});
                            */

					}
				}
		 });

	 });

 })(j2store.jQuery);

(function($) {
$('select[name=\'country_id\']').bind('change', function() {
	$.ajax({
		url:'index.php?option=com_j2store&view=carts&task=getCountry&country_id=' + this.value,
		type: 'get',
		dataType: 'json',
		beforeSend: function() {
			$('select[name=\'country_id\']').after('<span class="wait">&nbsp;<img src="<?php echo JUri::root(true); ?>/media/j2store/images/loader.gif" alt="" /></span>');
		},
		complete: function() {
			$('.wait').remove();
		},
		success: function(json) {

			html = '<option value=""><?php echo JText::_('J2STORE_SELECT_OPTION'); ?></option>';
			if (json['zone'] != '') {
				for (i = 0; i < json['zone'].length; i++) {
        			html += '<option value="' + json['zone'][i]['j2store_zone_id'] + '"';

					if (json['zone'][i]['j2store_zone_id'] == '<?php echo $zone_id; ?>') {
	      				html += ' selected="selected"';
	    			}

	    			html += '>' + json['zone'][i]['zone_name'] + '</option>';
				}
			} else {
				html += '<option value="0" selected="selected"><?php echo JText::_('J2STORE_CHECKOUT_ZONE_NONE'); ?></option>';
			}

			$('select[name=\'zone_id\']').html(html);
		},
		error: function(xhr, ajaxOptions, thrownError) {
		}
	});
});

$('select[name=\'country_id\']').trigger('change');

})(j2store.jQuery);
//--></script>
