<?php
/*------------------------------------------------------------------------
 # mod_j2store_detailcart - J2Store Detail Cart
 # ------------------------------------------------------------------------
 # author ThemeParrot http://www.themeparrot.com
 # copyright Copyright (C) 2012 ThemeParrot.com. All Rights Reserved.
 # @license - http://www.gnu.org/licenses/gpl-2.0.html GNU/GPL
-------------------------------------------------------------------------*/
// no direct access
defined('_JEXEC') or die('Restricted access');
$app = JFactory::getApplication();
$model = F0FModel::getTmpInstance('Carts','J2StoreModel');
$checkout_url = $model->getCheckoutUrl();
$cart_link = $model->getCartUrl();
$j2params = JComponentHelper::getParams('com_j2store');
$ajax = $app->getUserState('mod_j2store_detailcart.isAjax');
$continue_shopping_url = $model->getContinueShoppingUrl();
$shipping_values = $session->get('shipping_values', array(), 'j2store');
if($params->get('show_checkout', 1) == 1) {
	//always show checkout
	$show_checkout = true;
} elseif($params->get('show_checkout', 1) == 2) {
	//show only if a shipping method is chosen
	/* if(isset($shipping_method) && count($shipping_method)) { */
	if(isset($shipping_values) && count($shipping_values)) {
		$show_checkout = true;
	} else {
		$show_checkout = false;
	}
}


?>
<?php if(!$ajax): ?>
<div
    id ="dcart-block-<?php echo $module->id;?>"
	class="mod_j2store_detailcart_<?php echo $module->id;?> detailJ2StoreCartBlock<?php if($params->get('moduleclass_sfx')) echo ' '.$params->get('moduleclass_sfx'); ?>">
	<div id="detailJ2StoreCart">
		<?php endif; ?>

		<div class="mod_j2store_cart_shipping_cart">
			<?php require( JModuleHelper::getLayoutPath('mod_j2store_detailcart','v3_cart'));?>
		</div>
		<?php if($params->get('show_estimator',1) &&  count($items)) :?>

		<div class="mod_j2store_cart_shipping_calculator">
			<?php require( JModuleHelper::getLayoutPath('mod_j2store_detailcart','v3_calculator'));?>
		</div>

		<div class="mod_j2store_cart_shipping">
			<?php require( JModuleHelper::getLayoutPath('mod_j2store_detailcart','v3_shipping'));?>
		</div>
		<div  class="buttons-right">
				<span class="cart-checkout-button">
					<a <?php if(!$show_checkout) echo 'disabled'; ?>  id="dcart-checkout-link-<?php echo $module->id;?>" class="btn btn-success" href="<?php echo $checkout_url; ?>" >
					<?php echo JText::_('J2STORE_PROCEED_TO_CHECKOUT'); ?> </a>
				</span>
		</div>
		<?php endif;?>

		<?php if(!$ajax):?>
	</div>
</div>
<script type="text/javascript">

(function ($) {
	$(document).on('click', '#dcart-checkout-link-<?php echo $module->id;?>', function () {
	$('.j2store-mdc-error').remove();
	 var values = $('#shipping-estimate-form').serializeArray();

	var request = {
	'option' : 'com_ajax',
	'module' : 'j2store_detailcart',
	'method' : 'getValidShippingMethod',
	'format' : 'json',
	'data'	: values,
	};
	$.ajax({
	type : 'POST',
	data : request,
	dataType:'json',
	success: function (json) {
	if(json['error']){
			$('.mod-j2storedetailcart-status').html('<p class="j2store-mdc-error text text-warning">'+json['error']['msg']+'</p>');
			}else if(json['link']){
			 window.location = json['link'];
			}
	  }
	});
	return false;
	});

})(j2store.jQuery);
</script>
<?php else: ?>
	<?php $app->setUserState('mod_j2store_detailcart.isAjax', 0); ?>
<?php endif; ?>