<?php
/*------------------------------------------------------------------------
 # mod_j2store_cart - J2Store Cart
# ------------------------------------------------------------------------
# author    Ramesh Elamathi - ThemeParrot http://www.themeparrot.com
# copyright Copyright (C) 2012 ThemeParrot.com. All Rights Reserved.
# @license - http://www.gnu.org/licenses/gpl-2.0.html GNU/GPL
-------------------------------------------------------------------------*/

// no direct access
defined( '_JEXEC' ) or die( 'Restricted access' );
require_once JPATH_ADMINISTRATOR .'/components/com_j2store/helpers/j2store.php';
jimport( 'joomla.application.module.helper' );

class modJ2StoreDetailCartHelper {

	public  static  $_order;
	public  static  $_taxes;
	public  static $_shipping;
	public  static $_coupons;
	public  static $_vouchers;


	public static function getItems(){
		$app = JFactory::getApplication();
		$cart_order ;
		$cart_items;

		$items  =F0FModel::getTmpInstance('Carts','J2StoreModel')->getItems();
		//trigger plugin events
		$i=0;
		$onDisplayCartItem = array();
		foreach( $items as $item)
		{
			ob_start();
			$app->triggerEvent('onJ2StoreDisplayCartItem', array( $i, $item ) );
			$cartItemContents = ob_get_contents();
			ob_end_clean();
			if (!empty($cartItemContents))
			{
				$onDisplayCartItem[$i] = $cartItemContents;
			}
			$i++;
		}

		$event_onDisplayCartItem =  $onDisplayCartItem;

		$order = F0FModel::getTmpInstance('Orders', 'J2StoreModel')->populateOrder($items)->getOrder();
		$order->validate_order_stock();
		self::$_order = $order;

		$cart_items = $order->getItems();

		foreach($cart_items as $item) {
			if(isset($item->orderitemattributes) && count($item->orderitemattributes)) {
				foreach($item->orderitemattributes as &$attribute) {
					if($attribute->orderitemattribute_type == 'file') {
						unset($table);
						$table = F0FTable::getInstance('Upload', 'J2StoreTable');
						if($table->load(array('mangled_name'=>$attribute->orderitemattribute_value))) {
							$attribute->orderitemattribute_value = $table->original_name;
						}
					}
				}
			}
		}

		self::$_taxes = $order->getOrderTaxrates();
		self::$_shipping = $order->getOrderShippingRate();
		self::$_coupons = $order->getOrderCoupons();
		self::$_vouchers = $order->getOrderVouchers();


		return $cart_items;
	}
	private static function getTotals() {

	}


	public static function getCountryName($country_id){
		$session = JFactory::getSession();
		$db = JFactory::getDbo();
		$query=$db->getQuery(true);
		$query->select("country_name")->from("#__j2store_countries");
		$query->where("j2store_country_id=".$db->q($country_id));
		$db->setQuery($query);
		return $db->loadResult();
	}

	public static function getZoneName($country_id,$zone_id){
		$db = JFactory::getDbo();
		$query=$db->getQuery(true);
		$query->select("zone_name")->from("#__j2store_zones");
		$query->where("country_id=".$db->q($country_id));
		$query->where("j2store_zone_id=".$db->q($zone_id));
		$db->setQuery($query);
		return $db->loadResult();
	}

	/**
	 * Method to Check
	 */
	public static function getValidShippingMethodAjax(){
		$json = self::validateShipping();
		echo json_encode($json);
		JFactory::getApplication()->close();
	}
	public  static function validateShipping(){

		$session = JFactory::getSession();
		//initliase cart model
		$cart_model = F0FModel::getTmpInstance('Carts' ,'J2StoreModel');
		//decremental
		$order_ships = false;
		$products = $cart_model->getItems();

		foreach($products as $product){

			//check if shipping is enabled for this item
			if(!empty($product->shipping) ) {
				$order_ships = true;
			}
		}
		//get the list of  shipping methods
		$shipping_methods =$session->get('shipping_methods',array(),'j2store');
		$shpping_method = $session->get('shipping_method',array(),'j2store');
		$shipping_values =$session->get('shipping_values',array(),'j2store');
		$json =array();
		//check product has shipping and shipping method is choosen
		if(isset($order_ships) && $order_ships && isset($shipping_methods) && count($shipping_methods) && isset($shipping_values) && isset($shipping_values['shipping_name']) && $shipping_values['shipping_name']){
			//redirect to cart with the warning msg to select shipping method
			$json['link']=$cart_model->getCheckoutUrl();
		}elseif(count($shipping_methods) < 0){
			$json['error']['msg'] = JText::_('MOD_J2STORE_NO_SHIPPING_METHOD_FOUND');
		}else{
			$json['error']['msg'] = JText::_('MOD_J2STORE_NO_SHIPPING_METHOD_MATCHES');
		}
		return $json;
	}

	public static function getUpdatedDetailcartAjax(){

		J2Store::utilities()->nocache();
		//initialise system objects
		$app = JFactory::getApplication();
		$document	= JFactory::getDocument();

		$db = JFactory::getDbo();
		$language = JFactory::getLanguage()->getTag();
		$query = $db->getQuery(true);
		$query->select('*')->from('#__modules')->where('module='.$db->q('mod_j2store_detailcart'))->where('published=1')
		->where('language='.$db->q($language));
		$db->setQuery($query);
		$modules = $db->loadObjectList();
		if(count($modules) < 1) {
			$query = $db->getQuery(true);
			$query->select('*')->from('#__modules')->where('module='.$db->q('mod_j2store_detailcart'))->where('published=1')
			->where('language="*" OR language="en-GB"');
			$db->setQuery($query);
			$modules = $db->loadObjectList();
		}


		$json = array();
		if (count($modules) < 1)
		{
			$json['response'] = ' ';
		} else {
			foreach($modules as $module) {
				$app->setUserState( 'mod_j2store_detailcart.isAjax', '1' );
				$json['response'][$module->id] = JModuleHelper::renderModule($module);
			}
			echo json_encode($json);
			$app->close();
		}
		$app->close();

	}

	/**
	 * ajax Method to remove the cartitem
	 * @input int cartitem_id
	 * @return response
	 */
	public static function removeCartItemAjax() {
		J2Store::utilities()->clear_cache();
		J2Store::utilities()->nocache();
		$app = JFactory::getApplication();
		$json = array();
		$json['status'] = false;
		self::deleteCartItem($json);
		echo json_encode($json);
		$app->close();
	}



	public static  function deleteCartItem(&$json){
		$model = F0FModel::getTmpInstance('Carts' ,'J2StoreModel');
		$app = JFactory::getApplication();
		$cartitem_id = $app->input->get ( 'cartitem_id' );
		$cartitem = F0FTable::getInstance ( 'Cartitem', 'J2StoreTable' );
		// the user wants to remove the item from cart. so remove it
		if ($cartitem->load ( $cartitem_id )) {
			if($cartitem->cart_id != $model->getCartId()) {
				$json['msg'] = JText::_ ( 'J2STORE_CART_DELETE_ERROR' ) ;
				$json['status'] = false;
			}
			$item = new JObject ();
			$item->product_id = $cartitem->product_id;
			$item->variant_id = $cartitem->variant_id;
			$item->product_options = $cartitem->product_options;

			if ($cartitem->delete ( $cartitem_id )) {
				J2Store::plugin()->event( 'RemoveFromCart', array (	$item) );
				$json['status'] = true;
			} else {
				$json['msg'] = JText::_ ( 'J2STORE_CART_DELETE_ERROR' ) ;
				$json['status'] = true;
			}
		} else {
			$json['msg'] = JText::_ ( 'J2STORE_CART_DELETE_ERROR' ) ;
			$json['status'] = true;
		}

		return $json;
	}


	/**
	 * Method to get shipping Methods after estimate button pressed using ajax call
	 *
	 */
	public static function getEstimatedshippingAjax(){
		$session = JFactory::getSession();
		$app = JFactory::getApplication();
		$json =array();
		//get the list of  shipping methods
		$shipping_methods =$session->get('shipping_methods',array(),'j2store');
		//print_r($product); exit;
		if(!count($shipping_methods)){
			$json['error']['msg'] = JText::_('MOD_J2STORE_NO_SHIPPING_METHOD_MATCHES');
		}else{
			$json['success'] = true;
		}
		echo json_encode($json);
		$app->close();
	}



}