<?php 
/**
 * @package    Contact Form
 * @author     Arrowthemes https://arrowthemes.com
 * @copyright  Copyright (C) 2016 Arrowthemes. All rights reserved.
 * @license    http://www.gnu.org/licenses/gpl.html GNU/GPL
 */

defined ('_JEXEC') or die; 

	class modContactFormHelper
	{
		static function sendMail( $params )
		{
			// get sitename, value
			$app = JFactory::getApplication();
			$sitename = $app->getCfg('sitename');
			$input = $app -> input;

			// field 1
			if($params->get("field1_show") == 1) {
				$field1_label = $params->get("field1_text").":";
				$field1 = $input->getString("field1", null);
			} else {
				$field1_label = null;
				$field1 = null;
			}

			// field 2
			if($params->get("field2_show") == 1) {
				$field2_label = $params->get("field2_text").":";
				$field2 = $input->getString("field2", null);
			} else {
				$field2_label = null;
				$field2 = null;
			}

			// field 3
			if($params->get("field3_show") == 1) {
				$field3_label = $params->get("field3_text").":";
				$field3 = $input->getString("field3", null);
			} else {
				$field3_label = null;
				$field3 = null;
			}

			// field 4
			if($params->get("field4_show") == 1) {
				$field4_label = $params->get("field4_text").":";
				$field4 = $input->getString("field4", null);
			} else {
				$field4_label = null;
				$field4 = null;
			}

			// field 5
			if($params->get("field5_show") == 1) {
				$field5_label = $params->get("field5_text").":";
				$field5 = $input->getString("field5", null);
			} else {
				$field5_label = null;
				$field5 = null;
			}

			// message

			if($params->get("message_show") == 1) {
				$message_label = $params->get("message_text").":";
				$message = $input->getString("message", null);
			} else {
				$message_label = null;
				$message = null;
			}

			$subject = $params->get("subject_text");
			$secure = $input->getString("secure", null);
			$validation = array();
			
			// If captcha is activated, check captcha
			if($params->get("captcha") == 1) {
			  $captcha = $input->post->get("recaptcha_response_field");
			  JPluginHelper::importPlugin( 'captcha' );
			  $dispatcher = JEventDispatcher::getInstance();
			  $captcha_response = $dispatcher->trigger('onCheckAnswer',$captcha);
			}
			
			// Honeypot must be empty
			if ( $secure == null ) {
			
				//Error Captcha	
				if ( isset( $captcha_response[0] ) && ! $captcha_response[0] && $params->get("captcha") == 1 ) {
					$validation = array("check" => false,
										"info" => $params->get("captcha_error"));		
					return $validation;
					
				} else {
				  //get mail and name from global configuration
				  $config = JFactory::getConfig();
				  $sender_global_mail = $config->get( 'config.mailfrom');
				  $sender_global_name = $config->get( 'config.fromname');

				  //if module configuration sender mail or name is empty get global configuration sender mail, name
				  $senderemail = ($params->get("senderemail")) ? $params->get("senderemail") : $sender_global_mail;
				  $sendername = ($params->get("sendername")) ? $params->get("sendername") :  $sender_global_name;
				  $sender = array($senderemail,  $sendername);
				  // get recipient mail 
				  $recipientemail = $params->get("recipientemail");				
				 
				  // build 

				  //merge message 		  
				  $messages_alt = JText::sprintf("MOD_CONTACT_MESSAGE_ALT", $sitename, $field1_label, $field1, $field2_label, $field2, $field3_label, $field3, $field4_label, $field4, $field5_label, $field5, $message_label, $message);
				  				  
				  //Set sender, recipient, subject and message		
				  $mailer = JFactory::getMailer();
				  $mailer -> setSender($sender);
				  $mailer -> addRecipient($recipientemail);				  			  
				  $mailer -> setSubject($subject);
				  $mailer -> isHTML(false);
				  $mailer -> setBody($messages_alt);
				  $send = $mailer->Send();	
				  if ( $send !== true ) {
					$validation = array("check" => false,
										"info" => $params->get("errortext"));
					return $validation;	
					
				  } else {
					  $validation = array("check" => true,
										  "info" => $params->get("successtext"));		
					  return $validation;
				  }
				}
				
			} else {
				$validation = array("check" => false,
									"info" => $params->get("honeypottext"));		
				return $validation;
			}
		}
	}
?>