<?php
/**
 * @author QuanticaLabs - http://codecanyon.net/user/QuanticaLabs/portfolio?ref=QuanticaLabs
 *
 * @link			http://codecanyon.net/item/timetable-responsive-schedule-for-joomla/9749539?ref=QuanticaLabs
 * @copyright		Copyright (C) 2008 - 2014 quanticalabs.com . All rights reserved.
 * @license			GNU General Public License version 2 or later; see LICENSE under Licensing/ directory
 */
 
defined('_JEXEC') or die('Restricted access');
 
class TimetableViewEvent extends JViewLegacy
{
	protected $modules;
	
	public function display($tpl = null) 
	{
		$this->event = $this->get("Event");
			
		// Check for errors.
		if (count($errors = $this->get('Errors'))) 
		{
			JLog::add(implode('<br />', $errors), JLog::WARNING, 'jerror');
			return false;
		}
		$this->prepare_document();
		parent::display($tpl);
	}
	
	private function prepare_document() {
		$document = JFactory::getDocument();
		
		$document->setTitle(JText::_("COM_TIMETABLE_EVENT_PAGE_TITLE") . $this->event->title);
		$document->setDescription(JText::_("COM_TIMETABLE_EVENT_PAGE_DESCRIPTION"));
		
		$document->addStyleSheet(COM_TIMETABLE_STYLES_URL . "superfish.css");
		$document->addStyleSheet(COM_TIMETABLE_STYLES_URL . "style.css");
		$document->addStyleSheet(COM_TIMETABLE_STYLES_URL . "event_template.css");
		$document->addStyleSheet(COM_TIMETABLE_STYLES_URL . "responsive.css");
		$document->addStyleSheet("//fonts.googleapis.com/css?family=Lato:400,700");

		JHtml::_('jquery.framework');
		$document->addScript(JURI::base() . "/media/jui/js/jquery-migrate.min.js");
		$document->addScript("//ajax.googleapis.com/ajax/libs/jqueryui/1.10.4/jquery-ui.min.js");
		$document->addScript(COM_TIMETABLE_SCRIPTS_URL . "jquery.ba-bbq.min.js");
		$document->addScript(COM_TIMETABLE_SCRIPTS_URL . "jquery.carouFredSel-6.2.1-packed.js");
		$document->addScript(COM_TIMETABLE_SCRIPTS_URL . "jquery.ui.tabs.js");
		$document->addScript(COM_TIMETABLE_SCRIPTS_URL . "timetable.js");
	}
}