<?php
/**
 * @author QuanticaLabs - http://codecanyon.net/user/QuanticaLabs/portfolio?ref=QuanticaLabs
 *
 * @link			http://codecanyon.net/item/timetable-responsive-schedule-for-joomla/9749539?ref=QuanticaLabs
 * @copyright		Copyright (C) 2008 - 2014 quanticalabs.com . All rights reserved.
 * @license			GNU General Public License version 2 or later; see LICENSE under Licensing/ directory
 */
 
defined('_JEXEC') or die('Restricted access');

function TimetableBuildRoute(&$query)
{
	$segments = array();
	if(isset($query['view']))
	{
		$segments[] = $query['view'];
		unset($query['view']);
	};
	
	if(isset($query['alias']))
	{
		$segments[] = $query['alias'];
		unset($query['alias']);
	};
	return $segments;
}

function TimetableParseRoute($segments)
{
	$vars = array();
	$vars['view']	= $segments[0];
	$vars['alias']	= str_replace(":", "-" , $segments[1]); 
		
	// get event id based on alias
	$db = JFactory::getDbo();
	$query = $db->getQuery(true);
	$query->select($db->quoteName(array('id')))
		->from($db->quoteName('#__timetable_events'))
		->where($db->quoteName('alias') . ' = '. $db->quote($vars['alias']));
	
	$db->setQuery($query);
	$event_id = $db->loadResult();
	$vars['id']	= $event_id;
	
	return $vars;
}
