<?php
/**
 * @author QuanticaLabs - http://codecanyon.net/user/QuanticaLabs/portfolio?ref=QuanticaLabs
 *
 * @link			http://codecanyon.net/item/timetable-responsive-schedule-for-joomla/9749539?ref=QuanticaLabs
 * @copyright		Copyright (C) 2008 - 2014 quanticalabs.com . All rights reserved.
 * @license			GNU General Public License version 2 or later; see LICENSE under Licensing/ directory
 */
 
defined('_JEXEC') or die('Restricted access');

$lang = JFactory::getLanguage();
$lang->load('com_timetable', JPATH_SITE);

class Timetable_Shortcode {
	
	public static function process_shortcodes($content) {
		
		// replace COM_TIMETABLE_MEDIA_IMAGES text with an actual URL to the /media/com_timetable/images/ folder
		$content = str_replace("COM_TIMETABLE_MEDIA_IMAGES_URL", COM_TIMETABLE_MEDIA_IMAGES_URL, $content);

		error_reporting( error_reporting() & ~E_NOTICE );

		// replace article links
		$db = JFactory::getDbo();
		$query = "SELECT 
				id, alias
			FROM 
				#__content
			WHERE
				alias IN ('timetable-for-joomla-sample-1', 
					'timetable-for-joomla-sample-2', 
					'timetable-for-joomla-sample-3',
					'timetable-for-joomla-sample-4',
					'timetable-for-joomla-sample-5')
			ORDER BY id ASC";
		$db->setQuery($query);
		$timetable_articles = $db->loadObjectList("alias");
		
		$scheme = JUri::getInstance()->getScheme();
		$is_ssl = $scheme=="https" ? 1 : 2;
		
		// checks if SEF is enabled
		$config = JFactory::getConfig();

		$config_sef = $config->get("sef");
		$config_sef_rewrite = $config->get("sef_rewrite");
		
		$article_url = $config_sef &&  $config_sef_rewrite ? JUri::base() . "timetable-for-joomla-sample-1" : JRoute::_("index.php?option=com_content&view=article&id=" . $timetable_articles["timetable-for-joomla-sample-1"]->id, false, $is_ssl);		
		$content = str_replace(
			"COM_TIMETABLE_LINK_TIMETABLE_FOR_JOOMLA_SAMPLE_1", 
			$article_url, 
			$content
		);
		
		$article_url = $config_sef &&  $config_sef_rewrite ? JUri::base() . "timetable-for-joomla-sample-2" : JRoute::_("index.php?option=com_content&view=article&id=" . $timetable_articles["timetable-for-joomla-sample-2"]->id, false, $is_ssl);
		$content = str_replace(
			"COM_TIMETABLE_LINK_TIMETABLE_FOR_JOOMLA_SAMPLE_2", 
			$article_url, 
			$content
		);
		$article_url = $config_sef &&  $config_sef_rewrite ? JUri::base() . "timetable-for-joomla-sample-3" : JRoute::_("index.php?option=com_content&view=article&id=" . $timetable_articles["timetable-for-joomla-sample-3"]->id, false, $is_ssl);
		$content = str_replace(
			"COM_TIMETABLE_LINK_TIMETABLE_FOR_JOOMLA_SAMPLE_3", 
			$article_url, 
			$content
		);
		$article_url = $config_sef &&  $config_sef_rewrite ? JUri::base() . "timetable-for-joomla-sample-4" : JRoute::_("index.php?option=com_content&view=article&id=" . $timetable_articles["timetable-for-joomla-sample-4"]->id, false, $is_ssl);
		$content = str_replace(
			"COM_TIMETABLE_LINK_TIMETABLE_FOR_JOOMLA_SAMPLE_4", 
			$article_url, 
			$content
		);
		$article_url = $config_sef &&  $config_sef_rewrite ? JUri::base() . "timetable-for-joomla-sample-5" : JRoute::_("index.php?option=com_content&view=article&id=" . $timetable_articles["timetable-for-joomla-sample-5"]->id, false, $is_ssl);
		$content = str_replace(
			"COM_TIMETABLE_LINK_TIMETABLE_FOR_JOOMLA_SAMPLE_5", 
			$article_url,
			$content
		);
		
		
		
		// list of shortcodes
		$shortcodes = array(
			"tt_timetable" => "#\[tt_timetable(.*?)\]#s",
			"tt_event_hours" => "#\[tt_event_hours(.*?)\]#s",
			"tt_columns" => "#\[tt_columns(.*?)\](.*?)(\[/tt_columns\])#s",
			"tt_column_left" => "#\[tt_column_left(.*?)\](.*?)(\[/tt_column_left\])#s",
			"tt_column_right" => "#\[tt_column_right(.*?)\](.*?)(\[/tt_column_right\])#s",
			"tt_items_list" => "#\[tt_items_list(.*?)\](.*?)(\[/tt_items_list\])#s",
			"tt_item" => "#\[tt_item(.*?)\](.*?)(\[/tt_item\])#s",
		);
		foreach($shortcodes as $shortcode=>$pattern) {
			preg_match_all($pattern, $content, $matched_shortcodes);
			
			$matches_count = count($matched_shortcodes[0]);
			for($i=0; $i<$matches_count; $i++) {
				// find all shortcode atts
				$pattern_atts = '/(\w+)\s*=\s*"([^"]*)"(?:\s|$)|(\w+)\s*=\s*\'([^\']*)\'(?:\s|$)|(\w+)\s*=\s*([^\s\'"]+)(?:\s|$)|"([^"]*)"(?:\s|$)|(\S+)(?:\s|$)/';
				$attributes_temp = trim($matched_shortcodes[1][$i]);
				preg_match_all($pattern_atts, $attributes_temp, $matched_atts);
				
				$attributes = array();
				$shortcode_atts = array();
				for($j=0; $j<4; $j++) {
					foreach($matched_atts[1 + ($j*2)] as $index=>$att) {
						if(!empty($att))
							$shortcode_atts[$att] = $matched_atts[2 + ($j*2)][$index];
					}
				}
				$shortcode_content = !empty($matched_shortcodes[2][$i]) ? $matched_shortcodes[2][$i] : null;
				$output = self::$shortcode($shortcode_atts, $shortcode_content);
				
				// replace 
				$content = str_replace($matched_shortcodes[0][$i], $output, $content);
			}
		}
		return $content;
	}
	
	public static function tt_event_hours($atts)
	{
		$db = JFactory::getDbo();
		extract(array_merge(array(
			"title" => !empty($atts["title"]) ? $atts["title"] : "Event Hours",
			"time_format" => !empty($atts["time_format"]) ? $atts["time_format"] : "H.i",
			"class" => !empty($atts["class"]) ? $atts["class"] : "",
			"hour_category" => !empty($atts["hour_category"]) ? $atts["hour_category"] : "",
			"text_color" => !empty($atts["text_color"]) ? $atts["text_color"] : "",
			"border_color" => !empty($atts["border_color"]) ? $atts["border_color"] : "",
			"columns" => !empty($atts["columns"]) ? $atts["columns"] : "",
		), $atts));
		
		$event_alias = JFactory::getApplication()->input->get("alias");
		$query  ="SELECT 
					e.id 
				FROM
					#__timetable_events	e
				WHERE
					e.alias = '{$event_alias}'";
		$db->setQuery($query);
		$event_id = $db->loadResult();

		if($hour_category!=null && $hour_category!="-")
			$hour_category = array_values(array_diff(array_filter(array_map('trim', explode(",", $hour_category))), array("-")));

		if($columns!="")
		{
			$weekdays_explode = explode(",", $columns);
			$weekdays_in_query = "";
			foreach($weekdays_explode as $weekday_explode)
				$weekdays_in_query .= "'" . $weekday_explode . "'" . ($weekday_explode!=end($weekdays_explode) ? "," : "");
		}

		//The actual fields for data entry
		$query = "SELECT * FROM `#__timetable_event_hours` as t1
			LEFT JOIN
				#__timetable_columns t2 ON (t1.weekday_id = t2.id) 
			WHERE
				t1.event_id= '{$event_id}'";
		if($hour_category!=null && $hour_category!="-")
			$query .= "AND t1.category IN('" . join("','", $hour_category) . "')";
		if(!empty($weekdays_in_query))
			$query .= " AND t2.alias IN(" . $weekdays_in_query . ")";		
		$query .= " ORDER BY t2.ordering, t1.start, t1.end";
		$db->setQuery($query);
		$event_hours = $db->loadObjectList();
		$event_hours_count = count($event_hours);

		$output = '';
		if($event_hours_count)
		{
			//get weekdays
			$query = "SELECT id, title
				FROM 
					#__timetable_columns
				ORDER BY ordering";
			$db->setQuery($query);
			$weekdays = $db->loadObjectList();
			if($title!="")
				$output .= '<h3 class="tt_event_margin_top_27">' . $title . '<span class="tt_event_hours_count">(' . $event_hours_count . ')</span></h3>';
			$output .= '
			<ul id="event_hours_list" class="timetable_clearfix tt_event_hours' . ($class!="" ? ' ' . $class : '') . '">';
				for($i=0; $i<$event_hours_count; $i++)
				{
					//get event color
					if($border_color=="")
						$border_color = "#" . self::db_get_event_option($event_id, "color");
					
					$query = "SELECT * 
						FROM 
							#__timetable_columns 
						WHERE
							id = " . $event_hours[$i]->weekday_id;
					$db->setQuery($query);
					$current_day = $db->loadObject();
					$output .= '<li' . ($border_color!="" ? ' style="border-left-color:' . $border_color . ';"' : '') . ' id="event_hours_' . $event_hours[$i]->id . '" class="event_hours_' . ($i%2==0 ? 'left' : 'right') . '"><h4' . ($text_color!="" ? ' style="color:' . $text_color . ';"' : '') . '>' . $current_day->title . '</h4><h4' . ($text_color!="" ? ' style="color:' . $text_color . ';"' : '') . '>' . date($time_format, strtotime($event_hours[$i]->start)) . ' - ' . date($time_format, strtotime($event_hours[$i]->end)) . '</h4>';
					if($event_hours[$i]->before_hour_text!="" || $event_hours[$i]->after_hour_text!="")
					{
						$output .= '<p' . ($text_color!="" ? ' style="color:' . $text_color . ';"' : '') . ' class="tt_event_padding_bottom_0">';
						if($event_hours[$i]->before_hour_text!="")
							$output .= $event_hours[$i]->before_hour_text;
						if($event_hours[$i]->after_hour_text!="")
							$output .= ($event_hours[$i]->before_hour_text!="" ? '<br>' : '') . $event_hours[$i]->after_hour_text;
						$output .= '</p>';
					}
					$output .= '</li>';
				}
			$output .= '</ul>';
		}
		return $output;
	}

	public static function tt_columns($atts, $content)
	{	
		extract(array_merge(array(
			"class" => !empty($atts["class"]) ? $atts["class"] : "",
		), $atts));
		return '<div class="tt_event_columns' . ($class!='' ? ' ' . $class : '') . '">' . $content . '</div>';
	}
	
	public static function tt_column_left($atts, $content)
	{
		return '<div class="tt_event_column_left">' . $content . '</div>';
	}
	
	public static function tt_column_right($atts, $content)
	{
		return '<div class="tt_event_column_right">' . $content . '</div>';
	}

	
	public static function tt_items_list($atts, $content)
	{
		extract(array_merge(array(
			"class" => !empty($atts["class"]) ? $atts["class"] : "",
		), $atts));

		$output = '';
		$output .= '
		<ul class="tt_event_items_list' . ($class!='' ? ' ' . $class : '') . '">
			' . $content . '
		</ul>';
		return $output;
	}

	public static function tt_item($atts, $content)
	{
		
		extract(array_merge(array(
			"type" => !empty($atts["type"]) ? $atts["type"] : "",
			"border_color" => !empty($atts["border_color"]) ? $atts["border_color"] : "",
			"text_color" => !empty($atts["text_color"]) ? $atts["text_color"] : "",
			"value" => !empty($atts["value"]) ? $atts["value"] : "",
		), $atts));
		
		$output = '';
		$output .= '
		<li' . ($type=="info" ? ' class="timetable_clearfix type_info"' : '') . ($border_color!='' ? ' style="border-bottom: ' . ($border_color=='none' ? 'none' : '1px solid #' . $border_color . '') . ';"' : '') . '>
			<' . ($type=="info" ? 'label' : 'span') . ($text_color!='' ? ' style="color: #' . $text_color . ';"' : '') . '>' . $content . '</' . ($type=="info" ? 'label' : 'span') . '>';
			if($value!="")
				$output .= '<div class="tt_event_text">' . $value . '</div>';
		$output .= '
		</li>';
		return $output;
	}

	public static function tt_timetable($atts, $content=null)
	{
		$db = JFactory::getDbo();
		extract(array_merge(array(
			"event" => !empty($atts["event"]) ? $atts["event"] : "",
			"event_category" => !empty($atts["event_category"]) ? $atts["event_category"] : "",
			"events_page" => !empty($atts["events_page"]) ? $atts["events_page"] : "",
			"filter_style" => !empty($atts["filter_style"]) ? $atts["filter_style"] : "dropdown_list",
			"filter_kind" => !empty($atts["filter_kind"]) ? $atts["filter_kind"] : "event",
			"measure" => !empty($atts["measure"]) ? $atts["measure"] : 1,
			"filter_label" => !empty($atts["filter_label"]) ? $atts["filter_label"] : "All Events",
			"filter_label_2" => !empty($atts["filter_label_2"]) ? $atts["filter_label_2"] : "All Events Categories",
			"hour_category" => !empty($atts["hour_category"]) ? $atts["hour_category"] : "",
			"columns" => !empty($atts["columns"]) ? $atts["columns"] : "",
			"time_format" => !empty($atts["time_format"]) ? $atts["time_format"] : "H.i",
			"hide_hours_column" => !empty($atts["hide_hours_column"]) ? $atts["hide_hours_column"] : 0,
			"hide_all_events_view" => !empty($atts["hide_all_events_view"]) ? $atts["hide_all_events_view"] : 0,
			"show_end_hour" => !empty($atts["show_end_hour"]) ? $atts["show_end_hour"] : 0,
			"event_layout" => !empty($atts["event_layout"]) ? $atts["event_layout"] : 1,
			"box_bg_color" => !empty($atts["box_bg_color"]) ? $atts["box_bg_color"] : "00A27C",
			"box_hover_bg_color" => !empty($atts["box_hover_bg_color"]) ? $atts["box_hover_bg_color"] : "1F736A",
			"box_txt_color" => !empty($atts["box_txt_color"]) ? $atts["box_txt_color"] : "FFFFFF",
			"box_hover_txt_color" => !empty($atts["box_hover_txt_color"]) ? $atts["box_hover_txt_color"] : "FFFFFF",
			"box_hours_txt_color" => !empty($atts["box_hours_txt_color"]) ? $atts["box_hours_txt_color"] : "FFFFFF",
			"box_hours_hover_txt_color" => !empty($atts["box_hours_hover_txt_color"]) ? $atts["box_hours_hover_txt_color"] : "FFFFFF",
			"filter_color" => !empty($atts["filter_color"]) ? $atts["filter_color"] : "00A27C",
			"row1_color" => !empty($atts["row1_color"]) ? $atts["row1_color"] : "F0F0F0",
			"row2_color" => !empty($atts["row2_color"]) ? $atts["row2_color"] : "",
			"hide_empty" => !empty($atts["hide_empty"]) ? $atts["hide_empty"] : 0,
			"disable_event_url" => !empty($atts["disable_event_url"]) ? $atts["disable_event_url"] : 0,
			"text_align" => !empty($atts["text_align"]) ? $atts["text_align"] : "center",
			"row_height" => !empty($atts["row_height"]) ? $atts["row_height"] : 31,
			"id" => !empty($atts["id"]) ? $atts["id"] : "",
			"responsive" => !empty($atts["responsive"]) ? $atts["responsive"] : 1,
			"font_custom" => !empty($atts["font_custom"]) ? $atts["font_custom"] : "",
			"font" => !empty($atts["font"]) ? $atts["font"] : "",
			"font_subset" => !empty($atts["font_subset"]) ? $atts["font_subset"] : "",
			"font_size" => !empty($atts["font_size"]) ? $atts["font_size"] : "",
			"custom_css" => !empty($atts["custom_css"]) ? $atts["custom_css"] : ""
		), $atts));

		$juri = JURI::getInstance();
		$current_url = $juri->current();
		$current_query = $juri->getQuery();	
		$current_url_full = !empty($current_query) ? $current_url . '?'. $current_query : $current_url;
		
		$events_array = array_values(array_diff(array_filter(array_map('trim', explode(",", $event))), array("-")));
		$events_info_array = self::db_get_events_by_alias_array($events_array);
		$events_array_id = array();
		foreach($events_info_array as $key=>$event_info)
			$events_array_id[] = $event_info['id'];
		
		$event_category_array = array_values(array_diff(array_filter(array_map('trim', explode(",", $event_category))), array("-")));
		$event_categories_info_array = self::db_get_event_categories_by_alias_array($event_category_array);
		$events_categories_ids = array();
		foreach($event_categories_info_array as $key=>$event_category)
			$events_categories_ids[] = $event_category['id'];
		
		if(!$hide_all_events_view)
		{
			$events_list_html = '<li><a href="#all-events' . ($id!='' ? '-' . $id : '') . '" title="' . htmlentities($filter_label) . '">' . $filter_label . '</a></li>';
			$events_categories_list_html = '<li><a href="#all-events' . ($id!='' ? '-' . $id : '') . '" title="' . htmlentities(($filter_kind=="event_and_event_category" ? $filter_label_2 : $filter_label)) . '">' . ($filter_kind=="event_and_event_category" ? $filter_label_2 : $filter_label) . '</a></li>';
		}
		else
		{
			$events_list_html = '';
			$events_categories_list_html = '';
		}
		
		if($filter_kind=="event" || !count($event_category_array) || ($filter_kind=="event_and_event_category" && !empty($event)))
		{
			foreach($events_info_array as $key=>$event_info)
			{
				$events_list_html .= '<li><a href="#' . $event_info['alias'] . '" title="' . htmlentities($event_info['title']) . '">' . $event_info['title'] . '</a></li>';
				if($hide_all_events_view && $filter_style=="dropdown_list" && ($filter_label=="All Events" || $filter_label=="") && !$key)
				{
					$filter_label = $event_info['title'];
				}
			}
		}
		
		if($filter_kind=="event_category" || ($filter_kind=="event_and_event_category" && !empty($event_category)))
		{
			foreach($event_categories_info_array as $key=>$event_category_info)
			{
				$events_categories_list_html .= '<li><a href="#' . $event_category_info['alias'] . '" title="' . htmlentities($event_category_info['title']) . '">' . $event_category_info['title'] . '</a></li>';
				if($hide_all_events_view && $filter_style=="dropdown_list" && !$key)
				{
					if($filter_kind!="event_and_event_category" && ($filter_label=="All Events" || $filter_label==""))
						$filter_label = $event_category_info['title'];
					if($filter_kind=="event_and_event_category" && ($filter_label_2=="All Events Categories" || $filter_label_2==""))
						$filter_label_2 = $event_category_info['title'];
				}
			}
		}
		
		$events_array_verified = array();
		if(count($event_category_array))
		{
			$events_alias_array = self::db_get_events_alias_by_categories_and_event_id_array($events_categories_ids, $events_array_id);
			
			if(!empty($events_alias_array))
			{
				foreach($events_alias_array as $key=>$event_alias)
					$events_array_verified[] = htmlentities($event_alias['alias']);
			}
			else
				$events_array_verified = -1;
		}
		
		$output = '';
		if($filter_style=="dropdown_list")
		{
			if($filter_kind=="event_category" || $filter_kind=="event_and_event_category")
			{
				$output .= '<ul class="timetable_clearfix tabs_box_navigation events_categories_filter' . ((int)$responsive ? " tt_responsive" : "") . ' sf-timetable-menu' . ($id!="" ? ' ' . htmlentities($id) : '') . ' ' . ($filter_kind=="event_and_event_category" ? "tt_double_buttons" : "") . '">
					<li class="tabs_box_navigation_selected" aria-haspopup="true"><label>' . ($filter_kind=="event_and_event_category" ? $filter_label_2 : $filter_label) . '</label><span class="tabs_box_navigation_icon"></span>' . (!$hide_all_events_view || !empty($event_category) ? '<ul class="sub-menu">' . $events_categories_list_html . '</ul>' : '') . '</li>
				</ul>';
			}

			if($filter_kind=="event" || $filter_kind=="event_and_event_category")
			{
				$output .= '<ul class="timetable_clearfix tabs_box_navigation events_filter' . ((int)$responsive ? " tt_responsive" : "") . ' sf-timetable-menu' . ($id!="" ? ' ' . $id : '') . ' ' . ($filter_kind=="event_and_event_category" ? "tt_double_buttons" : "") . '">
					<li class="tabs_box_navigation_selected" aria-haspopup="true"><label>' . $filter_label . '</label><span class="tabs_box_navigation_icon"></span>' . (!$hide_all_events_view || !empty($event) ? '<ul class="sub-menu">' . $events_list_html . '</ul>' : '') . '</li>
				</ul>';
			}		
		}
		
		if((int)$row_height!=31 || strtoupper($box_bg_color)!="00A27C" || strtoupper($filter_color)!="00A27C" || $custom_css!="")
		{
			$output .= '<style type="text/css">' . $custom_css . ((int)$row_height!=31 ? ($id!="" ? '#' . $id : '') . '.tt_tabs .tt_timetable td{height: ' . (int)$row_height . (substr($row_height, -2)!="px" ? 'px' : '') . ';}' : '') . (strtoupper($box_bg_color)!="00A27C" ? ($id!="" ? '#' . $id : '') . '.tt_tabs .tt_timetable .event{background: #' . $box_bg_color . ';}' : '') . (strtoupper($filter_color)!="00A27C" ? ($id!="" ? '#' . $id : '') . ' .tt_tabs_navigation li a:hover,' . ($id!="" ? '#' . $id : '') . ' .tt_tabs_navigation li a.selected,' . ($id!="" ? '#' . $id : '') . ' .tt_tabs_navigation li.ui-tabs-active a{border-color:#' . $filter_color . ' !important;}' . ($id!="" ? '.' . $id : '') . '.tabs_box_navigation.sf-timetable-menu .tabs_box_navigation_selected,.tabs_box_navigation.sf-timetable-menu.tabs_box_navigation_disable_hover .tabs_box_navigation_selected:hover{background-color:#' . $filter_color . ';border-color:#' . $filter_color . ';}' . ($id!="" ? '.' . $id : '') . '.tabs_box_navigation.sf-timetable-menu .tabs_box_navigation_selected:hover{background-color: #FFF; border: 1px solid rgba(0, 0, 0, 0.1);}' . ($id!="" ? '.' . $id : '') . '.sf-timetable-menu li ul li a:hover, .sf-timetable-menu li ul li.selected a:hover{background-color:#' . $filter_color . ';}' : '') . '</style>';
		}
		if($font!="")
				$output .= '<link rel="stylesheet" type="text/css" href="//fonts.googleapis.com/css?family=' . $font . '&subset=' . $font_subset . '">';
		if($font_custom!="" || $font!="" || (int)$font_size>0)
		{
			$font_explode = explode(":", $font);
				$font = '"' . $font_explode[0] . '"';
			$output .= '<style type="text/css">' . ($font_custom!="" || $font!="" ? ($id!="" ? '#' . $id : '') . '.tt_tabs .tt_timetable{font-family:' . ($font_custom!="" ? $font_custom : $font) . ' !important;}' : '') . ((int)$font_size>0 ? ($id!="" ? '#' . $id : '') . '.tt_tabs .tt_timetable th,' . ($id!="" ? '#' . $id : '') . '.tt_tabs .tt_timetable td,' . ($id!="" ? '#' . $id : '') . '.tt_tabs .tt_timetable .event .before_hour_text,' . ($id!="" ? '#' . $id : '') . '.tt_tabs .tt_timetable .event .after_hour_text,' . ($id!="" ? '#' . $id : '') . '.tt_tabs .tt_timetable .event .event_header{font-size:' . (int)$font_size . 'px !important;}' : '') . '</style>';
		}
		
		$output .= '<div class="timetable_clearfix tt_tabs' . ((int)$responsive ? " tt_responsive" : "") . " event_layout_" . $event_layout . '"' . ($id!="" ? ' id="' . $id . '"' : '') . '>';
		
		// we need to display all filter items, both events and events categories, so the filter buttons from both lists are working correctly
		if($filter_kind=="event_and_event_category")
		{
			$all_filters_list_html = $events_categories_list_html . $events_list_html;
			// filter list must be hidden
			$output .= '<ul class="timetable_clearfix tt_tabs_navigation all_filters" style="display: none !important;">' . $all_filters_list_html . '</ul>';
		}
		
		if($filter_kind=="event_category" || $filter_kind=="event_and_event_category")
		{
			$events_categories_list_html_view_all = '';
			if($hide_all_events_view && empty($event_category))
				$events_categories_list_html_view_all = '<li><a href="#all-events' . ($id!='' ? '-' . $id : '') . '" title="' . htmlentites(($filter_kind=="event_and_event_category" ? $filter_label_2 : $filter_label)) . '">' . ($filter_kind=="event_and_event_category" ? $filter_label_2 : $filter_label) . '</a></li>';

			$output .= '<ul class="timetable_clearfix tt_tabs_navigation events_categories_filter"' . ($filter_style=="dropdown_list" ? ' style="display: none;"' : '') . '>' .  $events_categories_list_html_view_all . $events_categories_list_html . '</ul>';
		}
		if($filter_kind=="event" || $filter_kind=="event_and_event_category")
		{
			$events_list_html_view_all = '';
			if($hide_all_events_view && empty($event))
				$events_list_html_view_all = '<li><a href="#all-events' . ($id!='' ? '-' . $id : '') . '" title="' . htmlentities($filter_label) . '">' . $filter_label . '</a></li>';

			$output .= '<ul class="timetable_clearfix tt_tabs_navigation events_filter"' . ($filter_style=="dropdown_list" ? ' style="display: none;"' : '') . '>' . $events_list_html_view_all . $events_list_html . '</ul>';
		}
		
		if(!$hide_all_events_view)
		{
			$output .= '<div id="all-events' . ($id!='' ? '-' . $id : '') . '">' . (empty($events_array_verified) ? self::tt_get_timetable($atts, $events_array) : ($events_array_verified!=-1 ? self::tt_get_timetable($atts, $events_array_verified) : JText::_('COM_TIMETABLE_NO_EVENTS_AVAILABLE'))) . '</div>';		
		}

		if($filter_kind=="event" || !count($event_category_array) || $filter_kind=="event_and_event_category")
		{
			foreach($events_info_array as $key=>$event_info)
			{
				$categories_alias = self::db_get_categories_alias_by_event_id($event_info['id']);
				$categories_str = "";
				foreach($categories_alias as $key2=>$category_alias)
					$categories_str .= "tt-event-category-" . $category_alias['alias'] . " ";
				$output .= '<div id="' . $event_info['alias'] . '" class="tt-ui-tabs-hide ' . $categories_str . '">' . (empty($events_array_verified) || ($events_array_verified!=-1 && in_array($event_info['alias'], $events_array_verified)) ? self::tt_get_timetable($atts, $event_info['alias']) : JText::_('COM_TIMETABLE_NO_EVENTS_AVAILABLE')) . '</div>';
			}
		}
		
		if($filter_kind=="event_category" || $filter_kind=="event_and_event_category")
		{
			foreach($event_categories_info_array as $key=>$event_category_info)
			{
				$events_alias_array = self::db_get_events_alias_by_category_and_event_id_array($event_category_info['id'], $events_array_id);

				$events_array_for_timetable = array();
				foreach($events_alias_array as $key2=>$event_alias)
					$events_array_for_timetable[] = $event_alias['alias'];
				$output .= '<div id="' . $event_category_info['alias'] . '" class="tt-ui-tabs-hide">' . (count($events_alias_array) ? self::tt_get_timetable($atts, $events_array_for_timetable) : JText::sprintf("COM_TIMETABLE_NO_EVENTS_AVAILABLE_IN_CATEGORY", strtolower($event_category_info['title']))) . '</div>';
			}
		}
		$output .= '</div>';
		
		$output .= "<div id='tt_error_message' class='tt_hide'>" . JText::_('COM_TIMETABLE_NO_EVENTS_AVAILABLE') . "</div>";
		
		return $output;
	}
	
	
	public static function tt_get_timetable($atts, $event = null)
	{
		$db = JFactory::getDbo();
	
		// simulate wordpress extract(shortcode_atts()) function
		extract(array(
			"events_page" => !empty($atts["events_page"]) ? $atts["events_page"] : "",
			"measure" => !empty($atts["measure"]) ? $atts["measure"] : 1,
			"filter_style" => !empty($atts["filter_style"]) ? $atts["filter_style"] : "dropdown_list",
			"filter_label" => !empty($atts["filter_label"]) ? $atts["filter_label"] : "All Events",
			"filter_label_2" => !empty($atts["filter_label_2"]) ? $atts["filter_label_2"] : "All Events Categories",
			"hour_category" => !empty($atts["hour_category"]) ? $atts["hour_category"] : "",
			"columns" => !empty($atts["columns"]) ? $atts["columns"] : "",
			"time_format" => !empty($atts["time_format"]) ? $atts["time_format"] : "H.i",
			"hide_hours_column" => !empty($atts["hide_hours_column"]) ? $atts["hide_hours_column"] : 0,
			"hide_all_events_view" => !empty($atts["hide_all_events_view"]) ? $atts["hide_all_events_view"] : 0,
			"show_end_hour" => !empty($atts["show_end_hour"]) ? $atts["show_end_hour"] : 0,
			"event_layout" => !empty($atts["event_layout"]) ? $atts["event_layout"] : 1,
			"box_bg_color" => !empty($atts["box_bg_color"]) ? $atts["box_bg_color"] : "00A27C",
			"box_hover_bg_color" => !empty($atts["box_hover_bg_color"]) ? $atts["box_hover_bg_color"] : "1F736A",
			"box_txt_color" => !empty($atts["box_txt_color"]) ? $atts["box_txt_color"] : "FFFFFF",
			"box_hover_txt_color" => !empty($atts["box_hover_txt_color"]) ? $atts["box_hover_txt_color"] : "FFFFFF",
			"box_hours_txt_color" => !empty($atts["box_hours_txt_color"]) ? $atts["box_hours_txt_color"] : "FFFFFF",
			"box_hours_hover_txt_color" => !empty($atts["box_hours_hover_txt_color"]) ? $atts["box_hours_hover_txt_color"] : "FFFFFF",
			"row1_color" => !empty($atts["row1_color"]) ? $atts["row1_color"] : "F0F0F0",
			"row2_color" => !empty($atts["row2_color"]) ? $atts["row2_color"] : "",
			"hide_empty" => !empty($atts["hide_empty"]) ? $atts["hide_empty"] : 0,
			"disable_event_url" => !empty($atts["disable_event_url"]) ? $atts["disable_event_url"] : 0,
			"text_align" => !empty($atts["text_align"]) ? $atts["text_align"] : "center",
			"row_height" => !empty($atts["row_height"]) ? $atts["row_height"] : 31,
			"id" => !empty($atts["id"]) ? $atts["id"] : "",
			"responsive" => !empty($atts["responsive"]) ? $atts["responsive"] : 1
		));
		
		$measure = (double)$measure;
		
		global $wpdb;
		if($columns!="")
		{
			$weekdays_explode = explode(",", $columns);
			$weekdays_in_query = "";
			foreach($weekdays_explode as $weekday_explode)
				$weekdays_in_query .= "'" . $weekday_explode . "'" . ($weekday_explode!=end($weekdays_explode) ? "," : "");
		}
		if($hour_category!=null && $hour_category!="-")
			$hour_category = array_values(array_diff(array_filter(array_map('trim', explode(",", $hour_category))), array("-")));
		$output = "";
		
		$output = "";
		$query = "SELECT TIME_FORMAT(t1.start, '%H.%i') AS start, TIME_FORMAT(t1.end, '%H.%i') AS end, t1.tooltip AS tooltip, t1.before_hour_text AS before_hour_text, t1.after_hour_text AS after_hour_text, t2.id AS event_id, t2.title AS event_title, t2.alias AS post_name, t3.title, t3.ordering FROM #__timetable_event_hours AS t1 
				LEFT JOIN #__timetable_events AS t2 ON t1.event_id=t2.id 
				LEFT JOIN #__timetable_columns AS t3 ON t1.weekday_id=t3.id
				WHERE 1=1 ";
		if(is_array($event) && count($event))
			$query .= "
				AND t2.alias IN('" . join("','", $event) . "')";
		else if($event!=null)
			$query .= "
				AND t2.alias='" . strtolower(urlencode($event)) . "'";
		if($hour_category!=null && $hour_category!="-")
			$query .= "
				AND t1.category IN('" . join("','", $hour_category) . "')";
		
		if(isset($weekdays_in_query) && $weekdays_in_query!="")
			$query .= " AND t3.alias IN(" . $weekdays_in_query . ")";
		$query .= " ORDER BY t3.ordering, t1.start, t1.end";
	
		$db->setQuery($query);
		$event_hours = $db->loadObjectList();
		if(!count($event_hours))
			return JText::_('COM_TIMETABLE_NO_EVENT_HOURS_AVAILABLE');
		
		$event_hours_tt = array();
		foreach($event_hours as $event_hour)
		{
			$event_hours_tt[$event_hour->ordering][] = array(
				"start" => $event_hour->start,
				"end" => $event_hour->end,
				"tooltip" => $event_hour->tooltip,
				"before_hour_text" => $event_hour->before_hour_text,
				"after_hour_text" => $event_hour->after_hour_text,
				"tooltip" => $event_hour->tooltip,
				"id" => $event_hour->event_id,
				"title" => $event_hour->event_title,
				"name" => $event_hour->post_name
			);
		}

		$output .= '<table class="tt_timetable">
					<thead>
						<tr class="row_gray"' . ($row1_color!="" ? ' style="background-color: ' . ($row1_color!="transparent" ? '#' : '') . $row1_color . ' !important;"' : '') . '>';
						if(!(int)$hide_hours_column)
							$output .= '<th></th>';
						
		// get columns
		$query = "SELECT title, ordering FROM #__timetable_columns";
		if(isset($weekdays_in_query) && $weekdays_in_query!="")
			$query .= " WHERE alias IN(" . $weekdays_in_query . ")";
		$query .= " ORDER BY ordering";

		$db->setQuery($query);
		$weekdays = $db->loadObjectList();

		foreach($weekdays as $weekday)
		{
			$output .= '	<th>' . $weekday->title . '</th>';
		}

		$output .= '	</tr>
					</thead>
					<tbody>';
		
		$query = "SELECT min(TIME_FORMAT(t1.start, '%H.%i')) AS min, max(REPLACE(TIME_FORMAT(t1.end, '%H.%i'), '00.00', '24.00')) AS max FROM #__timetable_event_hours AS t1
				LEFT JOIN #__timetable_events AS t2 ON t1.event_id=t2.id 
				LEFT JOIN #__timetable_columns AS t3 ON t1.weekday_id=t3.id
				WHERE 
					1=1 ";
		if(is_array($event) && count($event))
			$query .= "
				AND t2.alias IN('" . join("','", $event) . "')";
		else if($event!=null)
			$query .= "
				AND t2.alias='" . strtolower(urlencode($event)) . "'";
		if($hour_category!=null && $hour_category!="-")
			$query .= "
				AND t1.category IN('" . join("','", $hour_category) . "')";
		
		if(isset($weekdays_in_query) && $weekdays_in_query!="")
			$query .= " AND t3.alias IN(" . $weekdays_in_query . ")";
		
		$db->setQuery($query);
		$hours = $db->loadObject();
		if(empty($hours->max) || empty($hours->min))
			return;
		
		$drop_columns = array();
		$l = 0;
		$increment = 1;
		$hours_min = (int)$hours->min;
		if((int)$measure==1)
		{
			 
			$max_explode = explode(".", $hours->max);
			$max_hour = (int)$hours->max + ((int)$max_explode[1]>0 ? 1 : 0);
		}
		else
		{

			$max_hour = $hours->max;
			$max_hour = self::to_decimal_time($max_hour);
			$max_hour = self::get_next_row_hour($max_hour, $measure);
			$increment = (double)$measure;
			$hours_min = self::to_decimal_time(self::roundMin($hours->min, $measure, self::to_decimal_time($hours_min)));
		}
		for($i=$hours_min; $i<$max_hour; $i=$i+$increment)
		{
			if((int)$measure==1)
			{
				$start = str_pad($i, 2, '0', STR_PAD_LEFT) . '.00';
				$end = str_replace("24", "00", str_pad($i+1, 2, '0', STR_PAD_LEFT)) . '.00';
			}
			else
			{
				$i = number_format($i, 2);
				$hourIExplode = explode(".", $i);
				$hourI = $hourIExplode[0] . "." . ((int)$hourIExplode[1]>0 ? (int)$hourIExplode[1]*60/100 : "00");
				$start = number_format($i, 2);
				$end = number_format(str_replace("24", "00", $i+$measure), 2);
				$startExplode = explode(".", $start);
				$start = str_pad($startExplode[0], 2, '0', STR_PAD_LEFT) . "." . ((int)$startExplode[1]>0 ? (int)$startExplode[1]*60/100 : "00");
				$endExplode = explode(".", $end);
				$end = str_pad($endExplode[0], 2, '0', STR_PAD_LEFT) . "." . ((int)$endExplode[1]>0 ? (int)$endExplode[1]*60/100 : "00");
			}
			if($time_format!="H.i")
			{
				$start = date($time_format, strtotime($start));
				$end = date($time_format, strtotime($end));
			}

			$row_empty = true;
			$temp_empty_count = 0;
			$row_content = "";
			for($j=0; $j<count($weekdays); $j++)
			{
				//$weekday_fixed_number = ($weekdays[$j]->ordering>1 ? $weekdays[$j]->ordering-1 : 7);
				$weekday_fixed_number = $weekdays[$j]->ordering;
				if(!in_array($weekday_fixed_number, (array)(isset($drop_columns[$i]["columns"]) ? $drop_columns[$i]["columns"] : array())))
				{
					if(self::tt_hour_in_array($i, (isset($event_hours_tt[$weekday_fixed_number]) ? $event_hours_tt[$weekday_fixed_number] : array()), $measure, $hours_min))
					{
						$rowspan = self::tt_get_rowspan_value($i, $event_hours_tt[$weekday_fixed_number], 1, $measure, $hours_min);
						if($rowspan>1)
						{
							if((int)$measure==1)
							{
								for($k=1; $k<$rowspan; $k++)
									$drop_columns[$i+$k]["columns"][] = $weekday_fixed_number;	
							}
							else
							{
								for($k=$measure; $k<$rowspan*$measure; $k=$k+$measure)
								{
									$tmp = number_format($i+$k, 2);
									$drop_columns["$tmp"]["columns"][] = $weekday_fixed_number;	
								}
							}
						}
						$array_count = count($event_hours_tt[$weekday_fixed_number]);
						$hours = array();
						if((int)$measure==1)
						{
							for($k=(int)$i; $k<(int)$i+$rowspan; $k++)
								$hours[] = $k;
						}
						else
						{
							for($k=(double)$i; $k<(double)$i+$rowspan*$measure; $k=$k+$measure)
								$hours[] = $k;
						}
						$events = array();
						for($k=0; $k<$array_count; $k++)
						{
							if(((int)$measure==1 && in_array((int)$event_hours_tt[$weekday_fixed_number][$k]["start"], $hours)) || ((int)$measure!=1 && in_array(self::to_decimal_time(self::roundMin($event_hours_tt[$weekday_fixed_number][$k]["start"], $measure, $hours_min)), $hours)))
							{
								$events[$k]["name"] = $event_hours_tt[$weekday_fixed_number][$k]["name"];
								$events[$k]["title"] = $event_hours_tt[$weekday_fixed_number][$k]["title"];
								$events[$k]["tooltip"][] = $event_hours_tt[$weekday_fixed_number][$k]["tooltip"];
								$events[$k]["before_hour_text"][] = $event_hours_tt[$weekday_fixed_number][$k]["before_hour_text"];
								$events[$k]["after_hour_text"][] = $event_hours_tt[$weekday_fixed_number][$k]["after_hour_text"];
								$events[$k]["id"] = $event_hours_tt[$weekday_fixed_number][$k]["id"];
								$events[$k]["hours"][] = $event_hours_tt[$weekday_fixed_number][$k]["start"] . " - " . $event_hours_tt[$weekday_fixed_number][$k]["end"];
								$event_hours_tt[$weekday_fixed_number][$k]["displayed"] = true;
							}
						}
						$color = "";
						$text_color = "";
						$hover_color = "";
						$hover_text_color = "";
						$hours_text_color = "";
						$hours_hover_text_color = "";
						
						// load events options
						if(count($events)==1 && count($events[key($events)]['hours'])==1)
						{					
							$color = self::db_get_event_option($events[key($events)]["id"], 'color');
							if($color=="" && strtoupper($box_bg_color)!="00A27C")
								$color = $box_bg_color;
							$hover_color = self::db_get_event_option($events[key($events)]["id"], 'hover_color');
							if($hover_color=="" && strtoupper($box_hover_bg_color)!="1F736A")
								$hover_color = $box_hover_bg_color;
							$text_color = self::db_get_event_option($events[key($events)]["id"], 'text_color');
							if($text_color=="" && strtoupper($box_txt_color)!="FFFFFF")
								$text_color = $box_txt_color;
							$hover_text_color = self::db_get_event_option($events[key($events)]["id"], 'hover_text_color');
							if($hover_text_color=="" && strtoupper($box_hover_txt_color)!="FFFFFF")
							{
								$hover_text_color = $box_hover_txt_color;
								if($text_color=="")
									$text_color = "FFFFFF";
							}
							
							$hours_text_color = self::db_get_event_option($events[key($events)]["id"], 'hours_text_color');
							if($hours_text_color=="" && strtoupper($box_hours_txt_color)!="FFFFFF")
								$hours_text_color = $box_hours_txt_color;
							
							$hours_hover_text_color = self::db_get_event_option($events[key($events)]["id"], 'hours_hover_text_color');
							if($hours_hover_text_color=="" && (strtoupper($box_hours_hover_txt_color)!="FFFFFF" || $hours_text_color!=""))
							{
								$hours_hover_text_color = $box_hours_hover_txt_color;
								if($hours_text_color=="")
									$hours_text_color = "FFFFFF";
							}
						}
						$global_colors = array(
							"box_bg_color" => $box_bg_color,
							"box_hover_bg_color" => $box_hover_bg_color,
							"box_txt_color" => $box_txt_color,
							"box_hover_txt_color" => $box_hover_txt_color,
							"box_hours_txt_color" => $box_hours_txt_color,
							"box_hours_hover_txt_color" => $box_hours_hover_txt_color
						);
						$row_content .= '<td' . ($color!="" || $text_color!="" || $text_align!="center" ? ' style="' . ($text_align!="center" ? 'text-align:' . $text_align . ';' : '') . ($color!="" ? 'background: #' . $color . ';' : '') . ($text_color!="" ? 'color: #' . $text_color . ';' : '') . '"': '') . ($hover_color!="" || $hover_text_color!="" || $hours_hover_text_color!="" ? ' onMouseOver="' . ($hover_color!="" ? 'this.style.background=\'#'.$hover_color.'\';' : '') . ($hover_text_color!="" ? 'this.style.color=\'#'.$hover_text_color.'\';jQuery(this).find(\'.event_header\').css(\'cssText\', \'color: #'.$hover_text_color.' !important\');' : '') . ($hours_hover_text_color!="" ? 'jQuery(this).find(\'.hours\').css(\'color\',\'#'.$hours_hover_text_color.'\');' : '') . '" onMouseOut="' . ($hover_color!="" ? 'this.style.background=\'#'.$color.'\';' : '') . ($hover_text_color!="" ? 'this.style.color=\'#'.$text_color.'\';jQuery(this).find(\'.event_header\').css(\'cssText\',\'color: #'.$text_color.' !important\');' : '') . ($hours_hover_text_color!="" ? 'jQuery(this).find(\'.hours\').css(\'color\',\'#'.$hours_text_color.'\');' : '') . '"' : '') . ' class="event' . (count(array_filter(array_values($events[key($events)]['tooltip']))) && count($events)==1 && count($events[key($events)]['hours'])==1 ? ' tt_tooltip' : '' ) . (count($events)==1 && count($events[key($events)]['hours'])==1 ? ' tt_single_event' : '') . '"' . ($rowspan>1 ? ' rowspan="' . $rowspan . '"' : '') . '>';
						$row_content .= self::tt_get_row_content($events, $events_page, $time_format, $event_layout, $global_colors, $disable_event_url);
						$row_content .= '</td>';
						$row_empty = false;
					}
					else
						$row_content .= '<td></td>';
					$temp_empty_count++;
				}
			}
			if($temp_empty_count!=$j)
				$row_empty = false;
			if(((int)$hide_empty && !$row_empty) || !(int)$hide_empty)
			{
				$output .= '<tr class="row_' . ($l+1) . ($l%2==1 ? ' row_gray' : '') . '"' . ($l%2==1 && strtoupper($row1_color)!="F0F0F0" ? ' style="background: ' . ($row1_color!="transparent" ? '#' : '') . $row1_color . ' !important;"' : '') . ($l%2==0 && $row2_color!="" ? ' style="background: ' . ($row2_color!="transparent" ? '#' : '') . $row2_color . ' !important;"' : '') . '>';
				if(!(int)$hide_hours_column)
				{
					$output .= '<td class="tt_hours_column">
						' . $start . ((int)$show_end_hour ? ' - ' . $end : '') . '
					</td>';
				}
				$output .= $row_content;				
				$output .= '</tr>';
				$l++;
			}
		}
		$output .= '</tbody>
				</table>';
		if((int)$responsive)
		{
			$output .= '<div class="tt_timetable small">';
			$l = 0;
			foreach($weekdays as $weekday)
			{
				//$weekday_fixed_number = ($weekday->ordering>1 ? $weekday->ordering-1 : 7);
				$weekday_fixed_number = $weekday->ordering;
				if(isset($event_hours_tt[$weekday_fixed_number]))
				{
					$output .= '<h3 class="box_header' . ($l>0 ? ' page_margin_top' : '') . '">
						' . $weekday->title . '
					</h3>
					<ul class="tt_items_list thin page_margin_top timetable_clearfix' . (isset($mode) && $mode=='12h' ? ' mode12' : '') . '">';
						$event_hours_count = count($event_hours_tt[$weekday_fixed_number]);

						for($i=0; $i<$event_hours_count; $i++)
						{
							if($time_format!="H.i")
							{
								$event_hours_tt[$weekday_fixed_number][$i]["start"] = date($time_format, strtotime($event_hours_tt[$weekday_fixed_number][$i]["start"]));
								$event_hours_tt[$weekday_fixed_number][$i]["end"] = date($time_format, strtotime($event_hours_tt[$weekday_fixed_number][$i]["end"]));
							}
							$classes_url = "";
							$timetable_custom_url = self::db_get_event_option($event_hours_tt[$weekday_fixed_number][$i]["id"], "custom_url");
							$timetable_disable_url = self::db_get_event_option($event_hours_tt[$weekday_fixed_number][$i]["id"], "disable_url");

							if(!(int)$timetable_disable_url && !(int)$disable_event_url) {
								$classes_url = ($timetable_custom_url!="" ? $timetable_custom_url : self::get_event_url($event_hours_tt[$weekday_fixed_number][$i]["name"]));
							}
							$output .= '<li class="timetable_clearfix icon_clock_black"><' . ($classes_url!="" ? 'a' : 'span') . ($classes_url!="" ? ' href="' . $classes_url /*. '#' . urldecode($event_hours_tt[$weekday_fixed_number][$i]["name"])*/ . '"' : '') . ' title="' . htmlentities($event_hours_tt[$weekday_fixed_number][$i]["title"]) . '"' . '>' . $event_hours_tt[$weekday_fixed_number][$i]["title"] . '</' . ($classes_url!="" ? 'a' : 'span') . '>';
							$output .= '<div class="value">
										' . $event_hours_tt[$weekday_fixed_number][$i]["start"] . ' - ' . $event_hours_tt[$weekday_fixed_number][$i]["end"] . '
									</div>
								</li>';
						}
					$output .= '</ul>';
					$l++;
				}
			}
			$output .= '</div>';
		}
		return $output;
	}
	
	public static function tt_hour_in_array($hour, $array, $measure, $hours_min)
	{
//		$db = JFactory::getDbo();
		$array_count = count($array);
		for($i=0; $i<$array_count; $i++)
		{
			if((int)$measure==1)
			{
				if((!isset($array[$i]["displayed"]) || (bool)$array[$i]["displayed"]!=true) && (int)$array[$i]["start"]==(int)$hour)
					return true;
			}
			else
			{
				if((!isset($array[$i]["displayed"]) || (bool)$array[$i]["displayed"]!=true) && self::to_decimal_time(self::roundMin($array[$i]["start"], $measure, $hours_min))==(double)$hour)
					return true;
			}
		}
		return false;
	}

	
	public static function tt_get_rowspan_value($hour, $array, $rowspan, $measure, $hours_min)
	{
		$array_count = count($array);
		$found = false;
		$hours = array();
		if((int)$measure==1)
		{
			for($i=(int)$hour; $i<(int)$hour+$rowspan; $i++)
				$hours[] = $i;
			for($i=0; $i<$array_count; $i++)
			{
				if(in_array((int)$array[$i]["start"], $hours))
				{
					$end_explode = explode(".", $array[$i]["end"]);
					$end_hour = (int)$array[$i]["end"] + ((int)$end_explode[1]>0 ? 1 : 0);
					if($end_hour-(int)$hour>1 && $end_hour-(int)$hour>$rowspan)
					{
						$rowspan = $end_hour-(int)$hour;
						$found = true;
					}
				}
			}
		}
		else
		{
			for($i=(double)$hour; $i<(double)$hour+$rowspan*$measure; $i=$i+$measure)
				$hours[] = $i;
			for($i=0; $i<$array_count; $i++)
			{
				if(in_array(self::to_decimal_time(self::roundMin($array[$i]["start"], $measure, $hours_min)), $hours))
				{
					$end_hour = self::to_decimal_time($array[$i]["end"], false);
					//$end_hour = ($end_hour<24 ? get_next_row_hour($end_hour, $measure) : $end_hour);
					$end_hour = self::get_next_row_hour($end_hour, $measure);
					if($end_hour-(double)$hour>$measure && ($end_hour-(double)$hour)/$measure>$rowspan)
					{
						$rowspan = ($end_hour-(double)$hour)/$measure;
						$found = true;
					}
				}
			}
		}
		if(!$found)
			return $rowspan;
		else
			return self::tt_get_rowspan_value($hour, $array, $rowspan, $measure, $hours_min);
	}

	public static function tt_get_row_content($events, $events_page, $time_format, $event_layout, $global_colors, $disable_event_url)
	{
		$db = JFactory::getDbo();
		$content = "";

		foreach($events as $key=>$details)
		{
			$color = "";
			$hover_color = "";
			$textcolor = "";
			$hover_text_color = "";
			$hours_text_color = "";
			$hours_count = count($details["hours"]);
			if(count($events)>1 || (count($events)==1 && $hours_count>1))
			{
				$color = self::db_get_event_option($details["id"], "color");
//				$color = get_post_meta($details["id"], "timetable_color", true);
				$hover_color = self::db_get_event_option($details["id"], "hover_color");
//				$hover_color = get_post_meta($details["id"], "timetable_hover_color", true);
				if($color=="" && strtoupper($global_colors["box_bg_color"])!="00A27C")
					$color = $global_colors["box_bg_color"];
				if($hover_color=="" && strtoupper($global_colors["box_hover_bg_color"])!="1F736A")
					$hover_color = $global_colors["box_hover_bg_color"];
			}
			$text_color = self::db_get_event_option($details["id"], 'text_color');
							
			if($text_color=="" && strtoupper($global_colors["box_txt_color"])!="FFFFFF")
				$text_color = $global_colors["box_txt_color"];
			
			$hover_text_color = self::db_get_event_option($details["id"], 'hover_text_color');
			if($hover_text_color=="" && strtoupper($global_colors["box_hover_txt_color"])!="FFFFFF")
			{
				$hover_text_color = $global_colors["box_hover_txt_color"];
				if($text_color=="")
					$text_color = "FFFFFF";
			}
			
			$hours_text_color = self::db_get_event_option($details["id"], 'hours_text_color');
			if($hours_text_color=="" && strtoupper($global_colors["box_hours_txt_color"])!="FFFFFF")
				$hours_text_color = $global_colors["box_hours_txt_color"];
			
			$hours_hover_text_color = self::db_get_event_option($details["id"], 'hours_hover_text_color');
			if($hours_hover_text_color=="" && (strtoupper($global_colors["box_hours_hover_txt_color"])!="FFFFFF" || $hours_text_color!=""))
			{
				$hours_hover_text_color = $global_colors["box_hours_hover_txt_color"];
				if($hours_text_color=="")
					$hours_text_color = "FFFFFF";
			}
			
			$timetable_custom_url = self::db_get_event_option($details["id"], 'custom_url');
			$classes_url = "";
			$timetable_disable_url = self::db_get_event_option($details["id"], 'disable_url');
	
			if(!(int)$timetable_disable_url && !(int)$disable_event_url)
				$classes_url = ($timetable_custom_url!="" ? $timetable_custom_url : self::get_event_url($details["name"]));

			$class_link = '<' . ($classes_url!="" ? 'a' : 'span') . ' class="event_header"' . ($classes_url!="" ? ' href="' . $classes_url /*. '#' . urldecode($details["name"])*/ . '"' : '') . ' title="' . htmlentities($details["title"]) . '"' . ($text_color!="" ? ' style="color: #' . $text_color . ' !important;"' : '') . '>' . $details["title"] . '</' . ($classes_url!="" ? 'a' : 'span') . '>';

			for($i=0; $i<$hours_count; $i++)
			{
				$tooltip = "";
				$content .= '<div class="event_container id-' . $details["id"] . (count(array_filter(array_values($details['tooltip']))) && (count($events)>1 || (count($events)==1 && $hours_count>1)) ? ' tt_tooltip' : '' ) . '"' . ($color!="" || ($text_color!="" && (count($events)>1 || (count($events)==1 && $hours_count>1))) ? ' style="' . ($color!="" ? 'background-color: #' . $color . ';' : '') . ($text_color!="" && (count($events)>1 || (count($events)==1 && $hours_count>1)) ? 'color: #' . $text_color . ';' : '') . '"': '') . (($hover_color!="" || $hover_text_color!="" || $hours_hover_text_color!="") && (count($events)>1 || (count($events)==1 && $hours_count>1)) ? ' onMouseOver="' . ($hover_color!="" ? 'this.style.background=\'#'.$hover_color.'\';' : '') . ($hover_text_color!="" ? 'this.style.color=\'#'.$hover_text_color.'\';jQuery(this).find(\'.event_header\').css(\'cssText\', \'color: #'.$hover_text_color.' !important\');' : '') . ($hours_hover_text_color!="" ? 'jQuery(this).find(\'.hours\').css(\'color\',\'#'.$hours_hover_text_color.'\');' : '') . '" onMouseOut="' . ($hover_color!="" ? 'this.style.background=\'#'.$color.'\';' : '') . ($hover_text_color!="" ? 'this.style.color=\'#'.$text_color.'\';jQuery(this).find(\'.event_header\').css(\'cssText\',\'color: #'.$text_color.' !important\');' : '') . ($hours_hover_text_color!="" ? 'jQuery(this).find(\'.hours\').css(\'color\',\'#'.$hours_text_color.'\');' : '') . '"' : '') . '>';
				$hoursExplode = explode(" - ", $details["hours"][$i]);
				$startHour = date($time_format, strtotime($hoursExplode[0]));
				$endHour = date($time_format, strtotime($hoursExplode[1]));

				$description1_content = "";
				if($details["before_hour_text"][$i]!="") {
//					$description1_content = "<div class='before_hour_text'>" . do_shortcode($details["before_hour_text"][$i]) . "</div>";
					$description1_content = "<div class='before_hour_text'>" . $details["before_hour_text"][$i] . "</div>";
				}
				$description2_content = "";
				if($details["after_hour_text"][$i]!="") {
					$description2_content = "<div class='after_hour_text'>" . $details["after_hour_text"][$i] . "</div>";
//					$description2_content = "<div class='after_hour_text'>" . do_shortcode($details["after_hour_text"][$i]) . "</div>";
				}
				$top_hour_content = '<div class="top_hour"><span class="hours"' . ($hours_text_color!="" ? ' style="color:#' . $hours_text_color . ';"' : '') . '>' . $startHour . '</span></div>';
				$bottom_hour_content = '<div class="bottom_hour"><span class="hours"' . ($hours_text_color!="" ? ' style="color:#' . $hours_text_color . ';"' : '') . '>' . $endHour . '</span></div>';
				$hours_content = '<div class="hours_container"><span class="hours"' . ($hours_text_color!="" ? ' style="color:#' . $hours_text_color . ';"' : '') . '>' . $startHour . ' - ' . $endHour . '</span></div>';
				$class_link_tooltip = '<a' . ($hover_text_color!="" ? ' style="color: #' . $hover_text_color . ';"': '') . ' href="' . $classes_url /*. '#' . urldecode($details["name"])*/ . '" title="' . htmlentities($details["title"]) . '">' . $details["title"] . '</a>';
				$tooltip = ($details["tooltip"][$i]!="" ? $class_link_tooltip : '') . $details["tooltip"][$i];

				if((int)$event_layout==1)
				{
					$content .= $class_link;
					$content .= $description1_content;
					$content .= $top_hour_content;
					$content .= $bottom_hour_content;
					$content .= $description2_content;
				}
				else if((int)$event_layout==2)
				{
					$content .= $top_hour_content;
					$content .= $bottom_hour_content;
					$content .= $description1_content;
					$content .= $class_link;
					$content .= $description2_content;
				}
				else if((int)$event_layout==3)
				{
					$content .= $class_link;
					$content .= $description1_content;
					$content .= $hours_content;
					$content .= $description2_content;
				}
				else if((int)$event_layout==4)
				{
					$content .= $class_link;
					$content .= $description1_content;
					$content .= $top_hour_content;
					$content .= $description2_content;
				}
				else if((int)$event_layout==5)
				{
					$content .= $class_link;
					$content .= $description1_content;
					$content .= $description2_content;
				}
				if(count($events)==1 && $hours_count==1)
					$content .= '</div>';
				if($tooltip!="")
				{
					$hover_color = self::db_get_event_option($details["id"], "hover_color");
					
//					$hover_color = get_post_meta($details["id"], "timetable_hover_color", true);
					if($hover_color=="" && strtoupper($global_colors["box_hover_bg_color"])!="1F736A")
						$hover_color = $global_colors["box_hover_bg_color"];
					$content .= '<div class="tt_tooltip_text"><div class="tt_tooltip_content"' . ($hover_color!="" || $hover_text_color!="" ? ' style="' . ($hover_color!="" ? 'background-color: #' . $hover_color . ';' : '') . ($hover_text_color!="" ? 'color: #' . $hover_text_color . ';' : '') . '"': '') . '>' . $tooltip . '</div><div class="tt_tooltip_arrow"' . ($hover_color!="" ? ' style="border-color: #' . $hover_color . ' transparent;"' : '') . '></div></div>';	
				}
				if(count($events)>1 || (count($events)==1 && $hours_count>1))
					$content .= '</div>' . (end($events)!=$details || (end($events)==$details && $i+1<$hours_count) ? '<hr>' : '');
			}


			/*$content .= $class_link;
			$hours_count = count($details["hours"]);
			for($i=0; $i<$hours_count; $i++)
			{
				if($time_format!="H.i")
				{
					$hoursExplode = explode(" - ", $details["hours"][$i]);
					$details["hours"][$i] = date($time_format, strtotime($hoursExplode[0])) . " - " . date($time_format, strtotime($hoursExplode[1]));
				}
				$content .= ($i!=0 ? '<br />' : '');
				if($details["before_hour_text"][$i]!="")
					$content .= "<div class='before_hour_text'>" . $details["before_hour_text"][$i] . "</div>";
				$content .= '<span class="hours"' . ($hours_text_color!="" ? ' style="color:#' . $hours_text_color . ';"' : '') . '>' . $details["hours"][$i] . '</span>';
				if($details["after_hour_text"][$i]!="")
					$content .= "<div class='after_hour_text'>" . $details["after_hour_text"][$i] . "</div>";
				$class_link_tooltip = '<a' . ($hover_text_color!="" ? ' style="color: #' . $hover_text_color . ';"': '') . ' href="' . $classes_url . '#' . urldecode($details["name"]) . '" title="' .  esc_attr($key) . '">' . $key . '</a>';
				$tooltip .= ($tooltip!="" && $details["tooltip"][$i]!="" ? '<br /><br />' : '' ) . ($details["tooltip"][$i]!="" ? $class_link_tooltip : '') . $details["tooltip"][$i];
			}*/
			/*if(count($events)==1)
				$content .= '</div>';
			if($tooltip!="")
			{
				$hover_color = get_post_meta($details["id"], "timetable_hover_color", true);
				$content .= '<div class="tooltip_text"><div class="tooltip_content"' . ($hover_color!="" || $hover_text_color!="" ? ' style="' . ($hover_color!="" ? 'background-color: #' . $hover_color . ';' : '') . ($hover_text_color!="" ? 'color: #' . $hover_text_color . ';' : '') . '"': '') . '>' . $tooltip . '</div><span class="tooltip_arrow"' . ($hover_color!="" ? ' style="border-color: #' . $hover_color . ' transparent;"' : '') . '></span></div>';	
			}

			if(count($events)>1)
				$content .= '</div>' . (end($events)!=$details ? '<hr>' : '');*/
		}
		return $content;
	}
	
	
	public static function to_decimal_time($time, $midReplace = false)
	{
		$timeExplode = explode(".", $time);
		return ($midReplace && (int)$timeExplode[0]==0 ? 24 : $timeExplode[0]) . "." . (isset($timeExplode[1]) && (int)$timeExplode[1]>0 ? sprintf("%02s", ceil($timeExplode[1]/60*100)) : "00");
	}
	
	public static function roundMin($time, $measure, $hours_min)
	{
	
		$decimal_time = self::to_decimal_time($time);
		$found = false;
		while(!$found)
		{
			$hours_min=$hours_min+$measure;
			if($hours_min>$decimal_time)
				$found = true;
		}
		$hours_min = number_format($hours_min-$measure, 2);
		$hours_min_explode = explode(".", $hours_min);
		return str_pad($hours_min_explode[0], 2, '0', STR_PAD_LEFT) . "." . ((int)$hours_min_explode[1]>0 ? (int)$hours_min_explode[1]*60/100 : "00");
	}

	public static function get_next_row_hour($hour, $measure)
	{
		$hourExplode = explode(".", $hour);
		if((int)$hourExplode[1]>0)
		{
			if((int)$hourExplode[1]+$measure*100>100)
			{
				$hour = (int)$hourExplode[0]+1;
				if($hour==24)
					$hour = 0;
				$minutes = "00";
			}
			else if(fmod((int)$hourExplode[1],(double)$measure*100)!=0)
			{
				for($i=0; $i<100; $i=$i+$measure*100)
				{
					if((int)$hourExplode[1]<$i)
					{
						$minutes = $i;
						break;
					}
				}
				$hour = (int)$hourExplode[0];
			}
			else
			{
				$hour = (int)$hourExplode[0];
				$minutes = (int)$hourExplode[1];
			}
		}
		else
		{
			$hour = (int)$hourExplode[0];
			$minutes = (int)$hourExplode[1];
		}
		if($hour . "." . $minutes == "0.00")
			return "24.00";
		return $hour . "." . $minutes;
	}

	public static function db_get_event_option($id, $key)
	{
		$db = JFactory::getDbo();
		$query = "SELECT option_value
			FROM 
				#__timetable_event_options 
			WHERE 
				option_key = '" . $key . "' AND 
				event_id = " . intval($id);
		$db->setQuery($query);
		return $db->loadResult();
	}
	
	public static function db_get_events_by_alias_array($alias_array)
	{
		$db = JFactory::getDbo();
		$alias_array_str = "'" . implode("','", $alias_array) . "'";
		$query = "SELECT id, title, alias 
			FROM 
				#__timetable_events 
			WHERE
				alias IN(" . $alias_array_str . ")
			ORDER BY FIELD(alias, " . $alias_array_str . ");";
		$db->setQuery($query);
		$result = $db->loadAssocList();
		return $result;
	}
	
	public static function db_get_event_categories_by_alias_array($alias_array)
	{
		$db = JFactory::getDbo();
		$alias_array_str = "'" . implode("','", $alias_array) . "'";
		$query = "SELECT id, title, alias 
			FROM 
				#__timetable_categories 
			WHERE
				alias IN(" . $alias_array_str . ")
			ORDER BY FIELD(alias, " . $alias_array_str . ");";
		$db->setQuery($query);
		$result = $db->loadAssocList();
		return $result;
	}
	
	public static function db_get_events_alias_by_category_and_event_id_array($events_category_id, $events_array_id = array())
	{
		$db = JFactory::getDbo();
		$query = "SELECT te.alias FROM #__timetable_events te 
			LEFT JOIN #__timetable_event_categories tec 
			ON te.id=tec.event_id 
			WHERE
				tec.category_id = " . $events_category_id;
		if(count($events_array_id))
			$query .= " AND te.id IN ('".implode("','", $events_array_id)."')";
		$db->setQuery($query);
		$result = $db->loadAssocList();
		return $result;
	}
	
	public static function db_get_events_alias_by_categories_and_event_id_array($events_categories_ids, $events_array_id = array())
	{
		$db = JFactory::getDbo();
		$query = "SELECT te.alias FROM #__timetable_events te 
			LEFT JOIN #__timetable_event_categories tec 
			ON te.id=tec.event_id 
			WHERE
				tec.category_id IN ('".implode("','", $events_categories_ids)."')";
		if(count($events_array_id))
			$query .= " AND te.id IN ('".implode("','", $events_array_id)."')";
		$db->setQuery($query);
		$result = $db->loadAssocList();
		return $result;
	}
	
	public static function db_get_categories_alias_by_event_id($event_id)
	{
		$db = JFactory::getDbo();
		$query = "SELECT tc.alias FROM #__timetable_categories tc
			WHERE tc.id IN 
				(SELECT tec.category_id 
					FROM #__timetable_event_categories tec 
					WHERE tec.event_id=" . $event_id . ")";
		$db->setQuery($query);
		$result = $db->loadAssocList();
		return $result;
	}
	
	public static function get_event_url($event_alias) {
		return JRoute::_("index.php?option=com_timetable&view=event&alias={$event_alias}");
	}
}