<?php
/**
 * @author QuanticaLabs - http://codecanyon.net/user/QuanticaLabs/portfolio?ref=QuanticaLabs
 *
 * @link			http://codecanyon.net/item/timetable-responsive-schedule-for-joomla/9749539?ref=QuanticaLabs
 * @copyright		Copyright (C) 2008 - 2014 quanticalabs.com . All rights reserved.
 * @license			GNU General Public License version 2 or later; see LICENSE under Licensing/ directory
 */
 
defined('_JEXEC') or die('Restricted access');

JHtml::_('behavior.tooltip');
JHtml::_('behavior.formvalidation');
JHtml::_('behavior.keepalive');
JHtml::_('formbehavior.chosen', 'select');

$app = JFactory::getApplication();
$input = $app->input;
?>


<form action="<?php echo JRoute::_('index.php?option=com_timetable&layout=edit&id=' . (int) $this->item->id); ?>"
    method="post" name="adminForm" id="adminForm">
	
	<?php echo JLayoutHelper::render('joomla.edit.title_alias', $this); ?>
	<div class="form-horizontal">
		<?php echo JHtml::_('bootstrap.startTabSet', 'myTab', array('active' => 'details')); ?>
		<?php echo JHtml::_('bootstrap.addTab', 'myTab', 'details', empty($this->item->id) ? JText::_('COM_TIMETABLE_NEW_EVENT', true) : JText::_('COM_TIMETABLE_EDIT_EVENT', true)); ?>
		<div class="row-fluid">
			<div class="span9">
				<div class="form-vertical">					
					<?php echo $this->form->getInput('content');	?>
				</div>
			</div>
			<div class="span3">
				<?php echo JLayoutHelper::render('joomla.edit.global', $this); ?>
			</div>
		</div>
		<?php echo JHtml::_('bootstrap.endTab'); ?>
		
		<?php echo JHtml::_('bootstrap.addTab', 'myTab', 'categories', JText::_('COM_TIMETABLE_EVENT_CATEGORIES', true)) ?>
		<div class="row-fluid">
			<div class="span9">
				<div class="form-vertical">
					<div class="control-group ">
						<div class="control-label"><label id="jform_categories" for="jform_categories" class="" aria-invalid="false"><?php echo JText::_('COM_TIMETABLE_EVENT_CATEGORIES', true);?></label></div>
						<div class="controls">							
							<?php
							if(!empty($this->item->categories)) {
								foreach($this->item->categories as $category) {
									echo '<input type="checkbox" name="jform[categories][]" value="' . $category->id . '" ' . (in_array($category->id, $this->item->event_categories) ? 'checked="checked"' : '') . '>' . $category->title . '<br>';
								}						
							}
							?>
						</div>
					</div>
				</div>
			</div>
			<div class="span3">
				<?php echo JLayoutHelper::render('joomla.edit.global', $this); ?>
			</div>
		</div>
		<?php echo JHtml::_('bootstrap.endTab'); ?>
		
		<?php echo JHtml::_('bootstrap.addTab', 'myTab', 'event_config', JText::_('COM_TIMETABLE_EVENT_OPTIONS', true)); ?>
		<div class="row-fluid">
			<div class="span6">
				<div class="control-group">
					<div class="control-label">
						<?php echo $this->form->getLabel('option_image'); ?>
					</div>
					<div class="controls">
						<?php echo $this->form->getInput('option_image'); ?>
					</div>
				</div>
				<div class="control-group">
					<div class="control-label">
						<?php echo $this->form->getLabel('option_subtitle'); ?>
					</div>
					<div class="controls">
						<?php echo $this->form->getInput('option_subtitle'); ?>
					</div>
				</div>
				<div class="control-group">
					<div class="control-label">
						<?php echo $this->form->getLabel('option_color'); ?>
					</div>
					<div class="controls">
						<?php echo $this->form->getInput('option_color'); ?>
					</div>
				</div>
				<div class="control-group">
					<div class="control-label">
						<?php echo $this->form->getLabel('option_hover_color'); ?>
					</div>
					<div class="controls">
						<?php echo $this->form->getInput('option_hover_color'); ?>
					</div>
				</div>
				<div class="control-group">
					<div class="control-label">
						<?php echo $this->form->getLabel('option_text_color'); ?>
					</div>
					<div class="controls">
						<?php echo $this->form->getInput('option_text_color'); ?>
					</div>
				</div>
				<div class="control-group">
					<div class="control-label">
						<?php echo $this->form->getLabel('option_hover_text_color'); ?>
					</div>
					<div class="controls">
						<?php echo $this->form->getInput('option_hover_text_color'); ?>
					</div>
				</div>
				<div class="control-group">
					<div class="control-label">
						<?php echo $this->form->getLabel('option_hours_text_color'); ?>
					</div>
					<div class="controls">
						<?php echo $this->form->getInput('option_hours_text_color'); ?>
					</div>
				</div>
				<div class="control-group">
					<div class="control-label">
						<?php echo $this->form->getLabel('option_hours_hover_text_color'); ?>
					</div>
					<div class="controls">
						<?php echo $this->form->getInput('option_hours_hover_text_color'); ?>
					</div>
				</div>
				<div class="control-group">
					<div class="control-label">
						<?php echo $this->form->getLabel('option_custom_url'); ?>
					</div>
					<div class="controls">
						<?php echo $this->form->getInput('option_custom_url'); ?>
					</div>
				</div>
				<div class="control-group">
					<div class="control-label">
						<?php echo $this->form->getLabel('option_disable_url'); ?>
					</div>
					<div class="controls">
						<?php echo $this->form->getInput('option_disable_url'); ?>
					</div>
				</div>
			</div>
		</div>
		<?php echo JHtml::_('bootstrap.endTab'); ?>
		
		<?php echo JHtml::_('bootstrap.addTab', 'myTab', 'event_hours', JText::_('COM_TIMETABLE_EVENT_HOURS', true)); ?>
		<div class="row-fluid">
			<div class="span6">
				<ul id="event_hours_list">
					<?php 
					if(!empty($this->item->event_hours)):
					foreach($this->item->event_hours as $event_hour) {?>
					<li id="event_hours_<?php echo $event_hour->id; ?>"><?php echo $this->item->columns[$event_hour->weekday_id]->title . " " . $event_hour->start . "-" . $event_hour->end; ?><img class="operation_button delete_button" src="<?php echo COM_TIMETABLE_IMAGES_URL;?>delete.png" alt="del"><img class="operation_button edit_button" src="<?php echo COM_TIMETABLE_IMAGES_URL;?>edit.png" alt="edit"><img class="operation_button edit_hour_event_loader" src="<?php echo COM_TIMETABLE_IMAGES_URL;?>ajax-loader.gif" alt="loader"><div><br><strong><?php echo JText::_("COM_TIMETABLE_EVENT_HOUR_TOOLTIP");?></strong> <?php echo $event_hour->tooltip; ?><br><strong><?php echo JText::_("COM_TIMETABLE_EVENT_HOUR_DESCRIPTION_1");?></strong> <?php echo $event_hour->before_hour_text; ?><br><strong><?php echo JText::_("COM_TIMETABLE_EVENT_HOUR_DESCRIPTION_2");?></strong> <?php echo $event_hour->after_hour_text; ?><br><strong><?php echo JText::_("COM_TIMETABLE_EVENT_HOUR_CATEGORY");?></strong> <?php echo $event_hour->category; ?></div></li>
					<?php } 
					endif;?>
				</ul>
				<table id="event_hours_table">
					<tr>
						<td>
							<label for="jform_column"><?php echo JText::_('COM_TIMETABLE_COLUMN');?></label>
						</td>
						<td>
							<select id="jform_column" name="jform[column]" class="inputbox">
								<?php
								if(empty($this->item->columns)) {
									echo "<option value=''>" . JText::_('COM_TIMETABLE_CREATE_COLUMNS_ERROR') . "</option>";
								} else {	
									foreach($this->item->columns as $obj) {
										
										echo "<option value='{$obj->id}'>{$obj->title}</option>";
									}
								}
								?>
							</select>
						</td>
					</tr>
					<tr>
						<td>
							<label for="jform_start_hour"><?php echo JText::_('COM_TIMETABLE_EVENT_HOURS_START_HOUR');?></label>
						</td>
						<td>
							<input type="text" name="jform[start_hour]" id="jform_start_hour" value="" class="inputbox" size="40">
						</td>
					</tr>
					<tr>
						<td>
							<label for="jform_end_hour"><?php echo JText::_('COM_TIMETABLE_EVENT_HOURS_END_HOUR');?></label>
						</td>
						<td>
							<input type="text" name="jform[end_hour]" id="jform_end_hour" value="" class="inputbox" size="40">
						</td>
					</tr>
					<tr>
						<td>
							<label for="jform_description_1"><?php echo JText::_('COM_TIMETABLE_EVENT_HOURS_DESCRIPTION_1');?></label>
						</td>
						<td>
							<textarea name="jform[description_1]" id="jform_description_1" class="inputbox"></textarea>
						</td>
					</tr>
					<tr>
						<td>
							<label for="jform_description_2"><?php echo JText::_('COM_TIMETABLE_EVENT_HOURS_DESCRIPTION_2');?></label>
						</td>
						<td>
							<textarea name="jform[description_2]" id="jform_description_2" class="inputbox"></textarea>
						</td>
					</tr>
					<tr>
						<td>
							<label for="jform_tooltip"><?php echo JText::_('COM_TIMETABLE_EVENT_HOURS_TOOLTIP');?></label>
						</td>
						<td>
							<textarea name="jform[tooltip]" id="jform_tooltip" class="inputbox"></textarea>
						</td>
					</tr>
					<tr>
						<td>
							<label for="jform_category"><?php echo JText::_('COM_TIMETABLE_EVENT_HOURS_CATEGORY');?></label>
						</td>
						<td>
							<input type="text" name="jform[category]" id="jform_category" value="" class="inputbox" size="40">
						</td>
					</tr>
					<tr>
						<td colspan="2" style="text-align: right;">
							<input id="add_event_hours" type="button" class="button" value="<?php echo JText::_('COM_TIMETABLE_EVENT_HOURS_ADD'); ?>">
						</td>
					</tr>
				</table>
			</div>
		</div>
		<?php echo JHtml::_('bootstrap.endTab'); ?>
		
		<?php echo JHtml::_('bootstrap.endTabSet'); ?>
	</div>	
	<input type="hidden" name="task" value="" />
	<?php echo JHtml::_('form.token'); ?>
</form>


