<?php
/**
 * @author QuanticaLabs - http://codecanyon.net/user/QuanticaLabs/portfolio?ref=QuanticaLabs
 *
 * @link			http://codecanyon.net/item/timetable-responsive-schedule-for-joomla/9749539?ref=QuanticaLabs
 * @copyright		Copyright (C) 2008 - 2014 quanticalabs.com . All rights reserved.
 * @license			GNU General Public License version 2 or later; see LICENSE under Licensing/ directory
 */
 
defined('_JEXEC') or die('Restricted access');

/**
 * Category View
 */
class TimetableViewCategory extends JViewLegacy
{

	protected $item;
	protected $form;
	protected $state;
	
	public function display($tpl = null)
	{
		// get the Data
		$this->state	= $this->get('State');
		$this->item		= $this->get('Item');
		$this->form		= $this->get('Form');
		
		// Check for errors.
		if (count($errors = $this->get('Errors')))
		{
			JError::raiseError(500, implode('<br />', $errors));
			return false;
		}
		
		
		$this->addToolBar();
		parent::display($tpl);
	}

	/**
	 * Setting the toolbar
	 */
	protected function addToolBar()
	{
		JFactory::getApplication()->input->set('hidemainmenu', true);
		JToolbarHelper::title(JText::_('COM_TIMETABLE_MANAGER_CATEGORY'), 'feed newsfeeds');
		JToolbarHelper::apply('category.apply');
		JToolbarHelper::save('category.save');
		JToolbarHelper::save2new('category.save2new');
		JToolbarHelper::cancel('category.cancel');		
	}
}