<?php
/**
 * @author QuanticaLabs - http://codecanyon.net/user/QuanticaLabs/portfolio?ref=QuanticaLabs
 *
 * @link			http://codecanyon.net/item/timetable-responsive-schedule-for-joomla/9749539?ref=QuanticaLabs
 * @copyright		Copyright (C) 2008 - 2014 quanticalabs.com . All rights reserved.
 * @license			GNU General Public License version 2 or later; see LICENSE under Licensing/ directory
 */
 
defined('_JEXEC') or die('Restricted access');

// import the Joomla modellist library
jimport('joomla.application.component.modellist');

class TimetableModelEvents extends JModelList
{
	
	public function __construct($config = array())
    {
        if (empty($config['filter_fields']))
        {
            $config['filter_fields'] = array(
				'e.id',
                'e.title',
				'e.alias',
            );
        }
        parent::__construct($config);
    }
	
	protected function populateState($ordering = null, $direction = null)
    {
        // Initialise variables.
        $app = JFactory::getApplication('administrator');
 
        // Other code goes here
		$search = $this->getUserStateFromRequest($this->context . '.filter.search', 'filter_search');
		$this->setState('filter.search', $search);
		
        // List state information.
        parent::populateState('e.id', 'asc');
    }
	
	/**
	 * Method to build an SQL query to load the list data.
	 *
	 * @return      string  An SQL query
	 */
	protected function getListQuery()
	{
		// Create a new query object.
		$db = $this->getDbo();
		$query = $db->getQuery(true);
		// Select the required fields from the table.
		$query->select(
			$this->getState(
				'list.select',
				'e.id, e.title, e.alias, e.content, e.published, e.ordering, e.publish_up, e.publish_down'
			)
		);
		$query->from($db->quoteName('#__timetable_events') . ' AS e');
		// Filter by search in title and alias
		$search = $this->getState('filter.search');
		if (!empty($search)) {
			$query->where('e.alias LIKE "%' . $search . '%" or e.title LIKE "%' . $search . '%"');
		}
		return $query;
	}
}