<?php
/**
 * @author QuanticaLabs - http://codecanyon.net/user/QuanticaLabs/portfolio?ref=QuanticaLabs
 *
 * @link			http://codecanyon.net/item/timetable-responsive-schedule-for-joomla/9749539?ref=QuanticaLabs
 * @copyright		Copyright (C) 2008 - 2014 quanticalabs.com . All rights reserved.
 * @license			GNU General Public License version 2 or later; see LICENSE under Licensing/ directory
 */
 
defined('_JEXEC') or die('Restricted access');

/**
 * Columns List Model
 */
class TimetableModelColumns extends JModelList
{
	
	public function __construct($config = array())
    {
        if (empty($config['filter_fields']))
        {
            $config['filter_fields'] = array(
				'c.id',
                'c.title',
				'c.alias',
            );
        }
        parent::__construct($config);
    }
	
	protected function populateState($ordering = null, $direction = null)
    {
        // Initialise variables.
        $app = JFactory::getApplication('administrator');
 
        // Other code goes here
		$search = $this->getUserStateFromRequest($this->context . '.filter.search', 'filter_search');
		$this->setState('filter.search', $search);
		
        // List state information.
        parent::populateState('c.id', 'asc');
    }
	
	/**
	 * Method to build an SQL query to load the list data.
	 *
	 * @return      string  An SQL query
	 */
	protected function getListQuery()
	{
		
		// Create a new query object.
		$db = $this->getDbo();
		$query = $db->getQuery(true);
		// Select the required fields from the table.
		$query->select(
			$this->getState(
				'list.select',
				'c.id, c.title, c.alias, c.published, c.ordering, c.publish_up, c.publish_down'
			)
		);
		$query->from($db->quoteName('#__timetable_columns') . ' AS c');
		// Filter by search in title and alias
		$search = $this->getState('filter.search');
		if (!empty($search)) {
			$query->where('c.alias LIKE "%' . $search . '%" or c.title LIKE "%' . $search . '%"');
		}
		
		return $query;
		
	}
}