<?php
/**
 * @author QuanticaLabs - http://codecanyon.net/user/QuanticaLabs/portfolio?ref=QuanticaLabs
 *
 * @link			http://codecanyon.net/item/timetable-responsive-schedule-for-joomla/9749539?ref=QuanticaLabs
 * @copyright		Copyright (C) 2008 - 2014 quanticalabs.com . All rights reserved.
 * @license			GNU General Public License version 2 or later; see LICENSE under Licensing/ directory
 */
 
defined('_JEXEC') or die('Restricted access');

class TimetableControllerTimetable extends JControllerForm {
	
	public function time_format() {	
		if(empty($_POST["time"]))
			die;
		
		$time = "";
		$time_format = $_POST["time"];
		$time = date($time_format);
		echo $time;
		die;
	}
	
	public function insert_menu(){
		$db = JFactory::getDbo();
		$query = "SELECT 
				extension_id 
			FROM 
				#__extensions
			WHERE
				name = 'com_content';";
		$db->setQuery($query);
		$component_id = $db->loadResult();

		$query = "SELECT 
				id, alias
			FROM 
				#__content
			WHERE
				alias IN ('timetable-for-joomla-sample-1', 
					'timetable-for-joomla-sample-2', 
					'timetable-for-joomla-sample-3',
					'timetable-for-joomla-sample-4',
					'timetable-for-joomla-sample-5')
			ORDER BY id ASC";
		$db->setQuery($query);
		$timetable_articles = $db->loadObjectList("alias");

		// create hidden menu
		$query = "INSERT IGNORE INTO 
			#__menu_types(menutype, title) 
			VALUES('timetable-hidden-menu', 'Timetable Hidden Menu');";
		$db->setQuery($query);
		$db->execute();
		
		// insert 5 menu items for 5 articles
		$query = "INSERT IGNORE INTO `#__menu` (`menutype`, `title`, `alias`, `note`, `path`, `link`, `type`, `published`, `parent_id`, `level`, `component_id`, `checked_out`, `checked_out_time`, `browserNav`, `access`, `img`, `template_style_id`, `params`, `lft`, `rgt`, `home`, `language`, `client_id`) VALUES
	('timetable-hidden-menu', 'Timetable for Joomla sample 1', 'timetable-for-joomla-sample-1', '', 'timetable-for-joomla-sample-1', 'index.php?option=com_content&view=article&id={$timetable_articles["timetable-for-joomla-sample-1"]->id}', 'component', 1, 1, 1, {$component_id}, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_vote\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_hits\":\"\",\"show_tags\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}', 195, 196, 0, '*', 0),
	('timetable-hidden-menu', 'Timetable for Joomla sample 2', 'timetable-for-joomla-sample-2', '', 'timetable-for-joomla-sample-2', 'index.php?option=com_content&view=article&id={$timetable_articles["timetable-for-joomla-sample-2"]->id}', 'component', 1, 1, 1, {$component_id}, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_vote\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_hits\":\"\",\"show_tags\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}', 197, 198, 0, '*', 0),
	('timetable-hidden-menu', 'Timetable for Joomla sample 3', 'timetable-for-joomla-sample-3', '', 'timetable-for-joomla-sample-3', 'index.php?option=com_content&view=article&id={$timetable_articles["timetable-for-joomla-sample-3"]->id}', 'component', 1, 1, 1, {$component_id}, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_vote\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_hits\":\"\",\"show_tags\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}', 199, 200, 0, '*', 0),
	('timetable-hidden-menu', 'Timetable for Joomla sample 4', 'timetable-for-joomla-sample-4', '', 'timetable-for-joomla-sample-4', 'index.php?option=com_content&view=article&id={$timetable_articles["timetable-for-joomla-sample-4"]->id}', 'component', 1, 1, 1, {$component_id}, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_vote\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_hits\":\"\",\"show_tags\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}', 201, 202, 0, '*', 0),
	('timetable-hidden-menu', 'Timetable for Joomla sample 5', 'timetable-for-joomla-sample-5', '', 'timetable-for-joomla-sample-5', 'index.php?option=com_content&view=article&id={$timetable_articles["timetable-for-joomla-sample-5"]->id}', 'component', 1, 1, 1, {$component_id}, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_vote\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_hits\":\"\",\"show_tags\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}', 203, 204, 0, '*', 0);";
	
		$db->setQuery($query);
		$db->execute();
	}
	
	/**
	 * Event modules must have reference to menu module table, 
	 * otherwise they won't be displayed on Event page
	 */
	public function insert_module_menu() {
		$db = JFactory::getDbo();
		// insert menu items for modules
		$query = "SELECT 
				id
			FROM 
				#__modules
			WHERE
				position IN ('event-sidebar')
			ORDER BY id ASC";
		$db->setQuery($query);
		$event_modules = $db->loadObjectList();
		
		foreach($event_modules as $event_module) {
			$query = "INSERT IGNORE INTO 
				#__modules_menu(moduleid, menuid) 
				VALUES({$event_module->id}, 0)";
			$db->setQuery($query);
			$db->execute();
		}
		
	}
	
	public function import_dummy() {
		require_once(dirname(dirname(__FILE__)) . "/config.php");
		
		$result = array("info" => "");
		$db = JFactory::getDbo();
		$app = JFactory::getApplication();
				
		$dummy_content = file_get_contents(COM_TIMETABLE_SQL_PATH . "dummy-timetable.sql");
		$queries = $db->splitSql($dummy_content);
		foreach($queries as $query) {
			if(!empty($query)) {
				// replace COM_TIMETABLE_MEDIA_IMAGES text with an actual URL to the /media/com_timetable/images/ folder
				$query = str_replace("COM_TIMETABLE_MEDIA_IMAGES_URL", COM_TIMETABLE_MEDIA_IMAGES_URL, $query);
			
				// Unfortunately the #__content table doesn't consider the 'alias' field as unique
				// that's why we need to check if the articles already exist
				if(strpos($query, "#__content")!== false) {
					$query_2 = "SELECT COUNT(*) FROM #__content WHERE alias in ('timetable-for-joomla-sample-1', 'timetable-for-joomla-sample-2', 'timetable-for-joomla-sample-3', 'timetable-for-joomla-sample-4', 'timetable-for-joomla-sample-5') ";
					$db->setQuery($query_2);
					$db->execute();
					$articles_count = $db->loadResult();
					// if there're already articles in the #__content table, then we will skip adding them
					if($articles_count>0)
						continue;
				}
				
				try {
					$db->setQuery($query);
					$db->execute();
				} catch(Exception $e) { }
			}
		}
		$this->insert_menu();
		$this->insert_module_menu();
		
		$result["info"] = "Timetable dummy content has been imported successfully!";
		echo "dummy_import_start" . json_encode($result) . "dummy_import_end";
		$app->close();
	}
	
	
	public function delete_content() {
		$result = array("info" => "");
		$db = JFactory::getDbo();
		$app = JFactory::getApplication();
		$delete_content = file_get_contents(COM_TIMETABLE_SQL_PATH . "delete-content.sql");
		$queries = $db->splitSql($delete_content);
		foreach($queries as $query) {
			if(!empty($query)) {
				try {
					$db->setQuery($query);
					$db->execute();
				} catch(Exception $e) { }
			}
		}
		
		$result["info"] = "Timetable content has been deleted successfully!";
		echo "delete_content_start" . json_encode($result) . "delete_content_end";
		$app->close();
	}
	
	function get_font_subsets() {
		$app = JFactory::getApplication();
		$font = $_POST["font"];
		if(!empty($font)) {
			$subsets = '';
			$fontExplode = explode(":", $font);
			$fontsArray = TimetableUtils::getGoogleFonts();			
			$fontsCount = count($fontsArray->items);
			for($i=0; $i<$fontsCount; $i++)
			{
				if($fontsArray->items[$i]->family==$fontExplode[0])
				{
					for($j=0; $j<count($fontsArray->items[$i]->subsets); $j++)
					{
						$subsets .= '<option value="' . $fontsArray->items[$i]->subsets[$j] . '">' . $fontsArray->items[$i]->subsets[$j] . '</option>';
					}
					break;
				}
			}
			echo "timetable_start" . $subsets . "timetable_end";
		}
		$app->close();
	}
}